/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.commands;

import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.karaf.shell.commands.utils.PumpStreamHandler;
import org.apache.felix.karaf.shell.console.OsgiCommandSupport;

@Command(scope="shell", name="exec", description="Executes system processes")
public class ExecuteAction
extends OsgiCommandSupport {
    @Argument(index=0, name="command", description="Execution command with arguments", required=true, multiValued=true)
    private List<String> args;

    protected Object doExecute() throws Exception {
        ProcessBuilder builder = new ProcessBuilder(this.args);
        PumpStreamHandler handler = new PumpStreamHandler(System.in, System.out, System.err);
        this.log.info("Executing: {}", builder.command());
        Process p = builder.start();
        handler.attach(p);
        handler.start();
        this.log.debug("Waiting for process to exit...");
        int status = p.waitFor();
        this.log.info("Process exited w/status: {}", (Object)status);
        handler.stop();
        return null;
    }
}

