/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.util;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameworkUtils {
    private FrameworkUtils() {
    }

    public static Bundle resolveBundle(BundleContext bundleContext, long bundleId) throws IllegalArgumentException {
        if (bundleContext == null) {
            throw new IllegalArgumentException("Argument bundleContext cannot be null");
        }
        Bundle bundle = bundleContext.getBundle(bundleId);
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle with id [" + bundleId + "] Not Found");
        }
        return bundle;
    }

    public static long[] getBundleIds(Bundle[] bundles) {
        long[] result = bundles == null ? new long[]{} : new long[bundles.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = bundles[i].getBundleId();
        }
        return result;
    }

    public static ServiceReference resolveService(BundleContext bundleContext, long serviceId) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("Argument bundleContext cannot be null");
        }
        ServiceReference result = null;
        try {
            ServiceReference[] references = bundleContext.getAllServiceReferences(null, "(service.id=" + serviceId + ")");
            if (references == null || references.length < 1) {
                throw new IllegalArgumentException("Service with id [" + serviceId + "] Not Found");
            }
            result = references[0];
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("Failure when resolving service ", e);
        }
        return result;
    }

    public static long[] getServiceIds(ServiceReference[] serviceReferences) {
        long[] result = serviceReferences == null ? new long[]{} : new long[serviceReferences.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Long)serviceReferences[i].getProperty("service.id");
        }
        return result;
    }

    public static String[] getBundleExportedPackages(Bundle bundle, PackageAdmin packageAdmin) throws IllegalArgumentException {
        String[] exportedPackages;
        if (bundle == null) {
            throw new IllegalArgumentException("Argument bundle cannot be null");
        }
        if (packageAdmin == null) {
            throw new IllegalArgumentException("Argument packageAdmin cannot be null");
        }
        ExportedPackage[] exported = packageAdmin.getExportedPackages(bundle);
        if (exported != null) {
            exportedPackages = new String[exported.length];
            for (int i = 0; i < exported.length; ++i) {
                exportedPackages[i] = exported[i].getName() + ";" + exported[i].getVersion().toString();
            }
        } else {
            exportedPackages = new String[]{};
        }
        return exportedPackages;
    }

    public static long[] getFragmentIds(Bundle bundle, PackageAdmin packageAdmin) throws IllegalArgumentException {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument bundle cannot be null");
        }
        if (packageAdmin == null) {
            throw new IllegalArgumentException("Argument packageAdmin cannot be null");
        }
        Bundle[] fragments = packageAdmin.getFragments(bundle);
        long[] fragmentIds = fragments != null ? FrameworkUtils.getBundleIds(fragments) : new long[]{};
        return fragmentIds;
    }

    public static long[] getHostIds(Bundle fragment, PackageAdmin packageAdmin) throws IllegalArgumentException {
        if (fragment == null) {
            throw new IllegalArgumentException("Argument bundle cannot be null");
        }
        if (packageAdmin == null) {
            throw new IllegalArgumentException("Argument packageAdmin cannot be null");
        }
        Bundle[] hosts = packageAdmin.getHosts(fragment);
        long[] hostIds = hosts != null ? FrameworkUtils.getBundleIds(hosts) : new long[]{};
        return hostIds;
    }

    public static String[] getBundleImportedPackages(BundleContext localBundleContext, Bundle bundle, PackageAdmin packageAdmin) throws IllegalArgumentException {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument bundle cannot be null");
        }
        if (packageAdmin == null) {
            throw new IllegalArgumentException("Argument packageAdmin cannot be null");
        }
        ArrayList<String> result = new ArrayList<String>();
        Dictionary bundleHeaders = bundle.getHeaders();
        String dynamicImportHeader = (String)bundleHeaders.get("DynamicImport-Package");
        if (dynamicImportHeader != null && dynamicImportHeader.contains("*")) {
            Bundle[] bundles;
            for (Bundle candidate : bundles = localBundleContext.getBundles()) {
                ExportedPackage[] candidateExports;
                if (candidate.equals(bundle) || (candidateExports = packageAdmin.getExportedPackages(candidate)) == null) continue;
                for (ExportedPackage exportedPackage : candidateExports) {
                    Object[] userBundles = exportedPackage.getImportingBundles();
                    if (userBundles == null || !FrameworkUtils.arrayContains(userBundles, bundle)) continue;
                    result.add(exportedPackage.getName() + ";" + exportedPackage.getVersion().toString());
                }
            }
        } else {
            ArrayList<String> importPackages = new ArrayList<String>();
            String importPackageHeader = (String)bundleHeaders.get("Import-Package");
            if (importPackageHeader != null && importPackageHeader.length() > 0) {
                importPackages.addAll(FrameworkUtils.extractHeaderDeclaration(importPackageHeader));
            }
            if (dynamicImportHeader != null) {
                importPackages.addAll(FrameworkUtils.extractHeaderDeclaration(dynamicImportHeader));
            }
            for (String packageName : importPackages) {
                ExportedPackage[] candidateExports = packageAdmin.getExportedPackages(packageName);
                if (candidateExports == null) continue;
                for (ExportedPackage exportedPackage : candidateExports) {
                    Object[] userBundles = exportedPackage.getImportingBundles();
                    if (userBundles == null || !FrameworkUtils.arrayContains(userBundles, bundle)) continue;
                    result.add(exportedPackage.getName() + ";" + exportedPackage.getVersion().toString());
                }
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static long[] getRegisteredServiceIds(Bundle bundle) throws IllegalArgumentException, IllegalStateException {
        long[] serviceIds;
        if (bundle == null) {
            throw new IllegalArgumentException("Argument bundle cannot be null");
        }
        ServiceReference[] serviceReferences = bundle.getRegisteredServices();
        if (serviceReferences != null) {
            serviceIds = new long[serviceReferences.length];
            for (int i = 0; i < serviceReferences.length; ++i) {
                serviceIds[i] = (Long)serviceReferences[i].getProperty("service.id");
            }
        } else {
            serviceIds = new long[]{};
        }
        return serviceIds;
    }

    public static long[] getServicesInUseByBundle(Bundle bundle) throws IllegalArgumentException, IllegalStateException {
        long[] serviceIds;
        if (bundle == null) {
            throw new IllegalArgumentException("Argument bundle cannot be null");
        }
        ServiceReference[] serviceReferences = bundle.getServicesInUse();
        if (serviceReferences != null) {
            serviceIds = new long[serviceReferences.length];
            for (int i = 0; i < serviceReferences.length; ++i) {
                serviceIds[i] = (Long)serviceReferences[i].getProperty("service.id");
            }
        } else {
            serviceIds = new long[]{};
        }
        return serviceIds;
    }

    public static boolean isBundlePendingRemoval(Bundle bundle, PackageAdmin packageAdmin) throws IllegalArgumentException {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument bundle cannot be null");
        }
        if (packageAdmin == null) {
            throw new IllegalArgumentException("Argument packageAdmin cannot be null");
        }
        boolean result = false;
        RequiredBundle[] requiredBundles = packageAdmin.getRequiredBundles(bundle.getSymbolicName());
        if (requiredBundles != null) {
            for (RequiredBundle requiredBundle : requiredBundles) {
                Bundle required = requiredBundle.getBundle();
                if (required == null || !required.equals(bundle)) continue;
                result = requiredBundle.isRemovalPending();
                break;
            }
        }
        return result;
    }

    public static boolean isBundleRequiredByOthers(Bundle bundle, PackageAdmin packageAdmin) throws IllegalArgumentException {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument bundle cannot be null");
        }
        if (packageAdmin == null) {
            throw new IllegalArgumentException("Argument packageAdmin cannot be null");
        }
        boolean result = false;
        RequiredBundle[] requiredBundles = packageAdmin.getRequiredBundles(bundle.getSymbolicName());
        if (requiredBundles != null) {
            for (RequiredBundle requiredBundle : requiredBundles) {
                Bundle[] requiring;
                Bundle required = requiredBundle.getBundle();
                if (required == null || !required.equals(bundle) || (requiring = requiredBundle.getRequiringBundles()) == null || requiring.length <= 0) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static long[] getBundleDependencies(BundleContext localBundleContext, Bundle bundle, PackageAdmin packageAdmin) throws IllegalArgumentException {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument bundle cannot be null");
        }
        if (packageAdmin == null) {
            throw new IllegalArgumentException("Argument packageAdmin cannot be null");
        }
        ArrayList<Bundle> dependencies = new ArrayList<Bundle>();
        Dictionary bundleHeaders = bundle.getHeaders();
        String requireBundleHeader = (String)bundleHeaders.get("Require-Bundle");
        if (requireBundleHeader != null) {
            List<String> bundleSymbolicNames = FrameworkUtils.extractHeaderDeclaration(requireBundleHeader);
            for (String bundleSymbolicName : bundleSymbolicNames) {
                RequiredBundle[] candidateRequiredBundles = packageAdmin.getRequiredBundles(bundleSymbolicName);
                if (candidateRequiredBundles == null) continue;
                for (RequiredBundle candidateRequiredBundle : candidateRequiredBundles) {
                    Object[] bundlesRequiring = candidateRequiredBundle.getRequiringBundles();
                    if (bundlesRequiring == null || !FrameworkUtils.arrayContains(bundlesRequiring, bundle)) continue;
                    dependencies.add(candidateRequiredBundle.getBundle());
                }
            }
        }
        return FrameworkUtils.getBundleIds(dependencies.toArray(new Bundle[dependencies.size()]));
    }

    public static long[] getDependentBundles(Bundle bundle, PackageAdmin packageAdmin) throws IllegalArgumentException {
        if (bundle == null) {
            throw new IllegalArgumentException("Argument bundle cannot be null");
        }
        if (packageAdmin == null) {
            throw new IllegalArgumentException("Argument packageAdmin cannot be null");
        }
        long[] bundleIds = new long[]{};
        RequiredBundle[] requiredBundles = packageAdmin.getRequiredBundles(bundle.getSymbolicName());
        if (requiredBundles != null) {
            for (RequiredBundle requiredBundle : requiredBundles) {
                Bundle required = requiredBundle.getBundle();
                if (required == null || !required.equals(bundle)) continue;
                bundleIds = FrameworkUtils.getBundleIds(requiredBundle.getRequiringBundles());
            }
        }
        return bundleIds;
    }

    public static String getBundleState(Bundle bundle) {
        String state = "UNKNOWN";
        switch (bundle.getState()) {
            case 2: {
                state = "INSTALLED";
                break;
            }
            case 4: {
                state = "RESOLVED";
                break;
            }
            case 8: {
                state = "STARTING";
                break;
            }
            case 32: {
                state = "ACTIVE";
                break;
            }
            case 16: {
                state = "STOPPING";
                break;
            }
            case 1: {
                state = "UNINSTALLED";
            }
        }
        return state;
    }

    public static boolean arrayContains(Object[] array, Object value) {
        boolean result = false;
        if (array != null && value != null) {
            for (Object element : array) {
                if (!value.equals(element)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static List<String> extractHeaderDeclaration(String headerStatement) {
        ArrayList<String> result = new ArrayList<String>();
        for (String headerDeclaration : headerStatement.split("\\s*,\\s*")) {
            String name = headerDeclaration.contains(";") ? headerDeclaration.substring(0, headerDeclaration.indexOf(";")) : headerDeclaration;
            result.add(name);
        }
        return result;
    }
}

