/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.permissionadmin;

import java.io.IOException;
import org.osgi.jmx.service.permissionadmin.PermissionAdminMBean;
import org.osgi.service.permissionadmin.PermissionInfo;

public class PermissionAdmin
implements PermissionAdminMBean {
    private org.osgi.service.permissionadmin.PermissionAdmin permAdmin;

    public PermissionAdmin(org.osgi.service.permissionadmin.PermissionAdmin permAdmin) {
        this.permAdmin = permAdmin;
    }

    public String[] getPermissions(String location) throws IOException {
        PermissionInfo[] permissions = this.permAdmin.getPermissions(location);
        if (permissions != null) {
            String[] encoded = new String[permissions.length];
            for (int i = 0; i < permissions.length; ++i) {
                PermissionInfo info = permissions[i];
                encoded[i] = info.getEncoded();
            }
            return encoded;
        }
        return null;
    }

    public String[] listDefaultPermissions() throws IOException {
        PermissionInfo[] permissions = this.permAdmin.getDefaultPermissions();
        if (permissions != null) {
            String[] encoded = new String[permissions.length];
            for (int i = 0; i < permissions.length; ++i) {
                PermissionInfo info = permissions[i];
                encoded[i] = info.getEncoded();
            }
            return encoded;
        }
        return null;
    }

    public String[] listLocations() throws IOException {
        return this.permAdmin.getLocations();
    }

    public void setDefaultPermissions(String[] encodedPermissions) throws IOException {
        if (encodedPermissions == null) {
            this.permAdmin.setDefaultPermissions(null);
            return;
        }
        PermissionInfo[] permissions = new PermissionInfo[encodedPermissions.length];
        for (int i = 0; i < encodedPermissions.length; ++i) {
            permissions[i] = new PermissionInfo(encodedPermissions[i]);
        }
        this.permAdmin.setDefaultPermissions(permissions);
    }

    public void setPermissions(String location, String[] encodedPermissions) throws IOException {
        if (encodedPermissions == null) {
            this.permAdmin.setPermissions(location, null);
            return;
        }
        PermissionInfo[] permissions = new PermissionInfo[encodedPermissions.length];
        for (int i = 0; i < encodedPermissions.length; ++i) {
            permissions[i] = new PermissionInfo(encodedPermissions[i]);
        }
        this.permAdmin.setPermissions(location, permissions);
    }
}

