/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.compendium.cm;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.aries.blueprint.BeanProcessor;
import org.apache.aries.blueprint.ExtendedBlueprintContainer;
import org.apache.aries.blueprint.compendium.cm.CmUtils;
import org.apache.aries.blueprint.compendium.cm.ManagedObject;
import org.apache.aries.blueprint.compendium.cm.ManagedObjectManager;
import org.apache.aries.blueprint.utils.ReflectionUtils;
import org.osgi.framework.Bundle;
import org.osgi.service.blueprint.container.ReifiedType;
import org.osgi.service.blueprint.reflect.BeanMetadata;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmManagedProperties
implements ManagedObject,
BeanProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmManagedProperties.class);
    private ExtendedBlueprintContainer blueprintContainer;
    private ConfigurationAdmin configAdmin;
    private ManagedObjectManager managedObjectManager;
    private String persistentId;
    private String updateStrategy;
    private String updateMethod;
    private String beanName;
    private final Object lock = new Object();
    private final Set<Object> beans = new HashSet<Object>();
    private Dictionary<String, Object> properties;

    public ExtendedBlueprintContainer getBlueprintContainer() {
        return this.blueprintContainer;
    }

    public void setBlueprintContainer(ExtendedBlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public void setManagedObjectManager(ManagedObjectManager managedObjectManager) {
        this.managedObjectManager = managedObjectManager;
    }

    public ManagedObjectManager getManagedObjectManager() {
        return this.managedObjectManager;
    }

    public Bundle getBundle() {
        return this.blueprintContainer.getBundleContext().getBundle();
    }

    public String getPersistentId() {
        return this.persistentId;
    }

    public void setPersistentId(String persistentId) {
        this.persistentId = persistentId;
    }

    public String getUpdateStrategy() {
        return this.updateStrategy;
    }

    public void setUpdateStrategy(String updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public String getUpdateMethod() {
        return this.updateMethod;
    }

    public void setUpdateMethod(String updateMethod) {
        this.updateMethod = updateMethod;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        LOGGER.debug("Initializing CmManagedProperties for bean={} / pid={}", (Object)this.beanName, (Object)this.persistentId);
        Properties props = new Properties();
        props.put("service.pid", this.persistentId);
        Bundle bundle = this.blueprintContainer.getBundleContext().getBundle();
        props.put("Bundle-SymbolicName", bundle.getSymbolicName());
        props.put("Bundle-Version", bundle.getHeaders().get("Bundle-Version"));
        Object object = this.lock;
        synchronized (object) {
            this.managedObjectManager.register(this, props);
            Configuration config = CmUtils.getConfiguration(this.configAdmin, this.persistentId);
            if (config != null) {
                this.properties = config.getProperties();
            }
        }
    }

    public void destroy() {
        this.managedObjectManager.unregister(this);
    }

    public void updated(final Dictionary props) {
        LOGGER.debug("Configuration updated for bean={} / pid={}", (Object)this.beanName, (Object)this.persistentId);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = CmManagedProperties.this.lock;
                synchronized (object) {
                    CmManagedProperties.this.properties = props;
                    for (Object bean : CmManagedProperties.this.beans) {
                        CmManagedProperties.this.inject(bean, false);
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object beforeInit(Object bean, String beanName, BeanProcessor.BeanCreator beanCreator, BeanMetadata beanData) {
        if (beanName != null && beanName.equals(this.beanName)) {
            LOGGER.debug("Adding bean for bean={} / pid={}", (Object)beanName, (Object)this.persistentId);
            Object object = this.lock;
            synchronized (object) {
                this.beans.add(bean);
                this.inject(bean, true);
            }
        }
        return bean;
    }

    public Object afterInit(Object bean, String beanName, BeanProcessor.BeanCreator beanCreator, BeanMetadata beanData) {
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDestroy(Object bean, String beanName) {
        if (beanName.equals(this.beanName)) {
            LOGGER.debug("Removing bean for bean={} / pid={}", (Object)beanName, (Object)this.persistentId);
            Object object = this.lock;
            synchronized (object) {
                this.beans.remove(bean);
            }
        }
    }

    public void afterDestroy(Object bean, String beanName) {
    }

    private void inject(Object bean, boolean initial) {
        block21: {
            block20: {
                LOGGER.debug("Injecting bean for bean={} / pid={}", (Object)this.beanName, (Object)this.persistentId);
                LOGGER.debug("Configuration: {}", this.properties);
                if (!initial && !"container-managed".equals(this.updateStrategy)) break block20;
                if (this.properties == null) break block21;
                Enumeration<String> e = this.properties.keys();
                while (e.hasMoreElements()) {
                    String key = e.nextElement();
                    Object val = this.properties.get(key);
                    String setterName = "set" + Character.toUpperCase(key.charAt(0));
                    if (key.length() > 0) {
                        setterName = setterName + key.substring(1);
                    }
                    LinkedHashSet<Method> validSetters = new LinkedHashSet<Method>();
                    ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(bean.getClass().getMethods()));
                    methods.addAll(Arrays.asList(bean.getClass().getDeclaredMethods()));
                    for (Method method : methods) {
                        Object propertyValue;
                        if (!method.getName().equals(setterName)) continue;
                        if (method.getParameterTypes().length == 0) {
                            LOGGER.debug("Setter takes no parameters: {}", (Object)method);
                            continue;
                        }
                        if (method.getParameterTypes().length > 1) {
                            LOGGER.debug("Setter takes more than one parameter: {}", (Object)method);
                            continue;
                        }
                        if (method.getReturnType() != Void.TYPE) {
                            LOGGER.debug("Setter returns a value: {}", (Object)method);
                            continue;
                        }
                        if (Modifier.isAbstract(method.getModifiers())) {
                            LOGGER.debug("Setter is abstract: {}", (Object)method);
                            continue;
                        }
                        if (!Modifier.isPublic(method.getModifiers())) {
                            LOGGER.debug("Setter is not public: {}", (Object)method);
                            continue;
                        }
                        if (Modifier.isStatic(method.getModifiers())) {
                            LOGGER.debug("Setter is static: {}", (Object)method);
                            continue;
                        }
                        Class<?> methodParameterType = method.getParameterTypes()[0];
                        try {
                            propertyValue = this.blueprintContainer.getConverter().convert(val, new ReifiedType(methodParameterType));
                        }
                        catch (Throwable t) {
                            LOGGER.debug("Unable to convert value for setter: " + method, t);
                            continue;
                        }
                        if (methodParameterType.isPrimitive() && propertyValue == null) {
                            LOGGER.debug("Null can not be assigned to {}: {}", (Object)methodParameterType.getName(), (Object)method);
                            continue;
                        }
                        if (!validSetters.add(method)) continue;
                        try {
                            method.invoke(bean, propertyValue);
                        }
                        catch (Exception t) {
                            LOGGER.debug("Setter can not be invoked: " + method, CmManagedProperties.getRealCause(t));
                        }
                    }
                    if (!validSetters.isEmpty()) continue;
                    LOGGER.debug("Unable to find a valid setter method for property {} and value {}", (Object)key, val);
                }
                break block21;
            }
            if ("component-managed".equals(this.updateStrategy) && this.updateMethod != null) {
                List<Method> methods = ReflectionUtils.findCompatibleMethods(bean.getClass(), this.updateMethod, new Class[]{Map.class});
                HashMap<String, Object> map = null;
                if (this.properties != null) {
                    map = new HashMap<String, Object>();
                    Enumeration<String> e = this.properties.keys();
                    while (e.hasMoreElements()) {
                        String key = e.nextElement();
                        Object val = this.properties.get(key);
                        map.put(key, val);
                    }
                }
                for (Method method : methods) {
                    try {
                        method.invoke(bean, map);
                    }
                    catch (Throwable t) {
                        LOGGER.warn("Unable to call method " + method + " on bean " + this.beanName, CmManagedProperties.getRealCause(t));
                    }
                }
            }
        }
    }

    private static Throwable getRealCause(Throwable t) {
        if (t instanceof InvocationTargetException && t.getCause() != null) {
            return t.getCause();
        }
        return t;
    }
}

