/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.console.completer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.karaf.shell.console.CompletableFunction;
import org.apache.felix.karaf.shell.console.Completer;
import org.apache.felix.karaf.shell.console.completer.AggregateCompleter;
import org.apache.felix.karaf.shell.console.completer.ArgumentCompleter;
import org.apache.felix.karaf.shell.console.completer.NullCompleter;
import org.apache.felix.karaf.shell.console.completer.StringsCompleter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandsCompleter
implements Completer {
    private final Map<ServiceReference, Completer> completers = new ConcurrentHashMap<ServiceReference, Completer>();
    private BundleContext bundleContext;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ServiceReference reference) {
        Set<String> functions = this.getNames(reference);
        if (functions != null) {
            ArrayList<Completer> cl = new ArrayList<Completer>();
            cl.add(new StringsCompleter(functions));
            try {
                Object function = this.bundleContext.getService(reference);
                if (function instanceof CompletableFunction) {
                    List<Completer> fcl = ((CompletableFunction)function).getCompleters();
                    if (fcl != null) {
                        for (Completer c : fcl) {
                            cl.add(c == null ? NullCompleter.INSTANCE : c);
                        }
                    } else {
                        cl.add(NullCompleter.INSTANCE);
                    }
                } else {
                    cl.add(NullCompleter.INSTANCE);
                }
            }
            finally {
                this.bundleContext.ungetService(reference);
            }
            ArgumentCompleter c = new ArgumentCompleter(cl);
            this.completers.put(reference, c);
        }
    }

    public void unregister(ServiceReference reference) {
        if (reference != null) {
            this.completers.remove(reference);
        }
    }

    private Set<String> getNames(ServiceReference reference) {
        HashSet<String> names = new HashSet<String>();
        Object scope = reference.getProperty("osgi.command.scope");
        Object function = reference.getProperty("osgi.command.function");
        if (scope != null && function != null) {
            if (function.getClass().isArray()) {
                for (Object f : (Object[])function) {
                    names.add(scope + ":" + f.toString());
                }
            } else {
                names.add(scope + ":" + function.toString());
            }
            return names;
        }
        return null;
    }

    @Override
    public int complete(String buffer, int cursor, List<String> candidates) {
        int res = new AggregateCompleter(this.completers.values()).complete(buffer, cursor, (List)candidates);
        Collections.sort(candidates);
        return res;
    }
}

