/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.osgi;

import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.karaf.shell.console.OsgiCommandSupport;
import org.apache.felix.karaf.shell.osgi.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.command.Function;

@Command(scope="osgi", name="ls", description="Lists OSGi services")
public class ListServices
extends OsgiCommandSupport {
    @Option(name="-a", aliases={}, description="Shows all services", required=false, multiValued=false)
    boolean showAll;
    @Option(name="-u", aliases={}, description="Shows services which are in use", required=false, multiValued=false)
    boolean inUse;
    @Argument(index=0, name="ids", description="Show only services for the given bundle ids", required=false, multiValued=true)
    List<Long> ids;

    protected Object doExecute() throws Exception {
        if (this.ids != null && !this.ids.isEmpty()) {
            for (long id : this.ids) {
                Bundle bundle = this.getBundleContext().getBundle(id);
                if (bundle != null) {
                    boolean headerPrinted = false;
                    boolean needSeparator = false;
                    ServiceReference[] refs = null;
                    refs = this.inUse ? bundle.getServicesInUse() : bundle.getRegisteredServices();
                    for (int refIdx = 0; refs != null && refIdx < refs.length; ++refIdx) {
                        String[] objectClass = (String[])refs[refIdx].getProperty("objectClass");
                        boolean print = true;
                        for (int ocIdx = 0; !this.showAll && ocIdx < objectClass.length; ++ocIdx) {
                            if (!objectClass[ocIdx].equals(Function.class.getName())) continue;
                            print = false;
                        }
                        if (!headerPrinted) {
                            headerPrinted = true;
                            String title = Util.getBundleName(bundle);
                            title = this.inUse ? title + " uses:" : title + " provides:";
                            System.out.println("");
                            System.out.println(title);
                            System.out.println(Util.getUnderlineString(title));
                        }
                        if (!this.showAll && !print) continue;
                        if (needSeparator) {
                            System.out.println("----");
                        }
                        String[] keys = refs[refIdx].getPropertyKeys();
                        for (int keyIdx = 0; keys != null && keyIdx < keys.length; ++keyIdx) {
                            Object v = refs[refIdx].getProperty(keys[keyIdx]);
                            System.out.println(keys[keyIdx] + " = " + Util.getValueString(v));
                        }
                        needSeparator = true;
                    }
                    continue;
                }
                System.err.println("Bundle ID " + id + " is invalid.");
            }
        } else {
            Bundle[] bundles = this.getBundleContext().getBundles();
            if (bundles != null) {
                for (int bundleIdx = 0; bundleIdx < bundles.length; ++bundleIdx) {
                    boolean headerPrinted = false;
                    ServiceReference[] refs = null;
                    refs = this.inUse ? bundles[bundleIdx].getServicesInUse() : bundles[bundleIdx].getRegisteredServices();
                    for (int refIdx = 0; refs != null && refIdx < refs.length; ++refIdx) {
                        String[] objectClass = (String[])refs[refIdx].getProperty("objectClass");
                        boolean print = true;
                        for (int ocIdx = 0; !this.showAll && ocIdx < objectClass.length; ++ocIdx) {
                            if (!objectClass[ocIdx].equals(Function.class.getName())) continue;
                            print = false;
                        }
                        if (!this.showAll && !print) continue;
                        if (!headerPrinted) {
                            headerPrinted = true;
                            String title = Util.getBundleName(bundles[bundleIdx]);
                            title = this.inUse ? title + " uses:" : title + " provides:";
                            System.out.println("\n" + title);
                            System.out.println(Util.getUnderlineString(title));
                        }
                        System.out.println(Util.getValueString(objectClass));
                    }
                }
            } else {
                System.out.println("There are no registered services.");
            }
        }
        return null;
    }
}

