/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifparser.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.directory.studio.ldifparser.LdifFormatParameters;
import org.apache.directory.studio.ldifparser.model.LdifInvalidPart;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifChangeRecord;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifModSpec;
import org.apache.directory.studio.ldifparser.model.container.LdifRecord;

public class LdifFile
implements Serializable {
    private static final long serialVersionUID = 846864138240517008L;
    private List<LdifContainer> containerList = new ArrayList<LdifContainer>();
    private boolean hasChanges = false;

    public boolean isContentType() {
        return !this.hasChanges;
    }

    public boolean isChangeType() {
        return this.hasChanges;
    }

    public void addContainer(LdifContainer container) {
        this.containerList.add(container);
        if (container instanceof LdifChangeRecord) {
            this.hasChanges = true;
        }
    }

    public List<LdifContainer> getContainers() {
        return this.containerList;
    }

    public LdifRecord[] getRecords() {
        ArrayList<LdifRecord> recordList = new ArrayList<LdifRecord>();
        for (LdifContainer container : this.containerList) {
            if (!(container instanceof LdifRecord)) continue;
            recordList.add((LdifRecord)container);
        }
        return recordList.toArray(new LdifRecord[recordList.size()]);
    }

    public LdifContainer getLastContainer() {
        if (this.containerList.isEmpty()) {
            return null;
        }
        return this.containerList.get(this.containerList.size() - 1);
    }

    public String toRawString() {
        StringBuilder sb = new StringBuilder();
        for (LdifContainer container : this.containerList) {
            sb.append(container.toRawString());
        }
        return sb.toString();
    }

    public String toFormattedString(LdifFormatParameters formatParameters) {
        StringBuilder sb = new StringBuilder();
        for (LdifContainer ldifContainer : this.containerList) {
            sb.append(ldifContainer.toFormattedString(formatParameters));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (LdifContainer ldifContainer : this.containerList) {
            sb.append(ldifContainer);
        }
        return sb.toString();
    }

    public static LdifContainer getContainer(LdifFile model, int offset) {
        if (model == null || offset < 0) {
            return null;
        }
        List<LdifContainer> containers = model.getContainers();
        if (containers.size() > 0) {
            for (LdifContainer ldifContainer : containers) {
                if (ldifContainer.getOffset() > offset || offset >= ldifContainer.getOffset() + ldifContainer.getLength()) continue;
                return ldifContainer;
            }
        }
        return null;
    }

    public static LdifModSpec getInnerContainer(LdifContainer container, int offset) {
        if (container == null || offset < container.getOffset() || offset > container.getOffset() + container.getLength()) {
            return null;
        }
        LdifModSpec innerContainer = null;
        LdifPart[] parts = container.getParts();
        if (parts.length > 0) {
            LdifPart[] ldifPartArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                LdifPart ldifPart = ldifPartArray[n2];
                int start = ldifPart.getOffset();
                int end = ldifPart.getOffset() + ldifPart.getLength();
                if (start <= offset && offset < end && ldifPart instanceof LdifModSpec) {
                    innerContainer = (LdifModSpec)ldifPart;
                    break;
                }
                ++n2;
            }
        }
        return innerContainer;
    }

    public static LdifContainer[] getContainers(LdifFile model, int offset, int length) {
        if (model == null || offset < 0) {
            return null;
        }
        ArrayList<LdifContainer> containerList = new ArrayList<LdifContainer>();
        List<LdifContainer> containers = model.getContainers();
        if (containers.size() > 0) {
            for (LdifContainer container : containers) {
                int containerOffset = container.getOffset();
                if (offset >= containerOffset + container.getLength() || offset + length <= containerOffset) continue;
                containerList.add(container);
            }
        }
        return containerList.toArray(new LdifContainer[containerList.size()]);
    }

    public static LdifPart[] getParts(LdifFile model, int offset, int length) {
        if (model == null || offset < 0) {
            return null;
        }
        List<LdifContainer> containers = model.getContainers();
        return LdifFile.getParts(containers, offset, length);
    }

    public static LdifPart[] getParts(List<LdifContainer> containers, int offset, int length) {
        if (containers == null || offset < 0) {
            return null;
        }
        ArrayList<LdifPart> partList = new ArrayList<LdifPart>();
        for (LdifContainer ldifContainer : containers) {
            int ldifContainerOffset = ldifContainer.getOffset();
            if (offset >= ldifContainerOffset + ldifContainer.getLength() || offset + length < ldifContainerOffset) continue;
            LdifPart[] ldifParts = ldifContainer.getParts();
            LdifPart previousLdifPart = null;
            LdifPart[] ldifPartArray = ldifParts;
            int n = ldifParts.length;
            int n2 = 0;
            while (n2 < n) {
                LdifPart ldifPart = ldifPartArray[n2];
                int ldifPartOffset = ldifPart.getOffset();
                if (offset < ldifPartOffset + ldifPart.getLength() && offset + length >= ldifPartOffset) {
                    if (ldifPart instanceof LdifModSpec) {
                        LdifModSpec spec = (LdifModSpec)ldifPart;
                        ArrayList<LdifContainer> newLdifContainer = new ArrayList<LdifContainer>();
                        newLdifContainer.add(spec);
                        partList.addAll(Arrays.asList(LdifFile.getParts(newLdifContainer, offset, length)));
                    } else {
                        if (ldifPart instanceof LdifInvalidPart && previousLdifPart != null) {
                            ldifPart = previousLdifPart;
                        }
                        partList.add(ldifPart);
                    }
                    previousLdifPart = ldifPart;
                }
                ++n2;
            }
        }
        return partList.toArray(new LdifPart[partList.size()]);
    }

    public static LdifPart getContainerContent(LdifContainer container, int offset) {
        int containerOffset = container.getOffset();
        if (container == null || offset < containerOffset || offset > containerOffset + container.getLength()) {
            return null;
        }
        LdifPart part = null;
        LdifPart[] parts = container.getParts();
        if (parts.length > 0) {
            LdifPart[] ldifPartArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                LdifPart ldifPart = ldifPartArray[n2];
                int start = ldifPart.getOffset();
                int end = ldifPart.getOffset() + ldifPart.getLength();
                if (start <= offset && offset < end) {
                    if (!(ldifPart instanceof LdifModSpec)) break;
                    part = LdifFile.getContainerContent((LdifModSpec)ldifPart, offset);
                    break;
                }
                ++n2;
            }
        }
        return part;
    }

    public void replace(LdifContainer[] oldContainers, List<LdifContainer> newContainers) {
        int index = 0;
        if (oldContainers.length > 0) {
            index = this.containerList.indexOf(oldContainers[0]);
        }
        int removeLength = 0;
        int removeOffset = 0;
        if (oldContainers.length > 0) {
            removeOffset = oldContainers[0].getOffset();
            int i = 0;
            while (i < oldContainers.length) {
                this.containerList.remove(index);
                removeLength += oldContainers[i].getLength();
                ++i;
            }
        }
        int insertLength = 0;
        int pos = 0;
        for (LdifContainer ldifContainer : newContainers) {
            ldifContainer.adjustOffset(removeOffset);
            insertLength += ldifContainer.getLength();
            this.containerList.add(index + pos, ldifContainer);
            ++pos;
        }
        int adjust = insertLength - removeLength;
        int i = index + newContainers.size();
        while (i < this.containerList.size()) {
            LdifContainer container = this.containerList.get(i);
            container.adjustOffset(adjust);
            ++i;
        }
    }
}

