/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.directory.studio.ldapservers.model.LdapServerActionFilterAdapter;
import org.apache.directory.studio.ldapservers.model.LdapServerAdapterExtension;
import org.apache.directory.studio.ldapservers.model.LdapServerEvent;
import org.apache.directory.studio.ldapservers.model.LdapServerEventType;
import org.apache.directory.studio.ldapservers.model.LdapServerListener;
import org.apache.directory.studio.ldapservers.model.LdapServerStatus;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IActionFilter;

public class LdapServer
implements IAdaptable {
    private String id;
    private String name;
    private LdapServerStatus status = LdapServerStatus.STOPPED;
    private LdapServerAdapterExtension ldapServerAdapterExtension;
    private List<LdapServerListener> listeners = new ArrayList<LdapServerListener>();
    private Map<String, Object> customObjectsMap = new HashMap<String, Object>();
    private Map<String, Object> configurationParameters = new HashMap<String, Object>();

    public LdapServer() {
        this.id = LdapServer.createId();
    }

    public LdapServer(String name) {
        this.name = name;
        this.id = LdapServer.createId();
    }

    private static String createId() {
        return UUID.randomUUID().toString();
    }

    public void addListener(LdapServerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public Object getCustomObject(String key) {
        return this.customObjectsMap.get(key);
    }

    public Object getConfigurationParameter(String key) {
        return this.configurationParameters.get(key);
    }

    public Map<String, Object> getConfigurationParameters() {
        return this.configurationParameters;
    }

    public String getId() {
        return this.id;
    }

    public LdapServerAdapterExtension getLdapServerAdapterExtension() {
        return this.ldapServerAdapterExtension;
    }

    public String getName() {
        return this.name;
    }

    public LdapServerStatus getStatus() {
        return this.status;
    }

    public void putCustomObject(String key, Object value) {
        this.customObjectsMap.put(key, value);
    }

    public void putConfigurationParameter(String key, Object value) {
        this.configurationParameters.put(key, value);
    }

    public Object removeCustomObject(String key) {
        return this.customObjectsMap.remove(key);
    }

    public Object removeConfigurationParameter(String key) {
        return this.configurationParameters.remove(key);
    }

    public void removeListener(LdapServerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLdapServerAdapterExtension(LdapServerAdapterExtension ldapServerAdapterExtension) {
        this.ldapServerAdapterExtension = ldapServerAdapterExtension;
    }

    public void setName(String name) {
        if (this.name == name) {
            return;
        }
        this.name = name;
        this.fireServerNameChangeEvent();
    }

    private void fireServerNameChangeEvent() {
        LdapServerListener[] ldapServerListenerArray = this.listeners.toArray(new LdapServerListener[0]);
        int n = ldapServerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            LdapServerListener listener = ldapServerListenerArray[n2];
            listener.serverChanged(new LdapServerEvent(this, LdapServerEventType.RENAMED));
            ++n2;
        }
    }

    public void setStatus(LdapServerStatus status) {
        if (this.status == status) {
            return;
        }
        this.status = status;
        this.fireServerStateChangeEvent();
    }

    private void fireServerStateChangeEvent() {
        LdapServerListener[] ldapServerListenerArray = this.listeners.toArray(new LdapServerListener[0]);
        int n = ldapServerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            LdapServerListener listener = ldapServerListenerArray[n2];
            listener.serverChanged(new LdapServerEvent(this, LdapServerEventType.STATUS_CHANGED));
            ++n2;
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(IActionFilter.class)) {
            return LdapServerActionFilterAdapter.getInstance();
        }
        return null;
    }
}

