/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.server.config.beans.IndexBean;
import org.apache.directory.server.config.beans.JdbmIndexBean;
import org.apache.directory.server.config.beans.JdbmPartitionBean;
import org.apache.directory.server.config.beans.MavibotIndexBean;
import org.apache.directory.server.config.beans.MavibotPartitionBean;
import org.apache.directory.server.config.beans.PartitionBean;
import org.apache.directory.studio.apacheds.configuration.ApacheDS2ConfigurationPlugin;
import org.apache.directory.studio.apacheds.configuration.dialogs.AttributeValueDialog;
import org.apache.directory.studio.apacheds.configuration.dialogs.JdbmIndexDialog;
import org.apache.directory.studio.apacheds.configuration.dialogs.MavibotIndexDialog;
import org.apache.directory.studio.apacheds.configuration.editor.AttributeValueObject;
import org.apache.directory.studio.apacheds.configuration.editor.JdbmPartitionSpecificDetailsBlock;
import org.apache.directory.studio.apacheds.configuration.editor.MavibotPartitionSpecificDetailsBlock;
import org.apache.directory.studio.apacheds.configuration.editor.Messages;
import org.apache.directory.studio.apacheds.configuration.editor.PartitionSpecificDetailsBlock;
import org.apache.directory.studio.apacheds.configuration.editor.PartitionType;
import org.apache.directory.studio.apacheds.configuration.editor.PartitionWrapper;
import org.apache.directory.studio.apacheds.configuration.editor.PartitionsMasterDetailsBlock;
import org.apache.directory.studio.apacheds.configuration.editor.PartitionsPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PartitionDetailsPage
implements IDetailsPage {
    private PartitionDetailsPage instance;
    private PartitionsMasterDetailsBlock masterDetailsBlock;
    private PartitionWrapper partitionWrapper;
    private PartitionSpecificDetailsBlock partitionSpecificDetailsBlock;
    private Entry contextEntry;
    private List<IndexBean> indexesList;
    private Composite parentComposite;
    private FormToolkit toolkit;
    private Composite partitionSpecificDetailsComposite;
    private Section specificSettingsSection;
    private Composite specificSettingsSectionComposite;
    private ComboViewer partitionTypeComboViewer;
    private Text idText;
    private Text suffixText;
    private Button synchOnWriteCheckbox;
    private Button autoGenerateContextEntryCheckbox;
    private TableViewer contextEntryTableViewer;
    private Button contextEntryAddButton;
    private Button contextEntryEditButton;
    private Button contextEntryDeleteButton;
    private TableViewer indexesTableViewer;
    private Button indexesAddButton;
    private Button indexesEditButton;
    private Button indexesDeleteButton;
    private ModifyListener textModifyListener = event -> {
        this.commit(true);
        this.masterDetailsBlock.setEditorDirty();
    };
    private ModifyListener suffixTextModifyListener = event -> this.autoGenerateContextEntry();
    private SelectionListener checkboxSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PartitionDetailsPage.this.commit(true);
            PartitionDetailsPage.this.masterDetailsBlock.setEditorDirty();
        }
    };
    private SelectionListener autoGenerateContextEntryCheckboxSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PartitionDetailsPage.this.autoGenerateContextEntry();
            PartitionDetailsPage.this.updateContextEntryEnableState();
        }
    };
    private ISelectionChangedListener contextEntryTableViewerSelectionListener = event -> this.updateContextEntryEnableState();
    private IDoubleClickListener contextEntryTableViewerDoubleClickListener = event -> this.editSelectedContextEntry();
    private SelectionListener contextEntryAddButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            AttributeValueDialog dialog = new AttributeValueDialog(new AttributeValueObject("", ""));
            if (dialog.open() == 0 && dialog.isDirty()) {
                AttributeValueObject newAttributeValueObject = dialog.getAttributeValueObject();
                Attribute attribute = PartitionDetailsPage.this.contextEntry.get(newAttributeValueObject.getAttribute());
                if (attribute != null) {
                    try {
                        attribute.add(new String[]{newAttributeValueObject.getValue()});
                    }
                    catch (LdapInvalidAttributeValueException ldapInvalidAttributeValueException) {}
                } else {
                    try {
                        PartitionDetailsPage.this.contextEntry.put(new Attribute[]{new DefaultAttribute(newAttributeValueObject.getAttribute(), new String[]{newAttributeValueObject.getValue()})});
                    }
                    catch (LdapException ldapException) {}
                }
                PartitionDetailsPage.this.contextEntryTableViewer.refresh();
                PartitionDetailsPage.this.resizeContextEntryTableColumnsToFit();
                PartitionDetailsPage.this.masterDetailsBlock.setEditorDirty();
                PartitionDetailsPage.this.commit(true);
            }
        }
    };
    private ISelectionChangedListener partitionTypeComboViewerSelectionChangedListener = event -> {
        PartitionBean partition;
        PartitionType type = (PartitionType)((Object)((Object)((StructuredSelection)this.partitionTypeComboViewer.getSelection()).getFirstElement()));
        if (this.partitionWrapper != null && this.partitionWrapper.getPartition() != null && type != PartitionType.fromPartition(partition = this.partitionWrapper.getPartition())) {
            switch (type) {
                case JDBM: {
                    JdbmPartitionBean newJdbmPartition = new JdbmPartitionBean();
                    this.copyPartitionProperties(partition, (PartitionBean)newJdbmPartition);
                    this.partitionWrapper.setPartition((PartitionBean)newJdbmPartition);
                    break;
                }
                case MAVIBOT: {
                    MavibotPartitionBean newMavibotPartition = new MavibotPartitionBean();
                    this.copyPartitionProperties(partition, (PartitionBean)newMavibotPartition);
                    this.partitionWrapper.setPartition((PartitionBean)newMavibotPartition);
                    break;
                }
            }
            this.refresh();
            this.setEditorDirty();
        }
    };
    private SelectionListener contextEntryEditButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PartitionDetailsPage.this.editSelectedContextEntry();
        }
    };
    private SelectionListener contextEntryDeleteButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            StructuredSelection selection = (StructuredSelection)PartitionDetailsPage.this.contextEntryTableViewer.getSelection();
            if (!selection.isEmpty()) {
                AttributeValueObject attributeValueObject = (AttributeValueObject)selection.getFirstElement();
                Attribute attribute = PartitionDetailsPage.this.contextEntry.get(attributeValueObject.getAttribute());
                if (attribute != null) {
                    attribute.remove(new String[]{attributeValueObject.getValue()});
                    PartitionDetailsPage.this.contextEntryTableViewer.refresh();
                    PartitionDetailsPage.this.resizeContextEntryTableColumnsToFit();
                    PartitionDetailsPage.this.masterDetailsBlock.setEditorDirty();
                    PartitionDetailsPage.this.commit(true);
                }
            }
        }
    };
    private ISelectionChangedListener indexedAttributesTableViewerListener = event -> {
        this.indexesEditButton.setEnabled(!event.getSelection().isEmpty());
        this.indexesDeleteButton.setEnabled(!event.getSelection().isEmpty());
    };
    private IDoubleClickListener indexedAttributesTableViewerDoubleClickListener = event -> this.editSelectedIndex();
    private SelectionListener indexedAttributeAddButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            this.addNewIndex();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void addNewIndex() {
            PartitionType partitionType = (PartitionType)((Object)((StructuredSelection)PartitionDetailsPage.this.partitionTypeComboViewer.getSelection()).getFirstElement());
            if (partitionType == null) return;
            JdbmIndexBean newIndex = null;
            if (partitionType == PartitionType.JDBM) {
                JdbmIndexBean newJdbmIndex = new JdbmIndexBean();
                newJdbmIndex.setIndexAttributeId("");
                newJdbmIndex.setIndexCacheSize(100);
                JdbmIndexDialog dialog = new JdbmIndexDialog(newJdbmIndex);
                if (dialog.open() != 0) return;
                newIndex = dialog.getIndex();
            } else if (partitionType == PartitionType.MAVIBOT) {
                MavibotIndexBean newMavibotIndex = new MavibotIndexBean();
                newMavibotIndex.setIndexAttributeId("");
                MavibotIndexDialog dialog = new MavibotIndexDialog(newMavibotIndex);
                if (dialog.open() != 0) return;
                newIndex = dialog.getIndex();
            }
            if (newIndex == null) return;
            PartitionDetailsPage.this.indexesList.add(newIndex);
            PartitionDetailsPage.this.indexesTableViewer.refresh();
            PartitionDetailsPage.this.indexesTableViewer.setSelection((ISelection)new StructuredSelection((Object)newIndex));
            PartitionDetailsPage.this.masterDetailsBlock.setEditorDirty();
        }
    };
    private SelectionListener indexedAttributeEditButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PartitionDetailsPage.this.editSelectedIndex();
        }
    };
    private SelectionListener indexedAttributeDeleteButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            this.deleteSelectedIndex();
        }

        private void deleteSelectedIndex() {
            StructuredSelection selection = (StructuredSelection)PartitionDetailsPage.this.indexesTableViewer.getSelection();
            if (!selection.isEmpty()) {
                IndexBean selectedIndex = (IndexBean)selection.getFirstElement();
                if (MessageDialog.openConfirm((Shell)PartitionDetailsPage.this.indexesDeleteButton.getShell(), (String)Messages.getString("PartitionDetailsPage.ConfirmDelete"), (String)NLS.bind((String)Messages.getString("PartitionDetailsPage.AreYouSureDeleteIndex"), (Object)selectedIndex.getIndexAttributeId()))) {
                    PartitionDetailsPage.this.indexesList.remove(selectedIndex);
                    PartitionDetailsPage.this.indexesTableViewer.refresh();
                    PartitionDetailsPage.this.masterDetailsBlock.setEditorDirty();
                }
            }
        }
    };

    public PartitionDetailsPage(PartitionsMasterDetailsBlock pmdb) {
        this.instance = this;
        this.masterDetailsBlock = pmdb;
    }

    public void createContents(Composite parent) {
        this.parentComposite = parent;
        parent.setLayout((Layout)new GridLayout());
        this.createGeneralDetailsSection(parent, this.toolkit);
        this.createContextEntrySection(parent, this.toolkit);
        this.createPartitionSpecificSettingsSection(parent, this.toolkit);
        this.createIndexesSection(parent, this.toolkit);
    }

    private void createGeneralDetailsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.marginWidth = 10;
        section.setText(Messages.getString("PartitionDetailsPage.PartitionsGeneralDetails"));
        section.setDescription(Messages.getString("PartitionDetailsPage.SetPropertiesOfPartition"));
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        GridLayout glayout = new GridLayout(2, false);
        client.setLayout((Layout)glayout);
        section.setClient((Control)client);
        toolkit.createLabel(client, "Partition Type:");
        Combo partitionTypeCombo = new Combo(client, 12);
        partitionTypeCombo.setLayoutData((Object)new GridData(4, 0, true, false));
        this.partitionTypeComboViewer = new ComboViewer(partitionTypeCombo);
        this.partitionTypeComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.partitionTypeComboViewer.setInput((Object)new Object[]{PartitionType.JDBM, PartitionType.MAVIBOT});
        toolkit.createLabel(client, Messages.getString("PartitionDetailsPage.Id"));
        this.idText = toolkit.createText(client, "");
        this.idText.setLayoutData((Object)new GridData(4, 0, true, false));
        toolkit.createLabel(client, "Suffix:");
        this.suffixText = toolkit.createText(client, "");
        this.suffixText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.synchOnWriteCheckbox = toolkit.createButton(client, Messages.getString("PartitionDetailsPage.SynchronizationOnWrite"), 32);
        this.synchOnWriteCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
    }

    private void createContextEntrySection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.marginWidth = 10;
        section.setText("Context Entry");
        section.setDescription("Set the attribute/value pairs for the Context Entry of the partition.");
        section.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite client = toolkit.createComposite((Composite)section);
        toolkit.paintBordersFor(client);
        client.setLayout((Layout)new GridLayout(2, false));
        section.setClient((Control)client);
        this.autoGenerateContextEntryCheckbox = toolkit.createButton(client, Messages.getString("PartitionDetailsPage.AutoGenerateContextEntryFromSuffixDn"), 32);
        this.autoGenerateContextEntryCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
        Table contextEntryTable = toolkit.createTable(client, 0);
        GridData gd = new GridData(4, 0, true, false, 1, 3);
        gd.heightHint = 62;
        gd.widthHint = 50;
        contextEntryTable.setLayoutData((Object)gd);
        TableColumn idColumn = new TableColumn(contextEntryTable, 16384, 0);
        idColumn.setText(Messages.getString("PartitionDetailsPage.Attribute"));
        idColumn.setWidth(100);
        TableColumn valueColumn = new TableColumn(contextEntryTable, 16384, 1);
        valueColumn.setText(Messages.getString("PartitionDetailsPage.Value"));
        valueColumn.setWidth(100);
        contextEntryTable.setHeaderVisible(true);
        this.contextEntryTableViewer = new TableViewer(contextEntryTable);
        this.contextEntryTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList<AttributeValueObject> elements = new ArrayList<AttributeValueObject>();
                Entry entry = (Entry)inputElement;
                for (Attribute attribute : entry) {
                    for (Value value : attribute) {
                        elements.add(new AttributeValueObject(attribute.getId(), value.getString()));
                    }
                }
                return elements.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.contextEntryTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public String getColumnText(Object element, int columnIndex) {
                if (element != null) {
                    switch (columnIndex) {
                        case 0: {
                            return ((AttributeValueObject)element).getAttribute();
                        }
                        case 1: {
                            return ((AttributeValueObject)element).getValue();
                        }
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        GridData buttonsGD = new GridData(4, 1, false, false);
        buttonsGD.widthHint = 61;
        this.contextEntryAddButton = toolkit.createButton(client, Messages.getString("PartitionDetailsPage.Add"), 8);
        this.contextEntryAddButton.setLayoutData((Object)buttonsGD);
        this.contextEntryEditButton = toolkit.createButton(client, Messages.getString("PartitionDetailsPage.Edit"), 8);
        this.contextEntryEditButton.setEnabled(false);
        this.contextEntryEditButton.setLayoutData((Object)buttonsGD);
        this.contextEntryDeleteButton = toolkit.createButton(client, Messages.getString("PartitionDetailsPage.Delete"), 8);
        this.contextEntryDeleteButton.setEnabled(false);
        this.contextEntryDeleteButton.setLayoutData((Object)buttonsGD);
    }

    private void updateContextEntryEnableState() {
        this.contextEntryTableViewer.getTable().setEnabled(!this.autoGenerateContextEntryCheckbox.getSelection());
        this.contextEntryAddButton.setEnabled(!this.autoGenerateContextEntryCheckbox.getSelection());
        this.contextEntryEditButton.setEnabled(!this.autoGenerateContextEntryCheckbox.getSelection() && !this.contextEntryTableViewer.getSelection().isEmpty());
        this.contextEntryDeleteButton.setEnabled(!this.autoGenerateContextEntryCheckbox.getSelection() && !this.contextEntryTableViewer.getSelection().isEmpty());
    }

    private void createPartitionSpecificSettingsSection(Composite parent, FormToolkit toolkit) {
        this.specificSettingsSection = toolkit.createSection(parent, 322);
        this.specificSettingsSection.marginWidth = 10;
        this.specificSettingsSection.setText("Partition Specific Settings");
        this.specificSettingsSection.setLayoutData((Object)new GridData(4, 0, true, false));
        this.specificSettingsSectionComposite = toolkit.createComposite((Composite)this.specificSettingsSection);
        toolkit.paintBordersFor(this.specificSettingsSectionComposite);
        GridLayout gd = new GridLayout();
        gd.marginWidth = 0;
        gd.marginHeight = 0;
        gd.horizontalSpacing = 0;
        gd.verticalSpacing = 0;
        this.specificSettingsSectionComposite.setLayout((Layout)gd);
        this.specificSettingsSection.setClient((Control)this.specificSettingsSectionComposite);
    }

    private void disposeSpecificSettingsComposite() {
        if (this.partitionSpecificDetailsComposite != null && !this.partitionSpecificDetailsComposite.isDisposed()) {
            this.partitionSpecificDetailsComposite.dispose();
        }
        this.partitionSpecificDetailsComposite = null;
    }

    private void updatePartitionSpecificSettingsSection() {
        this.disposeSpecificSettingsComposite();
        if (this.partitionSpecificDetailsBlock != null) {
            this.partitionSpecificDetailsComposite = this.partitionSpecificDetailsBlock.createBlockContent(this.specificSettingsSectionComposite, this.toolkit);
            this.partitionSpecificDetailsBlock.refresh();
        }
        this.parentComposite.layout(true, true);
        this.specificSettingsSection.setVisible(this.partitionSpecificDetailsBlock != null);
    }

    private void createIndexesSection(Composite parent, FormToolkit toolkit) {
        Section indexedAttributesSection = toolkit.createSection(parent, 384);
        indexedAttributesSection.marginWidth = 10;
        indexedAttributesSection.setText(Messages.getString("PartitionDetailsPage.IndexedAttributes"));
        indexedAttributesSection.setDescription(Messages.getString("PartitionDetailsPage.SetIndexedAttributesOfPartition"));
        indexedAttributesSection.setLayoutData((Object)new GridData(4, 0, true, false));
        Composite indexedAttributesClient = toolkit.createComposite((Composite)indexedAttributesSection);
        toolkit.paintBordersFor(indexedAttributesClient);
        indexedAttributesClient.setLayout((Layout)new GridLayout(2, false));
        indexedAttributesSection.setClient((Control)indexedAttributesClient);
        Table indexedAttributesTable = toolkit.createTable(indexedAttributesClient, 0);
        GridData gd = new GridData(4, 0, true, false, 1, 3);
        gd.heightHint = 80;
        indexedAttributesTable.setLayoutData((Object)gd);
        this.indexesTableViewer = new TableViewer(indexedAttributesTable);
        this.indexesTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.indexesTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof JdbmIndexBean) {
                    JdbmIndexBean jdbmIndexBean = (JdbmIndexBean)element;
                    return NLS.bind((String)"{0} [{1}]", (Object)jdbmIndexBean.getIndexAttributeId(), (Object)jdbmIndexBean.getIndexCacheSize());
                }
                if (element instanceof MavibotIndexBean) {
                    MavibotIndexBean mavibotIndexBean = (MavibotIndexBean)element;
                    return mavibotIndexBean.getIndexAttributeId();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof IndexBean) {
                    return ApacheDS2ConfigurationPlugin.getDefault().getImage("resources/icons/index.png");
                }
                return super.getImage(element);
            }
        });
        this.indexesAddButton = toolkit.createButton(indexedAttributesClient, Messages.getString("PartitionDetailsPage.Add"), 8);
        this.indexesAddButton.setLayoutData((Object)this.createNewButtonGridData());
        this.indexesEditButton = toolkit.createButton(indexedAttributesClient, Messages.getString("PartitionDetailsPage.Edit"), 8);
        this.indexesEditButton.setEnabled(false);
        this.indexesEditButton.setLayoutData((Object)this.createNewButtonGridData());
        this.indexesDeleteButton = toolkit.createButton(indexedAttributesClient, Messages.getString("PartitionDetailsPage.Delete"), 8);
        this.indexesDeleteButton.setEnabled(false);
        this.indexesDeleteButton.setLayoutData((Object)this.createNewButtonGridData());
    }

    private GridData createNewButtonGridData() {
        GridData gd = new GridData(4, 1, false, false);
        gd.widthHint = 61;
        return gd;
    }

    private void addListeners() {
        this.partitionTypeComboViewer.addSelectionChangedListener(this.partitionTypeComboViewerSelectionChangedListener);
        this.idText.addModifyListener(this.textModifyListener);
        this.suffixText.addModifyListener(this.textModifyListener);
        this.suffixText.addModifyListener(this.suffixTextModifyListener);
        this.synchOnWriteCheckbox.addSelectionListener(this.checkboxSelectionListener);
        this.autoGenerateContextEntryCheckbox.addSelectionListener(this.autoGenerateContextEntryCheckboxSelectionListener);
        this.contextEntryTableViewer.addDoubleClickListener(this.contextEntryTableViewerDoubleClickListener);
        this.contextEntryTableViewer.addSelectionChangedListener(this.contextEntryTableViewerSelectionListener);
        this.contextEntryAddButton.addSelectionListener(this.contextEntryAddButtonListener);
        this.contextEntryEditButton.addSelectionListener(this.contextEntryEditButtonListener);
        this.contextEntryDeleteButton.addSelectionListener(this.contextEntryDeleteButtonListener);
        this.indexesTableViewer.addSelectionChangedListener(this.indexedAttributesTableViewerListener);
        this.indexesTableViewer.addDoubleClickListener(this.indexedAttributesTableViewerDoubleClickListener);
        this.indexesAddButton.addSelectionListener(this.indexedAttributeAddButtonListener);
        this.indexesEditButton.addSelectionListener(this.indexedAttributeEditButtonListener);
        this.indexesDeleteButton.addSelectionListener(this.indexedAttributeDeleteButtonListener);
    }

    private void removeListeners() {
        this.partitionTypeComboViewer.removeSelectionChangedListener(this.partitionTypeComboViewerSelectionChangedListener);
        this.idText.removeModifyListener(this.textModifyListener);
        this.suffixText.removeModifyListener(this.textModifyListener);
        this.suffixText.removeModifyListener(this.suffixTextModifyListener);
        this.synchOnWriteCheckbox.removeSelectionListener(this.checkboxSelectionListener);
        this.autoGenerateContextEntryCheckbox.removeSelectionListener(this.autoGenerateContextEntryCheckboxSelectionListener);
        this.contextEntryTableViewer.removeDoubleClickListener(this.contextEntryTableViewerDoubleClickListener);
        this.contextEntryTableViewer.removeSelectionChangedListener(this.contextEntryTableViewerSelectionListener);
        this.contextEntryAddButton.removeSelectionListener(this.contextEntryAddButtonListener);
        this.contextEntryEditButton.removeSelectionListener(this.contextEntryEditButtonListener);
        this.contextEntryDeleteButton.removeSelectionListener(this.contextEntryDeleteButtonListener);
        this.indexesTableViewer.removeSelectionChangedListener(this.indexedAttributesTableViewerListener);
        this.indexesTableViewer.removeDoubleClickListener(this.indexedAttributesTableViewerDoubleClickListener);
        this.indexesAddButton.removeSelectionListener(this.indexedAttributeAddButtonListener);
        this.indexesEditButton.removeSelectionListener(this.indexedAttributeEditButtonListener);
        this.indexesDeleteButton.removeSelectionListener(this.indexedAttributeDeleteButtonListener);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.partitionWrapper = ssel.size() == 1 ? (PartitionWrapper)ssel.getFirstElement() : null;
        this.refresh();
    }

    public void commit(boolean onSave) {
        if (this.partitionWrapper != null && this.partitionWrapper.getPartition() != null) {
            PartitionBean partition = this.partitionWrapper.getPartition();
            partition.setPartitionId(this.idText.getText());
            try {
                partition.setPartitionSuffix(new Dn(new String[]{this.suffixText.getText()}));
            }
            catch (LdapInvalidDnException ldapInvalidDnException) {}
            if (this.contextEntry.size() > 0) {
                LdifEntry ldifEntry = new LdifEntry(this.contextEntry);
                ldifEntry.setDn(partition.getPartitionSuffix());
                partition.setContextEntry(ldifEntry.toString());
            } else {
                partition.setContextEntry(null);
            }
            partition.setPartitionSyncOnWrite(this.synchOnWriteCheckbox.getSelection());
            if (this.partitionSpecificDetailsBlock != null) {
                this.partitionSpecificDetailsBlock.commit(onSave);
            }
        }
    }

    public void dispose() {
    }

    public void initialize(IManagedForm form) {
        this.toolkit = form.getToolkit();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
        this.removeListeners();
        if (this.partitionWrapper != null && this.partitionWrapper.getPartition() != null) {
            PartitionBean partition = this.partitionWrapper.getPartition();
            boolean isSystemPartition = PartitionsPage.isSystemPartition(partition);
            PartitionType partitionType = PartitionType.fromPartition(partition);
            this.partitionTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)partitionType));
            this.partitionTypeComboViewer.getCombo().setEnabled(!isSystemPartition);
            String id = partition.getPartitionId();
            this.idText.setText(id == null ? "" : id);
            this.idText.setEnabled(!isSystemPartition);
            Dn suffix = partition.getPartitionSuffix();
            this.suffixText.setText(suffix == null ? "" : suffix.toString());
            this.suffixText.setEnabled(!isSystemPartition);
            this.autoGenerateContextEntryCheckbox.setSelection(true);
            this.refreshContextEntry();
            this.indexesList = partition.getIndexes();
            this.indexesTableViewer.setInput(this.indexesList);
            this.synchOnWriteCheckbox.setSelection(partition.isPartitionSyncOnWrite());
            if (partition instanceof JdbmPartitionBean) {
                this.partitionTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)PartitionType.JDBM));
                this.partitionSpecificDetailsBlock = new JdbmPartitionSpecificDetailsBlock(this.instance, (JdbmPartitionBean)partition);
            } else if (partition instanceof MavibotPartitionBean) {
                this.partitionTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)PartitionType.MAVIBOT));
                this.partitionSpecificDetailsBlock = new MavibotPartitionSpecificDetailsBlock(this.instance, (MavibotPartitionBean)partition);
            } else {
                this.partitionTypeComboViewer.setSelection(null);
                this.partitionSpecificDetailsBlock = null;
            }
            this.updatePartitionSpecificSettingsSection();
        }
        this.addListeners();
    }

    private void refreshContextEntry() {
        if (this.partitionWrapper != null && this.partitionWrapper.getPartition() != null) {
            PartitionBean partition = this.partitionWrapper.getPartition();
            String contextEntryString = partition.getContextEntry();
            if (contextEntryString != null && !"".equals(contextEntryString)) {
                try {
                    contextEntryString = contextEntryString.replaceAll("\\\\n", "\n");
                    LdifReader reader = new LdifReader((Reader)new StringReader(contextEntryString));
                    this.contextEntry = reader.next().getEntry();
                    reader.close();
                }
                catch (Exception exception) {
                    this.contextEntry = new DefaultEntry();
                }
            } else {
                this.contextEntry = new DefaultEntry();
            }
            this.contextEntryTableViewer.setInput((Object)this.contextEntry);
            this.resizeContextEntryTableColumnsToFit();
            boolean enabled = !this.autoGenerateContextEntryCheckbox.getSelection();
            this.contextEntryTableViewer.getTable().setEnabled(enabled);
            this.contextEntryAddButton.setEnabled(enabled);
            this.contextEntryEditButton.setEnabled(enabled);
            this.contextEntryDeleteButton.setEnabled(enabled);
        }
    }

    private void autoGenerateContextEntry() {
        if (this.partitionWrapper != null && this.partitionWrapper.getPartition() != null) {
            PartitionBean partition = this.partitionWrapper.getPartition();
            if (this.autoGenerateContextEntryCheckbox.getSelection()) {
                try {
                    Dn suffixDn = new Dn(new String[]{this.suffixText.getText()});
                    partition.setContextEntry(PartitionsMasterDetailsBlock.getContextEntryLdif(suffixDn));
                    this.refreshContextEntry();
                }
                catch (LdapInvalidDnException ldapInvalidDnException) {}
            }
        }
    }

    private void resizeContextEntryTableColumnsToFit() {
        this.contextEntryTableViewer.getTable().getColumn(0).pack();
        this.contextEntryTableViewer.getTable().getColumn(0).setWidth(this.contextEntryTableViewer.getTable().getColumn(0).getWidth() + 5);
        this.contextEntryTableViewer.getTable().getColumn(1).pack();
    }

    public void setFocus() {
        this.idText.setFocus();
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    private void editSelectedIndex() {
        PartitionType partitionType;
        StructuredSelection selection = (StructuredSelection)this.indexesTableViewer.getSelection();
        if (!selection.isEmpty() && (partitionType = (PartitionType)((Object)((StructuredSelection)this.partitionTypeComboViewer.getSelection()).getFirstElement())) != null) {
            MavibotIndexBean index;
            MavibotIndexDialog dialog;
            JdbmIndexBean editedIndex = null;
            if (partitionType == PartitionType.JDBM) {
                JdbmIndexBean index2 = (JdbmIndexBean)selection.getFirstElement();
                JdbmIndexDialog dialog2 = new JdbmIndexDialog(index2);
                if (dialog2.open() == 0 && dialog2.isDirty()) {
                    editedIndex = index2;
                }
            } else if (partitionType == PartitionType.MAVIBOT && (dialog = new MavibotIndexDialog(index = (MavibotIndexBean)selection.getFirstElement())).open() == 0 && dialog.isDirty()) {
                editedIndex = index;
            }
            if (editedIndex != null) {
                this.indexesTableViewer.refresh();
                this.masterDetailsBlock.setEditorDirty();
            }
        }
    }

    private void editSelectedContextEntry() {
        StructuredSelection selection = (StructuredSelection)this.contextEntryTableViewer.getSelection();
        if (!selection.isEmpty()) {
            AttributeValueObject attributeValueObject = (AttributeValueObject)selection.getFirstElement();
            String oldId = attributeValueObject.getAttribute();
            String oldValue = attributeValueObject.getValue();
            AttributeValueDialog dialog = new AttributeValueDialog(attributeValueObject);
            if (dialog.open() == 0 && dialog.isDirty()) {
                AttributeValueObject newAttributeValueObject;
                Attribute attribute = this.contextEntry.get(oldId);
                if (attribute != null) {
                    attribute.remove(new String[]{oldValue});
                }
                if ((attribute = this.contextEntry.get((newAttributeValueObject = dialog.getAttributeValueObject()).getAttribute())) != null) {
                    try {
                        attribute.add(new String[]{newAttributeValueObject.getValue()});
                    }
                    catch (LdapInvalidAttributeValueException ldapInvalidAttributeValueException) {}
                } else {
                    try {
                        this.contextEntry.put(new Attribute[]{new DefaultAttribute(newAttributeValueObject.getAttribute(), new String[]{newAttributeValueObject.getValue()})});
                    }
                    catch (LdapException ldapException) {}
                }
                this.contextEntryTableViewer.refresh();
                this.resizeContextEntryTableColumnsToFit();
                this.masterDetailsBlock.setEditorDirty();
                this.commit(true);
            }
        }
    }

    public void setEditorDirty() {
        this.masterDetailsBlock.setEditorDirty();
    }

    private void copyPartitionProperties(PartitionBean original, PartitionBean destination) {
        if (original != null && destination != null) {
            destination.setContextEntry(original.getContextEntry());
            destination.setDescription(original.getDescription());
            destination.setDn(original.getDn());
            destination.setEnabled(original.isEnabled());
            destination.setPartitionId(original.getPartitionId());
            destination.setPartitionSuffix(original.getPartitionSuffix());
            destination.setPartitionSyncOnWrite(original.isPartitionSyncOnWrite());
            List originalIndexes = original.getIndexes();
            ArrayList<JdbmIndexBean> destinationIndexes = new ArrayList<JdbmIndexBean>();
            if (originalIndexes != null) {
                for (IndexBean originalIndexBean : originalIndexes) {
                    JdbmIndexBean destinationIndexBean;
                    if (destination instanceof JdbmPartitionBean) {
                        destinationIndexBean = new JdbmIndexBean();
                        destinationIndexBean.setIndexAttributeId(originalIndexBean.getIndexAttributeId());
                        destinationIndexBean.setIndexHasReverse(originalIndexBean.getIndexHasReverse());
                        destinationIndexes.add(destinationIndexBean);
                        continue;
                    }
                    if (!(destination instanceof MavibotPartitionBean)) continue;
                    destinationIndexBean = new MavibotIndexBean();
                    destinationIndexBean.setIndexAttributeId(originalIndexBean.getIndexAttributeId());
                    destinationIndexBean.setIndexHasReverse(originalIndexBean.getIndexHasReverse());
                    destinationIndexes.add(destinationIndexBean);
                }
            }
            destination.setIndexes(destinationIndexes);
        }
    }
}

