/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.filter;

import java.text.ParseException;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.AttributeUtils;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.ApproximateNode;
import org.apache.directory.api.ldap.model.filter.BranchNode;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.ExtensibleNode;
import org.apache.directory.api.ldap.model.filter.GreaterEqNode;
import org.apache.directory.api.ldap.model.filter.LessEqNode;
import org.apache.directory.api.ldap.model.filter.NotNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.filter.SubstringNode;
import org.apache.directory.api.ldap.model.filter.UndefinedNode;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Chars;
import org.apache.directory.api.util.Hex;
import org.apache.directory.api.util.Position;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.Unicode;

public final class FilterParser {
    private FilterParser() {
    }

    public static ExprNode parse(String filter) throws ParseException {
        return FilterParser.parse(null, filter, false);
    }

    public static ExprNode parse(String filter, boolean relaxed) throws ParseException {
        return FilterParser.parse(null, filter, relaxed);
    }

    public static ExprNode parse(SchemaManager schemaManager, String filter) throws ParseException {
        return FilterParser.parse(schemaManager, filter, false);
    }

    private static void skipWhiteSpaces(byte[] filter, Position pos) {
        while (Strings.isCharASCII((byte[])filter, (int)pos.start, (char)' ') || Strings.isCharASCII((byte[])filter, (int)pos.start, (char)'\t') || Strings.isCharASCII((byte[])filter, (int)pos.start, (char)'\n')) {
            ++pos.start;
        }
    }

    public static ExprNode parse(SchemaManager schemaManager, String filter, boolean relaxed) throws ParseException {
        if (Strings.isEmpty((String)filter)) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_13316_EMPTY_FILTER, (Object[])new Object[0]), 0);
        }
        byte[] filterBytes = Strings.getBytesUtf8((String)filter);
        Position pos = new Position();
        pos.start = 0;
        pos.end = 0;
        pos.length = filterBytes.length;
        try {
            ExprNode node = FilterParser.parseFilterInternal(schemaManager, filterBytes, pos, relaxed);
            if (node instanceof UndefinedNode) {
                return null;
            }
            return node;
        }
        catch (LdapException le) {
            throw new ParseException(le.getMessage(), pos.start);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ExprNode parseExtensible(SchemaManager schemaManager, String attribute, byte[] filterBytes, Position pos, boolean relaxed) throws LdapException, ParseException {
        ExtensibleNode node;
        if (schemaManager != null) {
            AttributeType attributeType = schemaManager.getAttributeType(attribute);
            if (attributeType == null) return new UndefinedNode(attribute);
            node = new ExtensibleNode(attributeType);
        } else {
            node = new ExtensibleNode(attribute);
        }
        if (attribute != null) {
            if (Strings.isCharASCII((byte[])filterBytes, (int)pos.start, (char)'d') && Strings.isCharASCII((byte[])filterBytes, (int)(pos.start + 1), (char)'n')) {
                node.setDnAttributes(true);
                pos.start += 2;
            } else {
                --pos.start;
            }
            if (Strings.byteAt((byte[])filterBytes, (int)pos.start) != 58) throw new ParseException(I18n.err((I18n)I18n.ERR_13306_MR_OR_ASSERTION_VALUE_EXPECTED, (Object[])new Object[0]), pos.start);
            ++pos.start;
            if (Strings.byteAt((byte[])filterBytes, (int)pos.start) == 61) {
                ++pos.start;
                node.setValue(FilterParser.parseAssertionValue(schemaManager, filterBytes, pos));
                return node;
            }
            String matchingRuleId = AttributeUtils.parseAttribute(filterBytes, pos, false, relaxed);
            node.setMatchingRuleId(matchingRuleId);
            if (!Strings.isCharASCII((byte[])filterBytes, (int)pos.start, (char)':') || !Strings.isCharASCII((byte[])filterBytes, (int)(pos.start + 1), (char)'=')) throw new ParseException(I18n.err((I18n)I18n.ERR_13305_ASSERTION_VALUE_EXPECTED, (Object[])new Object[0]), pos.start);
            pos.start += 2;
            node.setValue(FilterParser.parseAssertionValue(schemaManager, filterBytes, pos));
            return node;
        }
        boolean oidRequested = false;
        if (Strings.isCharASCII((byte[])filterBytes, (int)pos.start, (char)':') && Strings.isCharASCII((byte[])filterBytes, (int)(pos.start + 1), (char)'d') && Strings.isCharASCII((byte[])filterBytes, (int)(pos.start + 2), (char)'n')) {
            node.setDnAttributes(true);
            pos.start += 3;
        } else {
            oidRequested = true;
        }
        if (Strings.byteAt((byte[])filterBytes, (int)pos.start) != 58) throw new ParseException(I18n.err((I18n)I18n.ERR_13306_MR_OR_ASSERTION_VALUE_EXPECTED, (Object[])new Object[0]), pos.start);
        ++pos.start;
        if (Strings.byteAt((byte[])filterBytes, (int)pos.start) == 61) {
            if (oidRequested) {
                throw new ParseException(I18n.err((I18n)I18n.ERR_13307_MATCHING_RULE_EXPECTED, (Object[])new Object[0]), pos.start);
            }
            ++pos.start;
            node.setValue(FilterParser.parseAssertionValue(schemaManager, null, filterBytes, pos));
            return node;
        }
        String matchingRuleId = AttributeUtils.parseAttribute(filterBytes, pos, false, relaxed);
        node.setMatchingRuleId(matchingRuleId);
        if (!Strings.isCharASCII((byte[])filterBytes, (int)pos.start, (char)':') || !Strings.isCharASCII((byte[])filterBytes, (int)(pos.start + 1), (char)'=')) throw new ParseException(I18n.err((I18n)I18n.ERR_13305_ASSERTION_VALUE_EXPECTED, (Object[])new Object[0]), pos.start);
        pos.start += 2;
        node.setValue(FilterParser.parseAssertionValue(schemaManager, null, filterBytes, pos));
        return node;
    }

    private static Value parseAssertionValue(SchemaManager schemaManager, String attribute, byte[] filterBytes, Position pos) throws ParseException, LdapInvalidAttributeValueException {
        byte b = Strings.byteAt((byte[])filterBytes, (int)pos.start);
        byte[] value = new byte[filterBytes.length - pos.start];
        int current = 0;
        do {
            if (Unicode.isUnicodeSubset((byte)b)) {
                value[current++] = b;
                ++pos.start;
                continue;
            }
            if (!Strings.isCharASCII((byte[])filterBytes, (int)pos.start, (char)'\\')) break;
            ++pos.start;
            if (Chars.isHex((byte[])filterBytes, (int)pos.start)) {
                ++pos.start;
            } else {
                throw new ParseException(I18n.err((I18n)I18n.ERR_13308_NOT_A_VALID_ESCAPED_VALUE, (Object[])new Object[0]), pos.start);
            }
            if (Chars.isHex((byte[])filterBytes, (int)pos.start)) {
                value[current++] = Hex.getHexValue((byte)filterBytes[pos.start - 1], (byte)filterBytes[pos.start]);
                ++pos.start;
                continue;
            }
            throw new ParseException(I18n.err((I18n)I18n.ERR_13308_NOT_A_VALID_ESCAPED_VALUE, (Object[])new Object[0]), pos.start);
        } while ((b = Strings.byteAt((byte[])filterBytes, (int)pos.start)) != 0);
        if (current != 0) {
            if (schemaManager != null) {
                AttributeType attributeType = schemaManager.getAttributeType(attribute);
                if (attributeType == null) {
                    byte[] bytes = new byte[current];
                    System.arraycopy(value, 0, bytes, 0, current);
                    return new Value(bytes);
                }
                if (attributeType.getSyntax().isHumanReadable()) {
                    return new Value(attributeType, Strings.utf8ToString((byte[])value, (int)current));
                }
                byte[] bytes = new byte[current];
                System.arraycopy(value, 0, bytes, 0, current);
                return new Value(attributeType, bytes);
            }
            byte[] bytes = new byte[current];
            System.arraycopy(value, 0, bytes, 0, current);
            return new Value(bytes);
        }
        if (schemaManager != null) {
            AttributeType attributeType = schemaManager.getAttributeType(attribute);
            if (attributeType.getEquality().getSyntax().isHumanReadable()) {
                return new Value(attributeType, (String)null);
            }
            return new Value(attributeType, (byte[])null);
        }
        return new Value((byte[])null);
    }

    private static Value parseAssertionValue(SchemaManager schemaManager, byte[] filterBytes, Position pos) throws ParseException {
        byte b = Strings.byteAt((byte[])filterBytes, (int)pos.start);
        byte[] value = new byte[filterBytes.length - pos.start];
        int current = 0;
        do {
            if (Unicode.isUnicodeSubset((byte)b)) {
                value[current++] = b;
                ++pos.start;
                continue;
            }
            if (!Strings.isCharASCII((byte[])filterBytes, (int)pos.start, (char)'\\')) break;
            ++pos.start;
            if (Chars.isHex((byte[])filterBytes, (int)pos.start)) {
                ++pos.start;
            } else {
                throw new ParseException(I18n.err((I18n)I18n.ERR_13308_NOT_A_VALID_ESCAPED_VALUE, (Object[])new Object[0]), pos.start);
            }
            if (Chars.isHex((byte[])filterBytes, (int)pos.start)) {
                value[current++] = Hex.getHexValue((byte)filterBytes[pos.start - 1], (byte)filterBytes[pos.start]);
                ++pos.start;
                continue;
            }
            throw new ParseException(I18n.err((I18n)I18n.ERR_13308_NOT_A_VALID_ESCAPED_VALUE, (Object[])new Object[0]), pos.start);
        } while ((b = Strings.byteAt((byte[])filterBytes, (int)pos.start)) != 0);
        if (current != 0) {
            byte[] result = new byte[current];
            System.arraycopy(value, 0, result, 0, current);
            return new Value(result);
        }
        return new Value((byte[])null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ExprNode parseSubstring(SchemaManager schemaManager, String attribute, Value initial, byte[] filterBytes, Position pos) throws ParseException, LdapException {
        SubstringNode node;
        if (schemaManager != null) {
            AttributeType attributeType = schemaManager.lookupAttributeTypeRegistry(attribute);
            if (attributeType == null) return null;
            node = new SubstringNode(schemaManager.lookupAttributeTypeRegistry(attribute));
        } else {
            node = new SubstringNode(attribute);
        }
        if (initial != null && !initial.isNull()) {
            String initialStr = initial.getString();
            node.setInitial(initialStr);
        }
        if (Strings.isCharASCII((byte[])filterBytes, (int)pos.start, (char)')')) {
            return node;
        }
        do {
            Value assertionValue = FilterParser.parseAssertionValue(schemaManager, attribute, filterBytes, pos);
            if (Strings.isCharASCII((byte[])filterBytes, (int)pos.start, (char)')')) {
                if (assertionValue.isNull()) return node;
                String finalStr = assertionValue.getString();
                node.setFinal(finalStr);
                return node;
            }
            if (!Strings.isCharASCII((byte[])filterBytes, (int)pos.start, (char)'*')) throw new ParseException(I18n.err((I18n)I18n.ERR_13309_BAD_SUBSTRING, (Object[])new Object[0]), pos.start);
            if (!assertionValue.isNull()) {
                String anyStr = assertionValue.getString();
                node.addAny(anyStr);
            }
            ++pos.start;
            while (Strings.isCharASCII((byte[])filterBytes, (int)pos.start, (char)'*')) {
                ++pos.start;
            }
        } while (!Strings.isCharASCII((byte[])filterBytes, (int)pos.start, (char)')'));
        return node;
    }

    private static ExprNode parsePresenceEqOrSubstring(SchemaManager schemaManager, String attribute, byte[] filterBytes, Position pos) throws ParseException, LdapException {
        byte b = Strings.byteAt((byte[])filterBytes, (int)pos.start);
        switch (b) {
            case 42: {
                ++pos.start;
                if (Strings.isCharASCII((byte[])filterBytes, (int)pos.start, (char)')')) {
                    if (schemaManager != null) {
                        AttributeType attributeType = schemaManager.getAttributeType(attribute);
                        if (attributeType != null) {
                            return new PresenceNode(attributeType);
                        }
                        return null;
                    }
                    return new PresenceNode(attribute);
                }
                return FilterParser.parseSubstring(schemaManager, attribute, null, filterBytes, pos);
            }
            case 41: {
                if (schemaManager != null) {
                    AttributeType attributeType = schemaManager.getAttributeType(attribute);
                    if (attributeType != null) {
                        return new EqualityNode(attributeType, new Value((byte[])null));
                    }
                    return null;
                }
                return new EqualityNode(attribute, (byte[])null);
            }
        }
        Value value = FilterParser.parseAssertionValue(schemaManager, attribute, filterBytes, pos);
        b = Strings.byteAt((byte[])filterBytes, (int)pos.start);
        switch (b) {
            case 41: {
                if (schemaManager != null) {
                    AttributeType attributeType = schemaManager.getAttributeType(attribute);
                    if (attributeType != null) {
                        return new EqualityNode(attributeType, value);
                    }
                    return null;
                }
                return new EqualityNode(attribute, value.getBytes());
            }
            case 42: {
                ++pos.start;
                return FilterParser.parseSubstring(schemaManager, attribute, value, filterBytes, pos);
            }
        }
        throw new ParseException(I18n.err((I18n)I18n.ERR_13309_BAD_SUBSTRING, (Object[])new Object[0]), pos.start);
    }

    private static ExprNode parseItem(SchemaManager schemaManager, byte[] filterBytes, Position pos, byte b, boolean relaxed) throws ParseException, LdapException {
        if (b == 0) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_13310_BAD_CHAR, (Object[])new Object[0]), pos.start);
        }
        if (b == 58) {
            return FilterParser.parseExtensible(schemaManager, null, filterBytes, pos, relaxed);
        }
        String attribute = AttributeUtils.parseAttribute(filterBytes, pos, true, relaxed);
        FilterParser.skipWhiteSpaces(filterBytes, pos);
        b = Strings.byteAt((byte[])filterBytes, (int)pos.start);
        switch (b) {
            case 61: {
                ++pos.start;
                return FilterParser.parsePresenceEqOrSubstring(schemaManager, attribute, filterBytes, pos);
            }
            case 126: {
                ++pos.start;
                if (!Strings.isCharASCII((byte[])filterBytes, (int)pos.start, (char)'=')) {
                    throw new ParseException(I18n.err((I18n)I18n.ERR_13311_EXPECTING_EQUAL, (Object[])new Object[0]), pos.start);
                }
                ++pos.start;
                if (schemaManager == null) {
                    return new ApproximateNode(attribute, FilterParser.parseAssertionValue(schemaManager, attribute, filterBytes, pos).getBytes());
                }
                AttributeType attributeType = schemaManager.getAttributeType(attribute);
                if (attributeType != null) {
                    return new ApproximateNode(attributeType, FilterParser.parseAssertionValue(schemaManager, attribute, filterBytes, pos));
                }
                return new UndefinedNode(attribute);
            }
            case 62: {
                ++pos.start;
                if (!Strings.isCharASCII((byte[])filterBytes, (int)pos.start, (char)'=')) {
                    throw new ParseException(I18n.err((I18n)I18n.ERR_13311_EXPECTING_EQUAL, (Object[])new Object[0]), pos.start);
                }
                ++pos.start;
                if (schemaManager == null) {
                    return new GreaterEqNode(attribute, FilterParser.parseAssertionValue(schemaManager, attribute, filterBytes, pos).getBytes());
                }
                AttributeType attributeType = schemaManager.getAttributeType(attribute);
                if (attributeType != null) {
                    return new GreaterEqNode(attributeType, FilterParser.parseAssertionValue(schemaManager, attribute, filterBytes, pos));
                }
                return UndefinedNode.UNDEFINED_NODE;
            }
            case 60: {
                ++pos.start;
                if (!Strings.isCharASCII((byte[])filterBytes, (int)pos.start, (char)'=')) {
                    throw new ParseException(I18n.err((I18n)I18n.ERR_13311_EXPECTING_EQUAL, (Object[])new Object[0]), pos.start);
                }
                ++pos.start;
                if (schemaManager == null) {
                    return new LessEqNode(attribute, FilterParser.parseAssertionValue(schemaManager, attribute, filterBytes, pos).getBytes());
                }
                AttributeType attributeType = schemaManager.getAttributeType(attribute);
                if (attributeType != null) {
                    return new LessEqNode(attributeType, FilterParser.parseAssertionValue(schemaManager, attribute, filterBytes, pos));
                }
                return UndefinedNode.UNDEFINED_NODE;
            }
            case 58: {
                ++pos.start;
                return FilterParser.parseExtensible(schemaManager, attribute, filterBytes, pos, relaxed);
            }
        }
        throw new ParseException(I18n.err((I18n)I18n.ERR_13312_ITEM_EXPECTED, (Object[])new Object[0]), pos.start);
    }

    private static ExprNode parseBranchNode(SchemaManager schemaManager, ExprNode node, byte[] filterBytes, Position pos, boolean relaxed) throws ParseException, LdapException {
        BranchNode branchNode = (BranchNode)node;
        int nbChildren = 0;
        ExprNode child = FilterParser.parseFilterInternal(schemaManager, filterBytes, pos, relaxed);
        if (!(child instanceof UndefinedNode)) {
            branchNode.addNode(child);
            if (branchNode instanceof NotNode) {
                return node;
            }
            ++nbChildren;
        } else if (node instanceof AndNode) {
            return UndefinedNode.UNDEFINED_NODE;
        }
        while ((child = FilterParser.parseFilterInternal(schemaManager, filterBytes, pos, relaxed)) != UndefinedNode.UNDEFINED_NODE) {
            if (child != null) {
                branchNode.addNode(child);
                ++nbChildren;
                continue;
            }
            if (!(node instanceof AndNode)) continue;
            return UndefinedNode.UNDEFINED_NODE;
        }
        if (nbChildren > 0) {
            return node;
        }
        return UndefinedNode.UNDEFINED_NODE;
    }

    private static ExprNode parseFilterComp(SchemaManager schemaManager, byte[] filterBytes, Position pos, boolean relaxed) throws ParseException, LdapException {
        ExprNode node;
        if (pos.start == pos.length) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_13313_EMPTY_FILTERCOMP, (Object[])new Object[0]), pos.start);
        }
        byte b = Strings.byteAt((byte[])filterBytes, (int)pos.start);
        switch (b) {
            case 38: {
                ++pos.start;
                FilterParser.skipWhiteSpaces(filterBytes, pos);
                node = new AndNode();
                node = FilterParser.parseBranchNode(schemaManager, node, filterBytes, pos, relaxed);
                break;
            }
            case 124: {
                ++pos.start;
                FilterParser.skipWhiteSpaces(filterBytes, pos);
                node = new OrNode();
                node = FilterParser.parseBranchNode(schemaManager, node, filterBytes, pos, relaxed);
                break;
            }
            case 33: {
                ++pos.start;
                FilterParser.skipWhiteSpaces(filterBytes, pos);
                node = new NotNode();
                node = FilterParser.parseBranchNode(schemaManager, node, filterBytes, pos, relaxed);
                break;
            }
            default: {
                node = FilterParser.parseItem(schemaManager, filterBytes, pos, b, relaxed);
            }
        }
        return node;
    }

    private static ExprNode parseFilterInternal(SchemaManager schemaManager, byte[] filterBytes, Position pos, boolean relaxed) throws ParseException, LdapException {
        FilterParser.skipWhiteSpaces(filterBytes, pos);
        if (!Strings.isCharASCII((byte[])filterBytes, (int)pos.start, (char)'(')) {
            if (pos.start == 0 && pos.length != 0) {
                throw new ParseException(I18n.err((I18n)I18n.ERR_13314_FILTER_MISSING_OPEN_PAR, (Object[])new Object[0]), 0);
            }
            return UndefinedNode.UNDEFINED_NODE;
        }
        ++pos.start;
        FilterParser.skipWhiteSpaces(filterBytes, pos);
        ExprNode node = FilterParser.parseFilterComp(schemaManager, filterBytes, pos, relaxed);
        if (node == UndefinedNode.UNDEFINED_NODE) {
            return UndefinedNode.UNDEFINED_NODE;
        }
        FilterParser.skipWhiteSpaces(filterBytes, pos);
        if (!Strings.isCharASCII((byte[])filterBytes, (int)pos.start, (char)')')) {
            throw new ParseException(I18n.err((I18n)I18n.ERR_13315_FILTER_MISSING_CLOSE_PAR, (Object[])new Object[0]), pos.start);
        }
        ++pos.start;
        FilterParser.skipWhiteSpaces(filterBytes, pos);
        return node;
    }
}

