/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.clientwindow;

import jakarta.faces.context.FacesContext;
import jakarta.faces.lifecycle.ClientWindow;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Random;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.StringUtils;
import org.apache.deltaspike.jsf.impl.util.ClientWindowHelper;
import org.apache.deltaspike.jsf.spi.scope.window.ClientWindowConfig;

public abstract class DeltaSpikeClientWindow
extends ClientWindow {
    public static final String DEFAULT_WINDOW_ID = "default";
    protected String id;
    protected int maxWindowIdCount = ClientWindowHelper.getMaxWindowIdLength();

    public String getId() {
        return this.id;
    }

    protected String sanitiseWindowId(String windowId) {
        if (windowId == null) {
            return null;
        }
        if ((windowId = StringUtils.removeSpecialChars((String)windowId)).length() > this.maxWindowIdCount) {
            windowId = windowId.substring(0, this.maxWindowIdCount);
        }
        return windowId;
    }

    protected String generateNewWindowId() {
        return Integer.toString(new Random().nextInt() % 10000);
    }

    protected String generateNewRequestToken() {
        return Integer.toString((int)Math.floor(Math.random() * 999.0));
    }

    protected boolean isPost(FacesContext facesContext) {
        if (facesContext.isPostback()) {
            return true;
        }
        Object request = facesContext.getExternalContext().getRequest();
        return request instanceof HttpServletRequest && "POST".equals(((HttpServletRequest)request).getMethod());
    }

    protected String getWindowIdPostParameter(FacesContext facesContext) {
        Map requestParams = facesContext.getExternalContext().getRequestParameterMap();
        return (String)requestParams.get("jakarta.faces.ClientWindow");
    }

    protected String getWindowIdParameter(FacesContext facesContext) {
        Map requestParameters = facesContext.getExternalContext().getRequestParameterMap();
        return (String)requestParameters.get("jfwid");
    }

    protected ClientWindowConfig getClientWindowConfig() {
        return (ClientWindowConfig)BeanProvider.getContextualReference(ClientWindowConfig.class, (Annotation[])new Annotation[0]);
    }

    public abstract boolean isInitialRedirectSupported(FacesContext var1);

    public abstract String interceptRedirect(FacesContext var1, String var2);
}

