/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.testcontrol.impl.request;

import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import org.apache.deltaspike.cdise.api.ContextControl;
import org.apache.deltaspike.testcontrol.api.junit.CdiTestRunner;
import org.apache.deltaspike.testcontrol.spi.ExternalContainer;

@Decorator
public class ContextControlDecorator
implements ContextControl {
    @Inject
    @Delegate
    private ContextControl wrapped;

    public void startContexts() {
        this.wrapped.startContexts();
        if (this.isManualScopeHandling()) {
            for (ExternalContainer externalContainer : CdiTestRunner.getActiveExternalContainers()) {
                externalContainer.startScope(Singleton.class);
                externalContainer.startScope(ApplicationScoped.class);
                externalContainer.startScope(RequestScoped.class);
                externalContainer.startScope(SessionScoped.class);
                externalContainer.startScope(ConversationScoped.class);
            }
        }
    }

    public void stopContexts() {
        if (this.isManualScopeHandling()) {
            for (ExternalContainer externalContainer : CdiTestRunner.getActiveExternalContainers()) {
                externalContainer.stopScope(ConversationScoped.class);
                externalContainer.stopScope(SessionScoped.class);
                externalContainer.stopScope(RequestScoped.class);
                externalContainer.stopScope(ApplicationScoped.class);
                externalContainer.stopScope(Singleton.class);
            }
        }
        this.wrapped.stopContexts();
    }

    public void startContext(Class<? extends Annotation> scopeClass) {
        this.wrapped.startContext(scopeClass);
        if (this.isManuallyHandledRequest(scopeClass)) {
            for (ExternalContainer externalContainer : CdiTestRunner.getActiveExternalContainers()) {
                externalContainer.startScope(scopeClass);
            }
        }
    }

    public void stopContext(Class<? extends Annotation> scopeClass) {
        this.wrapped.stopContext(scopeClass);
        if (this.isManuallyHandledRequest(scopeClass)) {
            for (ExternalContainer externalContainer : CdiTestRunner.getActiveExternalContainers()) {
                externalContainer.stopScope(scopeClass);
            }
        }
    }

    private boolean isManuallyHandledRequest(Class<? extends Annotation> scopeClass) {
        return RequestScoped.class.equals(scopeClass) && this.isManualScopeHandling();
    }

    private boolean isManualScopeHandling() {
        return !Boolean.TRUE.equals(CdiTestRunner.isAutomaticScopeHandlingActive());
    }
}

