/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.meta;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.persistence.LockModeType;
import org.apache.deltaspike.core.util.AnnotationUtils;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.StringUtils;
import org.apache.deltaspike.data.api.Modifying;
import org.apache.deltaspike.data.api.Query;
import org.apache.deltaspike.data.api.Repository;
import org.apache.deltaspike.data.api.SingleResultType;
import org.apache.deltaspike.data.api.mapping.MappingConfig;
import org.apache.deltaspike.data.api.mapping.QueryInOutMapper;
import org.apache.deltaspike.data.impl.builder.MethodExpressionException;
import org.apache.deltaspike.data.impl.builder.part.QueryRoot;
import org.apache.deltaspike.data.impl.builder.result.QueryProcessorFactory;
import org.apache.deltaspike.data.impl.handler.EntityRepositoryHandler;
import org.apache.deltaspike.data.impl.meta.RepositoryMetadata;
import org.apache.deltaspike.data.impl.meta.RepositoryMethodMetadata;
import org.apache.deltaspike.data.impl.meta.RepositoryMethodPrefix;
import org.apache.deltaspike.data.impl.meta.RepositoryMethodType;
import org.apache.deltaspike.data.impl.meta.RequiresTransaction;
import org.apache.deltaspike.jpa.api.transaction.Transactional;

@ApplicationScoped
public class RepositoryMethodMetadataInitializer {
    @Inject
    private QueryProcessorFactory queryProcessorFactory;

    public RepositoryMethodMetadata init(RepositoryMetadata repositoryMetadata, Method method, BeanManager beanManager) {
        RepositoryMethodMetadata repositoryMethodMetadata = new RepositoryMethodMetadata();
        repositoryMethodMetadata.setMethod(method);
        repositoryMethodMetadata.setReturnsOptional(Optional.class.isAssignableFrom(method.getReturnType()));
        repositoryMethodMetadata.setReturnsStream(Stream.class.isAssignableFrom(method.getReturnType()));
        repositoryMethodMetadata.setQuery(method.isAnnotationPresent(Query.class) ? method.getAnnotation(Query.class) : null);
        repositoryMethodMetadata.setModifying(method.isAnnotationPresent(Modifying.class) ? method.getAnnotation(Modifying.class) : null);
        repositoryMethodMetadata.setTransactional((Transactional)AnnotationUtils.extractAnnotationFromMethodOrClass((BeanManager)beanManager, (Method)method, repositoryMetadata.getRepositoryClass(), Transactional.class));
        repositoryMethodMetadata.setMethodPrefix(new RepositoryMethodPrefix(repositoryMetadata.getRepositoryClass().getAnnotation(Repository.class).methodPrefix(), method.getName()));
        repositoryMethodMetadata.setMethodType(this.extractMethodType(repositoryMetadata, repositoryMethodMetadata));
        repositoryMethodMetadata.setQueryProcessor(this.queryProcessorFactory.build(repositoryMethodMetadata));
        repositoryMethodMetadata.setQueryInOutMapperClass(this.extractMapper(method, repositoryMetadata));
        this.initQueryRoot(repositoryMetadata, repositoryMethodMetadata);
        this.initQueryInOutMapperIsNormalScope(repositoryMethodMetadata, beanManager);
        this.initSingleResultType(repositoryMethodMetadata);
        this.initRequiresTransaction(repositoryMethodMetadata);
        return repositoryMethodMetadata;
    }

    private RepositoryMethodType extractMethodType(RepositoryMetadata repositoryMetadata, RepositoryMethodMetadata repositoryMethodMetadata) {
        if (this.isAnnotated(repositoryMethodMetadata)) {
            return RepositoryMethodType.ANNOTATED;
        }
        if (this.isMethodExpression(repositoryMetadata, repositoryMethodMetadata)) {
            return RepositoryMethodType.PARSE;
        }
        return RepositoryMethodType.DELEGATE;
    }

    private void initQueryRoot(RepositoryMetadata repositoryMetadata, RepositoryMethodMetadata methodMetadata) {
        if (methodMetadata.getMethodType() == RepositoryMethodType.PARSE) {
            methodMetadata.setQueryRoot(QueryRoot.create(methodMetadata.getMethod().getName(), repositoryMetadata, methodMetadata.getMethodPrefix()));
        } else {
            methodMetadata.setQueryRoot(QueryRoot.UNKNOWN_ROOT);
        }
    }

    private void initQueryInOutMapperIsNormalScope(RepositoryMethodMetadata repositoryMethodMetadata, BeanManager beanManager) {
        if (repositoryMethodMetadata.getQueryInOutMapperClass() != null) {
            Set beans = beanManager.getBeans(repositoryMethodMetadata.getQueryInOutMapperClass(), new Annotation[0]);
            Class scope = beanManager.resolve(beans).getScope();
            repositoryMethodMetadata.setQueryInOutMapperIsNormalScope(beanManager.isNormalScope(scope));
        }
    }

    private boolean isAnnotated(RepositoryMethodMetadata repositoryMethodMetadata) {
        if (repositoryMethodMetadata.getQuery() != null) {
            return this.isValid(repositoryMethodMetadata.getQuery());
        }
        return false;
    }

    private boolean isValid(Query query) {
        return StringUtils.isNotEmpty((String)query.value()) || StringUtils.isNotEmpty((String)query.named());
    }

    private boolean isMethodExpression(RepositoryMetadata repositoryMetadata, RepositoryMethodMetadata repositoryMethodMetadata) {
        if (!Modifier.isAbstract(repositoryMethodMetadata.getMethod().getModifiers())) {
            return false;
        }
        try {
            QueryRoot.create(repositoryMethodMetadata.getMethod().getName(), repositoryMetadata, repositoryMethodMetadata.getMethodPrefix());
            return true;
        }
        catch (MethodExpressionException e) {
            return false;
        }
    }

    private Class<? extends QueryInOutMapper<?>> extractMapper(Method queryMethod, RepositoryMetadata repositoryMetadata) {
        if (queryMethod.isAnnotationPresent(MappingConfig.class)) {
            return queryMethod.getAnnotation(MappingConfig.class).value();
        }
        if (repositoryMetadata.getRepositoryClass().isAnnotationPresent(MappingConfig.class)) {
            return repositoryMetadata.getRepositoryClass().getAnnotation(MappingConfig.class).value();
        }
        return null;
    }

    private void initSingleResultType(RepositoryMethodMetadata repositoryMethodMetadata) {
        SingleResultType singleResultType;
        SingleResultType singleResultType2 = singleResultType = repositoryMethodMetadata.getQuery() != null ? repositoryMethodMetadata.getQuery().singleResult() : repositoryMethodMetadata.getMethodPrefix().getSingleResultStyle();
        if (repositoryMethodMetadata.isReturnsOptional() && singleResultType == SingleResultType.JPA) {
            repositoryMethodMetadata.setSingleResultType(SingleResultType.OPTIONAL);
        } else {
            repositoryMethodMetadata.setSingleResultType(singleResultType);
        }
    }

    private void initRequiresTransaction(RepositoryMethodMetadata repositoryMethodMetadata) {
        Method originalMethod;
        boolean requiresTransaction = false;
        if (ClassUtils.containsMethod(EntityRepositoryHandler.class, (Method)repositoryMethodMetadata.getMethod()) && (originalMethod = ClassUtils.extractMethod(EntityRepositoryHandler.class, (Method)repositoryMethodMetadata.getMethod())).isAnnotationPresent(RequiresTransaction.class)) {
            requiresTransaction = true;
        }
        Query query = repositoryMethodMetadata.getQuery();
        Modifying modifying = repositoryMethodMetadata.getModifying();
        if (query != null && !query.lock().equals((Object)LockModeType.NONE) || modifying != null) {
            requiresTransaction = true;
        }
        repositoryMethodMetadata.setRequiresTransaction(requiresTransaction);
    }
}

