/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.transport.ReceiveCommand;

public class TrackingRefUpdate {
    private final String remoteName;
    private final String localName;
    private boolean forceUpdate;
    private ObjectId oldObjectId;
    private ObjectId newObjectId;
    private RefUpdate.Result result;

    TrackingRefUpdate(boolean canForceUpdate, String remoteName, String localName, AnyObjectId oldValue, AnyObjectId newValue) {
        this.remoteName = remoteName;
        this.localName = localName;
        this.forceUpdate = canForceUpdate;
        this.oldObjectId = oldValue.copy();
        this.newObjectId = newValue.copy();
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public ObjectId getNewObjectId() {
        return this.newObjectId;
    }

    public ObjectId getOldObjectId() {
        return this.oldObjectId;
    }

    public RefUpdate.Result getResult() {
        return this.result;
    }

    void setResult(RefUpdate.Result result) {
        this.result = result;
    }

    ReceiveCommand asReceiveCommand() {
        return new Command();
    }

    final class Command
    extends ReceiveCommand {
        private Command() {
            super(TrackingRefUpdate.this.oldObjectId, TrackingRefUpdate.this.newObjectId, TrackingRefUpdate.this.localName);
        }

        boolean canForceUpdate() {
            return TrackingRefUpdate.this.forceUpdate;
        }

        public void setResult(RefUpdate.Result status) {
            TrackingRefUpdate.this.result = status;
            super.setResult(status);
        }

        public void setResult(ReceiveCommand.Result status) {
            TrackingRefUpdate.this.result = this.decode(status);
            super.setResult(status);
        }

        public void setResult(ReceiveCommand.Result status, String msg) {
            TrackingRefUpdate.this.result = this.decode(status);
            super.setResult(status, msg);
        }

        private RefUpdate.Result decode(ReceiveCommand.Result status) {
            switch (status) {
                case OK: {
                    if (AnyObjectId.equals(TrackingRefUpdate.this.oldObjectId, TrackingRefUpdate.this.newObjectId)) {
                        return RefUpdate.Result.NO_CHANGE;
                    }
                    switch (this.getType()) {
                        case CREATE: {
                            return RefUpdate.Result.NEW;
                        }
                        case UPDATE: {
                            return RefUpdate.Result.FAST_FORWARD;
                        }
                    }
                    return RefUpdate.Result.FORCED;
                }
                case REJECTED_NOCREATE: 
                case REJECTED_NODELETE: 
                case REJECTED_NONFASTFORWARD: {
                    return RefUpdate.Result.REJECTED;
                }
                case REJECTED_CURRENT_BRANCH: {
                    return RefUpdate.Result.REJECTED_CURRENT_BRANCH;
                }
                case REJECTED_MISSING_OBJECT: {
                    return RefUpdate.Result.IO_FAILURE;
                }
            }
            return RefUpdate.Result.LOCK_FAILURE;
        }
    }
}

