/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.torque.generator.configuration.OutletTypes;
import org.apache.torque.generator.configuration.mergepoint.ActionSaxHandlerFactories;
import org.apache.torque.generator.configuration.mergepoint.OptionsSaxHandlerFactories;
import org.apache.torque.generator.configuration.source.SourceSaxHandlerFactories;
import org.apache.torque.generator.control.outputtype.HtmlOutputType;
import org.apache.torque.generator.control.outputtype.JavaOutputType;
import org.apache.torque.generator.control.outputtype.OutputType;
import org.apache.torque.generator.control.outputtype.PropertiesOutputType;
import org.apache.torque.generator.control.outputtype.UnknownOutputType;
import org.apache.torque.generator.control.outputtype.XmlOutputType;
import org.apache.torque.generator.source.stream.PropertiesSourceFormat;
import org.apache.torque.generator.source.stream.StreamSourceFormat;
import org.apache.torque.generator.source.stream.XmlSourceFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationHandlers {
    private OutletTypes outletTypes = new OutletTypes();
    private Map<String, OutputType> outputTypes = new HashMap<String, OutputType>();
    private Set<StreamSourceFormat> streamSourceFormats = new HashSet<StreamSourceFormat>();
    private ActionSaxHandlerFactories actionSaxHandlerFactories = new ActionSaxHandlerFactories();
    private OptionsSaxHandlerFactories optionsSaxHandlerFactories = new OptionsSaxHandlerFactories();
    private SourceSaxHandlerFactories sourceSaxHandlerFactories = new SourceSaxHandlerFactories();

    public ConfigurationHandlers() {
        this.streamSourceFormats.add(new XmlSourceFormat());
        this.streamSourceFormats.add(new PropertiesSourceFormat());
        this.outputTypes.put("unknown", new UnknownOutputType());
        this.outputTypes.put("java", new JavaOutputType());
        this.outputTypes.put("xml", new XmlOutputType());
        this.outputTypes.put("html", new HtmlOutputType());
        this.outputTypes.put("properties", new PropertiesOutputType());
    }

    public OutletTypes getOutletTypes() {
        return this.outletTypes;
    }

    public Map<String, OutputType> getOutputTypes() {
        return this.outputTypes;
    }

    public SourceSaxHandlerFactories getSourceSaxHandlerFactories() {
        return this.sourceSaxHandlerFactories;
    }

    public Set<StreamSourceFormat> getStreamSourceFormats() {
        return this.streamSourceFormats;
    }

    public ActionSaxHandlerFactories getActionSaxHandlerFactories() {
        return this.actionSaxHandlerFactories;
    }

    public OptionsSaxHandlerFactories getOptionsSaxHandlerFactories() {
        return this.optionsSaxHandlerFactories;
    }
}

