/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.derbyTesting.functionTests.harness.JavaVersionHolder;
import org.apache.derbyTesting.functionTests.harness.RunTest;

public class TestUtil {
    public static boolean HAVE_DRIVER_CLASS;
    public static final int UNKNOWN_FRAMEWORK = -1;
    public static final int EMBEDDED_FRAMEWORK = 0;
    public static final int DERBY_NET_FRAMEWORK = 1;
    public static final int DB2JCC_FRAMEWORK = 2;
    public static final int DERBY_NET_CLIENT_FRAMEWORK = 3;
    public static final int OLD_NET_FRAMEWORK = 4;
    private static int framework;
    private static String XA_DATASOURCE_STRING;
    private static String CONNECTION_POOL_DATASOURCE_STRING;
    private static String REGULAR_DATASOURCE_STRING;
    private static Class[] STRING_ARG_TYPE;
    private static Class[] INT_ARG_TYPE;
    private static Class[] BOOLEAN_ARG_TYPE;
    private static Hashtable<String, Class[]> specialAttributes;
    public static String TABLE_START_TAG;
    public static String TABLE_END_TAG;
    public static String TD_INVERSE;
    public static String TD_CENTER;
    public static String TD_LEFT;
    public static String TD_END;
    public static String END_HTML_PAGE;

    public static boolean isNetFramework() {
        framework = TestUtil.getFramework();
        switch (framework) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static boolean isJCCFramework() {
        int framework = TestUtil.getFramework();
        switch (framework) {
            case 1: 
            case 2: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDerbyNetClientFramework() {
        return TestUtil.getFramework() == 3;
    }

    public static boolean isEmbeddedFramework() {
        return TestUtil.getFramework() == 0;
    }

    private static int getFramework() {
        String useprocessFramework;
        if (framework != -1) {
            return framework;
        }
        String frameworkString = System.getProperty("framework");
        if (frameworkString == null && (useprocessFramework = RunTest.framework) != null) {
            frameworkString = useprocessFramework;
        }
        if (frameworkString == null || frameworkString.toUpperCase(Locale.ENGLISH).equals("EMBEDDED")) {
            framework = 0;
        } else if (frameworkString.toUpperCase(Locale.ENGLISH).equals("DERBYNETCLIENT")) {
            framework = 3;
        } else if (frameworkString.toUpperCase(Locale.ENGLISH).equals("DERBYNET")) {
            framework = 1;
        } else if (frameworkString.toUpperCase(Locale.ENGLISH).indexOf("DB2JNET") != -1) {
            framework = 4;
        }
        return framework;
    }

    public static String getJdbcUrlPrefix() {
        String hostName = TestUtil.getHostName();
        return TestUtil.getJdbcUrlPrefix(hostName, 1527);
    }

    public static String getHostName() {
        String hostName = System.getProperty("hostName");
        if (hostName == null) {
            hostName = "localhost";
        }
        return hostName;
    }

    public static String getJdbcUrlPrefix(String server, int port) {
        int framework = TestUtil.getFramework();
        switch (framework) {
            case 0: {
                return "jdbc:derby:";
            }
            case 1: 
            case 4: {
                return "jdbc:derby:net://" + server + ":" + port + "/";
            }
            case 3: {
                return "jdbc:derby://" + server + ":" + port + "/";
            }
            case 2: {
                return "jdbc:db2://" + server + ":" + port + "/";
            }
        }
        return null;
    }

    public static void loadDriver() throws Exception {
        framework = TestUtil.getFramework();
        Class<?> clazz = Class.forName(switch (framework) {
            case 0 -> "org.apache.derby.jdbc.EmbeddedDriver";
            case 1, 2, 4 -> "com.ibm.db2.jcc.DB2Driver";
            case 3 -> "org.apache.derby.jdbc.ClientDriver";
            default -> "org.apache.derby.jdbc.EmbeddedDriver";
        });
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static DataSource getDataSource(Properties attrs) {
        String classname = TestUtil.getDataSourcePrefix() + REGULAR_DATASOURCE_STRING + "DataSource40";
        return (DataSource)TestUtil.getDataSourceWithReflection(classname, attrs);
    }

    public static XADataSource getXADataSource(Properties attrs) {
        String classname = TestUtil.getDataSourcePrefix() + XA_DATASOURCE_STRING + "DataSource40";
        return (XADataSource)TestUtil.getDataSourceWithReflection(classname, attrs);
    }

    public static ConnectionPoolDataSource getConnectionPoolDataSource(Properties attrs) {
        String classname = TestUtil.getDataSourcePrefix() + CONNECTION_POOL_DATASOURCE_STRING + "DataSource40";
        return (ConnectionPoolDataSource)TestUtil.getDataSourceWithReflection(classname, attrs);
    }

    public static String getDataSourcePrefix() {
        framework = TestUtil.getFramework();
        switch (framework) {
            case 1: 
            case 2: 
            case 4: {
                return "com.ibm.db2.jcc.DB2";
            }
            case 3: {
                return "org.apache.derby.jdbc.Client";
            }
            case 0: {
                return "org.apache.derby.jdbc.Embedded";
            }
        }
        Exception e = new Exception("FAIL: No DataSource Prefix for framework: " + framework);
        e.printStackTrace();
        return null;
    }

    private static Object getDataSourceWithReflection(String classname, Properties attrs) {
        Object[] args = null;
        Object ds = null;
        Method sh = null;
        String methodName = null;
        if (specialAttributes == null) {
            specialAttributes = new Hashtable();
            specialAttributes.put("portNumber", INT_ARG_TYPE);
            specialAttributes.put("driverType", INT_ARG_TYPE);
            specialAttributes.put("retrieveMessagesFromServerOnGetMessage", BOOLEAN_ARG_TYPE);
            specialAttributes.put("retrieveMessageText", BOOLEAN_ARG_TYPE);
        }
        try {
            Class<?> clazz = Class.forName(classname);
            ds = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            String hostName = TestUtil.getHostName();
            if (!TestUtil.isEmbeddedFramework() && hostName != null && attrs.getProperty("serverName") == null) {
                attrs.setProperty("serverName", hostName);
            }
            Enumeration<?> propNames = attrs.propertyNames();
            while (propNames.hasMoreElements()) {
                String key = (String)propNames.nextElement();
                Class[] argType = specialAttributes.get(key);
                if (argType == null) {
                    argType = STRING_ARG_TYPE;
                }
                String value = attrs.getProperty(key);
                if (argType == INT_ARG_TYPE) {
                    args = new Integer[]{Integer.valueOf(value)};
                } else if (argType == BOOLEAN_ARG_TYPE) {
                    args = new Boolean[]{Boolean.valueOf(value)};
                } else if (argType == STRING_ARG_TYPE) {
                    args = new String[]{value};
                } else {
                    throw new Exception("FAIL: getDataSourceWithReflection: Argument type " + argType[0].getName() + " not supportted for attribute:  key:" + key + " value:" + value);
                }
                methodName = TestUtil.getSetterName(key);
                sh = ds.getClass().getMethod(methodName, argType);
                sh.invoke(ds, args);
            }
        }
        catch (Exception e) {
            System.out.println("Error accessing method " + methodName);
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return ds;
    }

    public static String getSetterName(String attribute) {
        return "set" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
    }

    public static String getGetterName(String attribute) {
        return "get" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
    }

    public static void dumpSQLExceptions(SQLException sqle) {
        TestUtil.dumpSQLExceptions(sqle, false);
    }

    public static void dumpSQLExceptions(SQLException sqle, boolean expected) {
        String prefix = "";
        if (!expected) {
            System.out.println("FAIL -- unexpected exception ****************");
        } else {
            prefix = "EXPECTED ";
        }
        do {
            System.out.println(prefix + "SQLSTATE(" + sqle.getSQLState() + "): " + sqle.getMessage());
        } while ((sqle = sqle.getNextException()) != null);
    }

    public static String sqlNameFromJdbc(int jdbcType) {
        switch (jdbcType) {
            case -7: {
                return "Types.BIT";
            }
            case 16: {
                return "Types.BOOLEAN";
            }
            case -6: {
                return "Types.TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "Types.FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "Types.NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONG VARCHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "CHAR () FOR BIT DATA";
            }
            case -3: {
                return "VARCHAR () FOR BIT DATA";
            }
            case -4: {
                return "LONG VARCHAR FOR BIT DATA";
            }
            case 2004: {
                return "BLOB";
            }
            case 1111: {
                return "Types.OTHER";
            }
            case 0: {
                return "Types.NULL";
            }
        }
        return String.valueOf(jdbcType);
    }

    public static String getNameFromJdbcType(int jdbcType) {
        switch (jdbcType) {
            case -7: {
                return "Types.BIT";
            }
            case 16: {
                return "Types.BOOLEAN";
            }
            case -6: {
                return "Types.TINYINT";
            }
            case 5: {
                return "Types.SMALLINT";
            }
            case 4: {
                return "Types.INTEGER";
            }
            case -5: {
                return "Types.BIGINT";
            }
            case 6: {
                return "Types.FLOAT";
            }
            case 7: {
                return "Types.REAL";
            }
            case 8: {
                return "Types.DOUBLE";
            }
            case 2: {
                return "Types.NUMERIC";
            }
            case 3: {
                return "Types.DECIMAL";
            }
            case 1: {
                return "Types.CHAR";
            }
            case 12: {
                return "Types.VARCHAR";
            }
            case -1: {
                return "Types.LONGVARCHAR";
            }
            case 2005: {
                return "Types.CLOB";
            }
            case 91: {
                return "Types.DATE";
            }
            case 92: {
                return "Types.TIME";
            }
            case 93: {
                return "Types.TIMESTAMP";
            }
            case -2: {
                return "Types.BINARY";
            }
            case -3: {
                return "Types.VARBINARY";
            }
            case -4: {
                return "Types.LONGVARBINARY";
            }
            case 2004: {
                return "Types.BLOB";
            }
            case 1111: {
                return "Types.OTHER";
            }
            case 0: {
                return "Types.NULL";
            }
        }
        return String.valueOf(jdbcType);
    }

    public static void startHTMLPage(String title, String author) {
        System.out.println("<HTML> \n <HEAD>");
        System.out.println(" <meta http-equiv=\"Content-Type\"content=\"text/html; charset=iso-8859-1\">");
        System.out.println("<meta name=\"Author\" content=\"" + author + "\">");
        System.out.println("<title>" + title + "</title>");
        System.out.println("</HEAD> <BODY>");
        System.out.println("<H1>" + title + "</H1>");
    }

    public static void endHTMLPage() {
        System.out.println(END_HTML_PAGE);
    }

    public static void printBoolArrayHTMLTable(String rowDescription, String columnDescription, String[] rowLabels, String[] colLabels, boolean[][] array, String tableInfo) {
        int i;
        System.out.println("<H2>" + tableInfo + "</H2>");
        System.out.println(TABLE_START_TAG);
        System.out.println("<TR>");
        System.out.println(TD_INVERSE + columnDescription + "---><BR><BR><BR><BR><BR>");
        System.out.println("<---" + rowDescription);
        System.out.println(TD_END);
        for (i = 0; i < colLabels.length; ++i) {
            System.out.println(TD_INVERSE);
            for (int c = 0; c < colLabels[i].length() && c < 20; ++c) {
                System.out.println(colLabels[i].charAt(c) + "<BR>");
            }
            System.out.println(TD_END);
        }
        System.out.println("</TR>");
        for (i = 0; i < rowLabels.length; ++i) {
            System.out.println("<TR>");
            System.out.println(TD_LEFT);
            System.out.println("<C> " + rowLabels[i] + "</C>");
            System.out.println(TD_END);
            for (int j = 0; j < colLabels.length; ++j) {
                System.out.println(TD_CENTER);
                System.out.println(array[i][j] ? "Y" : "-");
                System.out.println(TD_END);
            }
            System.out.println("</TR>");
        }
        System.out.println(TABLE_END_TAG);
        System.out.println("<P><P>");
    }

    public static String stringToHexLiteral(String s) {
        String hexLiteral = null;
        try {
            byte[] bytes = s.getBytes("UTF-16BE");
            hexLiteral = TestUtil.convertToHexString(bytes);
        }
        catch (UnsupportedEncodingException ue) {
            System.out.println("This shouldn't happen as UTF-16BE should be supported");
            ue.printStackTrace();
        }
        return hexLiteral;
    }

    private static String convertToHexString(byte[] buf) {
        StringBuffer str = new StringBuffer();
        str.append("X'");
        for (int i = 0; i < buf.length; ++i) {
            int byteVal = buf[i] & 0xFF;
            String val = Integer.toHexString(byteVal);
            if (val.length() < 2) {
                str.append("0");
            }
            str.append(val);
        }
        return str.toString() + "'";
    }

    public static int getJDBCMajorVersion(Connection conn) {
        try {
            conn.getClass().getMethod("setSavepoint", null);
            DatabaseMetaData meta = conn.getMetaData();
            Method method = meta.getClass().getMethod("getJDBCMajorVersion", null);
            return ((Number)method.invoke((Object)meta, null)).intValue();
        }
        catch (Throwable t) {
            return 2;
        }
    }

    public static void cleanUpTest(Statement s, String[] testObjects) throws SQLException {
        for (int i = 0; i < testObjects.length; ++i) {
            try {
                s.execute("drop " + testObjects[i]);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static Connection getConnection(String databaseName, String connAttrs) throws SQLException {
        try {
            Connection conn;
            if (HAVE_DRIVER_CLASS) {
                int framework = TestUtil.getFramework();
                Class<?> clazz = Class.forName(switch (framework) {
                    case 0 -> "org.apache.derby.jdbc.EmbeddedDriver";
                    case 1, 2, 4 -> "com.ibm.db2.jcc.DB2Driver";
                    case 3 -> "org.apache.derby.jdbc.ClientDriver";
                    default -> "org.apache.derby.jdbc.EmbeddedDriver";
                });
                clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                String url = TestUtil.getJdbcUrlPrefix() + databaseName;
                if (connAttrs != null) {
                    url = url + ";" + connAttrs;
                }
                if (framework == 1 && (connAttrs == null || connAttrs != null && connAttrs.indexOf("user") < 0)) {
                    url = url + ":user=APP;password=APP;retrieveMessagesFromServerOnGetMessage=true;";
                }
                conn = DriverManager.getConnection(url);
            } else {
                Properties prop = new Properties();
                prop.setProperty("databaseName", databaseName);
                if (connAttrs != null) {
                    prop.setProperty("connectionAttributes", connAttrs);
                }
                conn = TestUtil.getDataSourceConnection(prop);
            }
            return conn;
        }
        catch (ClassNotFoundException cnfe) {
            System.out.println("FAILure: Class not found!");
            cnfe.printStackTrace();
            return null;
        }
        catch (InstantiationException inste) {
            System.out.println("FAILure: Cannot instantiate class");
            inste.printStackTrace();
            return null;
        }
        catch (IllegalAccessException ille) {
            System.out.println("FAILure: Not allowed to use class");
            ille.printStackTrace();
            return null;
        }
        catch (NoSuchMethodException ille) {
            System.out.println("FAILure: No such constructor");
            ille.printStackTrace();
            return null;
        }
        catch (InvocationTargetException ille) {
            System.out.println("FAILure: Cannot execute constructor");
            ille.printStackTrace();
            return null;
        }
    }

    public static Connection getDataSourceConnection(Properties prop) throws SQLException {
        DataSource ds = TestUtil.getDataSource(prop);
        Connection conn = ds.getConnection();
        return conn;
    }

    public static void shutdownUsingDataSource(String dbName) throws SQLException {
        Properties prop = new Properties();
        prop.setProperty("databaseName", dbName);
        prop.setProperty("shutdownDatabase", "shutdown");
        DataSource ds = TestUtil.getDataSource(prop);
        Connection connection = ds.getConnection();
    }

    public static boolean compareURL(String url) {
        if (TestUtil.isEmbeddedFramework()) {
            if (url.compareTo("jdbc:derby:wombat") == 0) {
                return true;
            }
        } else if (TestUtil.isNetFramework()) {
            try {
                StringTokenizer urlTokenizer = new StringTokenizer(url, "/");
                String urlStart = urlTokenizer.nextToken();
                urlTokenizer.nextToken();
                String urlEnd = urlTokenizer.nextToken();
                if (urlEnd.compareTo("wombat;create=true") != 0) {
                    return false;
                }
                if (TestUtil.isJCCFramework() && urlStart.compareTo("jdbc:derby:net:") == 0) {
                    return true;
                }
                if (TestUtil.isDerbyNetClientFramework() && urlStart.compareTo("jdbc:derby:") == 0) {
                    return true;
                }
            }
            catch (NoSuchElementException nsee) {
                return false;
            }
        }
        return false;
    }

    public static void dumpAllStackTracesIfSupported(PrintWriter log) {
        try {
            String version = System.getProperty("java.version");
            JavaVersionHolder j = new JavaVersionHolder(version);
            if (j.atLeast(1, 5)) {
                Class<?> c = Class.forName("org.apache.derbyTesting.functionTests.util.ThreadDump");
                Method m = c.getMethod("getStackDumpString", new Class[0]);
                String dump = (String)m.invoke(null, new Object[0]);
                log.println(dump);
            }
        }
        catch (Exception e) {
            log.println("Error trying to dump thread stack traces");
            if (e instanceof InvocationTargetException) {
                ((InvocationTargetException)e).getTargetException().printStackTrace(log);
            }
            e.printStackTrace(log);
        }
    }

    static {
        try {
            Class.forName("java.sql.Driver");
            HAVE_DRIVER_CLASS = true;
        }
        catch (ClassNotFoundException e) {
            HAVE_DRIVER_CLASS = false;
        }
        framework = -1;
        XA_DATASOURCE_STRING = "XA";
        CONNECTION_POOL_DATASOURCE_STRING = "ConnectionPool";
        REGULAR_DATASOURCE_STRING = "";
        STRING_ARG_TYPE = new Class[]{String.class};
        INT_ARG_TYPE = new Class[]{Integer.TYPE};
        BOOLEAN_ARG_TYPE = new Class[]{Boolean.TYPE};
        specialAttributes = null;
        TABLE_START_TAG = "<TABLE border=1 cellspacing=1 cellpadding=1  bgcolor=white  style='width:100%'>";
        TABLE_END_TAG = "</TABLE>";
        TD_INVERSE = "<td  valign=bottom align=center style=background:#DADADA;  padding:.75pt .75pt .75pt .75pt'> <p class=MsoNormal style='margin-top:6.0pt;margin-right:0in;margin-bottom:  6.0pt;margin-left:0in'><b><span style='font-size:8.5pt;font-family:Arial;  color:black'>";
        TD_CENTER = "<TD valign=center align=center> <p class=MsoNormal style='margin-top:6.0pt;margin-right:0in;margin-bottom:6.0pt;margin-left:0in'><b><span style='font-size:8.5pt;font-family:Arial;  color:black'>";
        TD_LEFT = "<TD valign=center align=left> <p class=MsoNormal style='margin-top:6.0pt;margin-right:0in;margin-bottom:6.0pt;margin-left:0in'><b><span style='font-size:8.5pt;font-family:Arial;  color:black'>";
        TD_END = "</SPAN></TD>";
        END_HTML_PAGE = "</BODY> </HTML>";
    }
}

