/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby3980DeadlockTest
extends BaseJDBCTestCase {
    private final int THREAD_COUNT = 2;
    private final LinkedList<Throwable> listExceptions = new LinkedList();
    private final Object syncObject = new Object();
    private int startedCount = 0;
    private static final String fprefix = "javacore";

    public Derby3980DeadlockTest(String name) {
        super(name);
    }

    public void test3980Deadlock() {
        Thread[] t = new Thread[2];
        this.createThreads(t);
        this.waitForThreads(t);
        this.checkExceptions();
    }

    private void checkExceptions() {
        for (Throwable t : this.listExceptions) {
            if (t instanceof SQLException) {
                Derby3980DeadlockTest.assertSQLState("40001", (SQLException)t);
                continue;
            }
            Derby3980DeadlockTest.fail("Unexpected exception", t);
        }
        Derby3980DeadlockTest.assertEquals((String)("Expected 1 exception, got" + this.listExceptions.size()), (int)1, (int)this.listExceptions.size());
    }

    private static Test decorateTest() {
        Object test = TestConfiguration.clientServerSuite(Derby3980DeadlockTest.class);
        Properties diagProperties = new Properties();
        diagProperties.setProperty("derby.stream.error.extendedDiagSeverityLevel", "30000");
        diagProperties.setProperty("derby.infolog.append", "true");
        test = new SystemPropertyTestSetup((Test)test, diagProperties, true);
        return test;
    }

    private void waitForThreads(Thread[] t) {
        for (int i = 0; i < 2; ++i) {
            try {
                t[i].join();
                continue;
            }
            catch (InterruptedException e) {
                Derby3980DeadlockTest.fail((String)"FAIL - InterruptedException  thrown waiting for the threads");
            }
        }
    }

    private void createThreads(Thread[] t) {
        for (int i = 0; i < 2; ++i) {
            t[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    this.threadWorker();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void threadWorker() {
                    Connection threadConnection = null;
                    try {
                        Object object = Derby3980DeadlockTest.this.syncObject;
                        synchronized (object) {
                            if (threadConnection == null) {
                                threadConnection = Derby3980DeadlockTest.this.openDefaultConnection();
                            }
                            ++Derby3980DeadlockTest.this.startedCount;
                            Derby3980DeadlockTest.this.syncObject.notifyAll();
                            while (Derby3980DeadlockTest.this.startedCount < 2) {
                                Derby3980DeadlockTest.this.syncObject.wait();
                            }
                        }
                        Statement stmt = threadConnection.createStatement();
                        threadConnection.setAutoCommit(false);
                        threadConnection.setTransactionIsolation(4);
                        ResultSet rs = stmt.executeQuery("select * from t where i = 456");
                        while (rs.next()) {
                        }
                        stmt.executeUpdate("delete from t  where i = 456");
                        threadConnection.commit();
                    }
                    catch (Exception e) {
                        Object object = Derby3980DeadlockTest.this.syncObject;
                        synchronized (object) {
                            Derby3980DeadlockTest.this.listExceptions.add(e);
                        }
                    }
                }
            }, "Thread" + i);
            t[i].start();
        }
    }

    public static Test suite() {
        Test suite = Derby3980DeadlockTest.decorateTest();
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts(suite, 5, 10)){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                s.executeUpdate("CREATE TABLE T (I INT)");
                s.executeUpdate("INSERT INTO T VALUES(456)");
            }
        };
    }

    @Override
    protected void tearDown() throws Exception {
        String dsh = BaseTestCase.getSystemProperty("user.dir");
        try {
            File basedir = new File(dsh);
            String[] list = BaseTestCase.getFilesWith(basedir, fprefix);
            Derby3980DeadlockTest.removeFiles(list);
        }
        catch (IllegalArgumentException e) {
            Derby3980DeadlockTest.fail((String)"open directory");
        }
        super.tearDown();
    }
}

