/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.security.CodeSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;

public class ClassLoaderBootTest
extends BaseJDBCTestCase {
    private static URL derbyClassLocation = ClassLoaderBootTest.getClassLocation("org.apache.derby.database.Database");
    private static URL embeddedDataSourceClassLocation = ClassLoaderBootTest.getClassLocation("org.apache.derby.jdbc.EmbeddedDataSource");
    private ClassLoader loader_1;
    private ClassLoader loader_2;
    private ClassLoader mainLoader;

    private static URL getClassLocation(String className) {
        CodeSource cs;
        try {
            Class<?> cls = Class.forName(className);
            cs = cls.getProtectionDomain().getCodeSource();
        }
        catch (ClassNotFoundException e) {
            cs = null;
        }
        if (cs == null) {
            return null;
        }
        return cs.getLocation();
    }

    public ClassLoaderBootTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite;
        BaseTestSuite test = suite = new BaseTestSuite(ClassLoaderBootTest.class);
        TestSetup setup = new CleanDatabaseTestSetup((Test)test){

            @Override
            protected void setUp() throws Exception {
                super.setUp();
                DataSource ds = JDBCDataSource.getDataSource();
                JDBCDataSource.shutdownDatabase(ds);
            }
        };
        Properties p = new Properties();
        p.setProperty("derby.infolog.append", "true");
        setup = new SystemPropertyTestSetup((Test)setup, p);
        return setup;
    }

    protected void setUp() throws Exception {
        URL[] urls = new URL[]{derbyClassLocation, embeddedDataSourceClassLocation};
        this.mainLoader = this.getThreadLoader();
        this.loader_1 = this.createDerbyClassLoader(urls);
        this.loader_2 = this.createDerbyClassLoader(urls);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.mainLoader != null) {
            this.setThreadLoader(this.mainLoader);
        }
        this.loader_1 = null;
        this.loader_2 = null;
        this.mainLoader = null;
    }

    private DerbyURLClassLoader createDerbyClassLoader(URL[] urls) throws Exception {
        return new DerbyURLClassLoader(this, urls);
    }

    public void testBootingAnAlreadyBootedDatabase() throws SQLException {
        if (!JDBC.vmSupportsJDBC4()) {
            ClassLoaderBootTest.println("The dual boot test only runs on Java 6 and higher.");
            return;
        }
        ClassLoaderBootTest.println("The dual boot test is running.");
        this.setThreadLoader(this.loader_1);
        DataSource ds_1 = JDBCDataSource.getDataSource();
        ClassLoaderBootTest.assertEquals((Object)this.loader_1, (Object)this.getThreadLoader());
        ClassLoaderBootTest.assertEquals((Object)this.loader_1, (Object)ds_1.getClass().getClassLoader());
        Connection conn1 = ds_1.getConnection();
        this.setThreadLoader(this.loader_2);
        DataSource ds_2 = JDBCDataSource.getDataSource();
        ClassLoaderBootTest.assertEquals((Object)this.loader_2, (Object)this.getThreadLoader());
        ClassLoaderBootTest.assertEquals((Object)this.loader_2, (Object)ds_2.getClass().getClassLoader());
        try {
            ds_2.getConnection();
            ClassLoaderBootTest.fail((String)"booted database that was already booted by another CLR");
        }
        catch (SQLException e) {
            SQLException ne = e.getNextException();
            ClassLoaderBootTest.assertPreventDualBoot(ne);
            JDBCDataSource.shutEngine(ds_2);
        }
        this.setThreadLoader(this.loader_1);
        JDBCDataSource.shutEngine(ds_1);
    }

    public void testBootingDatabaseShutdownByAnotherCLR() throws SQLException {
        this.setThreadLoader(this.loader_1);
        DataSource ds_1 = JDBCDataSource.getDataSource();
        ClassLoaderBootTest.assertEquals((Object)this.loader_1, (Object)ds_1.getClass().getClassLoader());
        Connection conn1 = ds_1.getConnection();
        JDBCDataSource.shutdownDatabase(ds_1);
        this.setThreadLoader(this.loader_2);
        DataSource ds_2 = JDBCDataSource.getDataSource();
        ClassLoaderBootTest.assertEquals((Object)this.loader_2, (Object)ds_2.getClass().getClassLoader());
        ds_2.getConnection();
        JDBCDataSource.shutEngine(ds_2);
        JDBCDataSource.shutEngine(ds_1);
    }

    private void setThreadLoader(ClassLoader which) {
        Thread.currentThread().setContextClassLoader(which);
    }

    private ClassLoader getThreadLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static void assertPreventDualBoot(SQLException ne) {
        ClassLoaderBootTest.assertNotNull((Object)ne);
        String state = ne.getSQLState();
        ClassLoaderBootTest.assertTrue((String)("Unexpected SQLState:" + state), (boolean)state.equals("XSDB6"));
    }

    public class DerbyURLClassLoader
    extends URLClassLoader {
        public DerbyURLClassLoader(ClassLoaderBootTest this$0, URL[] urls) {
            super(urls);
        }

        public DerbyURLClassLoader(ClassLoaderBootTest this$0, URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public DerbyURLClassLoader(ClassLoaderBootTest this$0, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
            super(urls, parent, factory);
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> cl = this.findLoadedClass(name);
            if (cl == null && !name.startsWith("org.apache.derby")) {
                cl = this.getParent().loadClass(name);
            }
            if (cl == null) {
                cl = this.findClass(name);
            }
            if (cl == null) {
                throw new ClassNotFoundException();
            }
            if (resolve) {
                this.resolveClass(cl);
            }
            return cl;
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            return this.loadClass(name, false);
        }
    }
}

