/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.management;

import java.sql.DatabaseMetaData;
import java.util.Hashtable;
import javax.management.ObjectName;
import junit.framework.Test;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.derbyTesting.functionTests.tests.management.MBeanTest;

public class JDBCMBeanTest
extends MBeanTest {
    public JDBCMBeanTest(String name) {
        super(name);
    }

    public static Test suite() {
        return MBeanTest.suite(JDBCMBeanTest.class, "JDBCMBeanTest");
    }

    private ObjectName getJdbcMBeanObjectName() throws Exception {
        Hashtable<String, String> keyProps = new Hashtable<String, String>();
        keyProps.put("type", "JDBC");
        return this.getDerbyMBeanName(keyProps);
    }

    public void testAttributeCompliantDriver() throws Exception {
        this.assertBooleanAttribute(true, this.getJdbcMBeanObjectName(), "CompliantDriver");
    }

    public void testAttributeDriverLevel() throws Exception {
        DatabaseMetaData dmd = this.getConnection().getMetaData();
        String JDBCVersion = dmd.getJDBCMajorVersion() + "." + dmd.getJDBCMinorVersion();
        String driverLevelString = (String)this.getAttribute(this.getJdbcMBeanObjectName(), "DriverLevel");
        JDBCMBeanTest.println("DatabaseMetaDataJDBCLevel = " + JDBCVersion);
        JDBCMBeanTest.println("MBean driverLevel  = " + driverLevelString);
        JDBCMBeanTest.assertEquals((String)("Unexpected driver level string: " + driverLevelString + " JDBCVersion: " + JDBCVersion), (int)-1, (int)driverLevelString.indexOf(63));
        JDBCMBeanTest.assertTrue((String)("Unexpected driver level string: " + driverLevelString + " JDBCVersion: " + JDBCVersion), (boolean)driverLevelString.matches("^J.*SE.* - JDBC .*" + JDBCVersion));
    }

    public void testAttributeMajorVersion() throws Exception {
        EmbeddedDriver d = new EmbeddedDriver();
        int expected = d.getMajorVersion();
        this.assertIntAttribute(expected, this.getJdbcMBeanObjectName(), "MajorVersion");
    }

    public void testAttributeMinorVersion() throws Exception {
        EmbeddedDriver d = new EmbeddedDriver();
        int expected = d.getMinorVersion();
        this.assertIntAttribute(expected, this.getJdbcMBeanObjectName(), "MinorVersion");
    }

    public void testOperationAcceptsURL() throws Exception {
        String opName = "acceptsURL";
        ObjectName objName = this.getJdbcMBeanObjectName();
        Object[] params = new Object[1];
        String[] signature = new String[]{"java.lang.String"};
        params[0] = "jdbc:derby:testDatabase";
        Boolean accepted = (Boolean)this.invokeOperation(objName, opName, params, signature);
        JDBCMBeanTest.assertTrue((String)("URL: " + String.valueOf(params[0])), (boolean)accepted);
        params[0] = "jdbc:derby:testDB;create=true;user=tester;password=mypass";
        accepted = (Boolean)this.invokeOperation(objName, opName, params, signature);
        JDBCMBeanTest.assertTrue((String)("URL: " + String.valueOf(params[0])), (boolean)accepted);
        params[0] = "jdbc:invalidProtocol:newDatabase";
        accepted = (Boolean)this.invokeOperation(objName, opName, params, signature);
        JDBCMBeanTest.assertFalse((String)("URL: " + String.valueOf(params[0])), (boolean)accepted);
    }
}

