/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;

public class Changes10_14
extends UpgradeChange {
    private static final String UPGRADE_REQUIRED = "XCL47";
    private static final String LANG_AI_OVERFLOW = "42Z24";

    public Changes10_14(String name) {
        super(name);
    }

    public static Test suite(int phase) {
        return new BaseTestSuite(Changes10_14.class, "Upgrade test for 10.14");
    }

    public void testAlterTableSetCycle() throws SQLException {
        Statement s = this.createStatement();
        boolean atLeast10_11 = this.oldAtLeast(10, 11);
        switch (this.getPhase()) {
            case 0: {
                s.execute("create table t_cycle_6904_1\n(a int generated always as identity (start with 2147483646), b int)");
                s.execute("create table t_cycle_6904_2\n(a int generated always as identity (start with 2147483646), b int)");
                break;
            }
            case 1: {
                if (atLeast10_11) {
                    s.execute("alter table t_cycle_6904_1 alter column a set no cycle");
                    s.execute("alter table t_cycle_6904_1 alter column a set cycle");
                    s.execute("insert into t_cycle_6904_1(b) values (1)");
                    s.execute("insert into t_cycle_6904_1(b) values (2)");
                    s.execute("insert into t_cycle_6904_1(b) values (3)");
                    JDBC.assertFullResultSet(s.executeQuery("select * from t_cycle_6904_1 order by b"), new String[][]{{"2147483646", "1"}, {"2147483647", "2"}, {"-2147483648", "3"}});
                    break;
                }
                this.assertCompileError(UPGRADE_REQUIRED, "alter table t_cycle_6904_1 alter column a set no cycle");
                this.assertCompileError(UPGRADE_REQUIRED, "alter table t_cycle_6904_1 alter column a set cycle");
                break;
            }
            case 2: {
                if (atLeast10_11) {
                    s.execute("insert into t_cycle_6904_1(b) values (4)");
                    JDBC.assertFullResultSet(s.executeQuery("select * from t_cycle_6904_1 order by b"), new String[][]{{"2147483646", "1"}, {"2147483647", "2"}, {"-2147483648", "3"}, {"-2147483647", "4"}});
                    break;
                }
                s.execute("insert into t_cycle_6904_1(b) values (1)");
                s.execute("insert into t_cycle_6904_1(b) values (2)");
                Changes10_14.assertStatementError(LANG_AI_OVERFLOW, s, "insert into t_cycle_6904_1(b) values (3)");
                break;
            }
            case 3: {
                s.execute("alter table t_cycle_6904_2 alter column a set no cycle");
                s.execute("alter table t_cycle_6904_2 alter column a set cycle");
                s.execute("insert into t_cycle_6904_2(b) values (1)");
                s.execute("insert into t_cycle_6904_2(b) values (2)");
                s.execute("insert into t_cycle_6904_2(b) values (3)");
                JDBC.assertFullResultSet(s.executeQuery("select * from t_cycle_6904_2 order by b"), new String[][]{{"2147483646", "1"}, {"2147483647", "2"}, {"-2147483648", "3"}});
            }
        }
    }
}

