/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import javax.net.ssl.SSLException;
import org.apache.derby.impl.drda.NetworkServerControlImpl;

final class ClientThread
extends Thread {
    NetworkServerControlImpl parent;
    ServerSocket serverSocket;
    private int timeSlice;

    ClientThread(NetworkServerControlImpl nsi, ServerSocket ss) {
        super(NetworkServerControlImpl.getUniqueThreadName("NetworkServerThread"));
        this.parent = nsi;
        this.serverSocket = ss;
        this.timeSlice = nsi.getTimeSlice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        clientSocket = null;
        block13: while (true) {
            try {
                while (true) lbl-1000:
                // 4 sources

                {
                    try {
                        try {
                            clientSocket = this.acceptClientWithRetry();
                            if (this.parent.getShutdown()) {
                                if (clientSocket != null) {
                                    clientSocket.close();
                                }
                                return;
                            }
                            clientSocket.setKeepAlive(this.parent.getKeepAlive());
                            if (this.timeSlice > 0) {
                                clientSocket.setSoTimeout(this.timeSlice);
                            }
                            this.parent.addSession(clientSocket);
                            continue block13;
                        }
                        catch (PrivilegedActionException e) {
                            throw e.getException();
                        }
                    }
                    catch (InterruptedException ie) {
                        if (this.parent.getShutdown()) {
                            clientSocket.close();
                            return;
                        }
                        this.parent.consoleExceptionPrintTrace(ie);
                        if (clientSocket == null) ** GOTO lbl-1000
                        clientSocket.close();
                    }
                    catch (SSLException ssle) {
                        this.parent.consoleExceptionPrintTrace(ssle);
                        this.parent.directShutdownInternal();
                        return;
                    }
                    catch (IOException ioe) {
                        if (clientSocket != null) {
                            clientSocket.close();
                        }
                        var3_8 = this.parent.getShutdownSync();
                        synchronized (var3_8) {
                            if (this.parent.getShutdown()) {
                                return;
                            }
                        }
                        this.parent.consoleExceptionPrintTrace(ioe);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.parent.consoleExceptionPrintTrace(e);
                try {
                    if (clientSocket == null) continue;
                    clientSocket.close();
                    continue;
                }
                catch (IOException closeioe) {
                    this.parent.consoleExceptionPrintTrace(closeioe);
                    continue;
                }
            }
            ** GOTO lbl-1000
            break;
        }
    }

    private Socket acceptClientWithRetry() {
        return AccessController.doPrivileged(new PrivilegedAction<Socket>(){

            @Override
            public Socket run() {
                for (int trycount = 1; trycount <= 3; ++trycount) {
                    try {
                        return ClientThread.this.serverSocket.accept();
                    }
                    catch (Exception acceptE) {
                        if (ClientThread.this.parent.getShutdown()) continue;
                        ClientThread.this.parent.consoleExceptionPrintTrace(acceptE);
                        if (trycount == 3) {
                            ClientThread.this.parent.directShutdownInternal();
                            continue;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ie) {
                            ClientThread.this.parent.consoleExceptionPrintTrace(ie);
                        }
                        continue;
                    }
                }
                return null;
            }
        });
    }
}

