/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.i18n;

import java.nio.charset.Charset;
import java.util.Properties;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.derbyTesting.functionTests.util.ScriptTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.TimeZoneTestSetup;

public final class LocalizedDisplayScriptTest
extends ScriptTestCase {
    private static final String ENCODING = "EUC_JP";

    public static void main(String[] args) {
        TestRunner.run((Test)LocalizedDisplayScriptTest.getSuite());
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("LocalizedDisplay");
        if (JDBC.vmSupportsJSR169()) {
            return suite;
        }
        if (!Charset.isSupported(ENCODING)) {
            LocalizedDisplayScriptTest.println("Skip LocalizedDisplayScriptTest because the encoding EUC_JP is not supported");
            return suite;
        }
        BaseTestSuite localizedEmbeddedTests = new BaseTestSuite("LocalizedDisplay:embedded");
        localizedEmbeddedTests.addTest(LocalizedDisplayScriptTest.getSuite());
        TestSetup embeddedrun = TestConfiguration.singleUseDatabaseDecorator((Test)localizedEmbeddedTests);
        suite.addTest((Test)embeddedrun);
        BaseTestSuite localizedTests = new BaseTestSuite("LocalizedDisplay:client");
        localizedTests.addTest(LocalizedDisplayScriptTest.getSuite());
        Test client = TestConfiguration.clientServerDecorator((Test)TestConfiguration.singleUseDatabaseDecorator((Test)localizedTests));
        suite.addTest(client);
        return suite;
    }

    private LocalizedDisplayScriptTest(String localizedTest) {
        super(localizedTest, ENCODING);
    }

    private static Test getSuite() {
        BaseTestSuite suite = new BaseTestSuite("localized Display");
        Properties uiProps = new Properties();
        uiProps.put("derby.ui.locale", "es_AR");
        uiProps.put("derby.ui.codeset", ENCODING);
        suite.addTest((Test)new TimeZoneTestSetup((Test)new SystemPropertyTestSetup((Test)new LocalizedDisplayScriptTest("LocalizedDisplay"), uiProps), "America/Los_Angeles"));
        return LocalizedDisplayScriptTest.getIJConfig((Test)suite);
    }
}

