/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import junit.framework.Test;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derbyTesting.functionTests.tests.lang.ConstraintCharacteristicsTest;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NewOptimizerOverridesTest
extends GeneratedColumnsHelper {
    private static final String WRONG_ROW_SOURCE_COUNT = "42ZCC";
    private static final String NOT_LEFT_DEEP = "42ZCD";
    private static final String MISSING_INDEX = "42X65";
    private static final String MISSING_FUNCTION = "42X94";
    private static final String MISSING_SCHEMA = "42Y07";
    private static final String UNSUPPORTED_PLAN_SHAPE = "42Y69";

    public NewOptimizerOverridesTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("NewOptimizerOverridesTest");
        suite.addTest(TestConfiguration.embeddedSuite(NewOptimizerOverridesTest.class));
        return new SecurityManagerSetup((Test)suite, "org/apache/derbyTesting/functionTests/tests/lang/resultSetReader.policy");
    }

    protected void setUp() throws Exception {
        super.setUp();
        Connection conn = this.getConnection();
        if (!this.routineExists(conn, "INTEGERLIST")) {
            this.goodStatement(conn, "create function integerList()\nreturns table( a int, b int, c int, d int )\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.RestrictedVTITest.integerList'\n");
        }
        if (!this.tableExists(conn, "V")) {
            this.goodStatement(conn, "create view v as select tablename from sys.systables");
        }
    }

    public void test_01_basicSyntax() throws Exception {
        Connection conn = this.getConnection();
        this.goodStatement(conn, "select tablename from v, sys.syscolumns\nwhere tablename = columnname\n");
        this.goodStatement(conn, "select columnname from sys.syscolumns, table( integerList() ) i\nwhere columnnumber = -i.a\n");
        this.goodStatement(conn, "select tablename\nfrom sys.systables t, sys.syscolumns c, sys.sysaliases a\nwhere tablename = columnname and columnname = alias\n");
        this.goodStatement(conn, "select columnname from sys.syscolumns, table( integerList() ) i\nwhere columnnumber = -i.a\n--derbyplan ( app.integerList() # sys.syscolumns_heap )\n");
        this.expectCompilationError(WRONG_ROW_SOURCE_COUNT, "select tablename from v, sys.syscolumns\nwhere tablename = columnname\n--derbyplan sys.syscolumns_heap\n");
        this.expectCompilationError(WRONG_ROW_SOURCE_COUNT, "select tablename from v, sys.syscolumns\nwhere tablename = columnname\n--derbyplan sys.syscolumns_heap\n");
        this.expectCompilationError(WRONG_ROW_SOURCE_COUNT, "select tablename from v, sys.syscolumns\nwhere tablename = columnname\n--derbyplan ( ( sys.syscolumns_heap # sys.syscolumns_heap ) * sys.syscolumns_heap )\n");
        this.expectCompilationError(MISSING_INDEX, "select tablename from v, sys.syscolumns\nwhere tablename = columnname\n--derbyplan ( A * C )\n");
        this.expectCompilationError(MISSING_FUNCTION, "select tablename from v, sys.syscolumns\nwhere tablename = columnname\n--derbyplan ( A() * C )\n");
        this.expectCompilationError(MISSING_SCHEMA, "select tablename from v, sys.syscolumns\nwhere tablename = columnname\n--derbyplan ( A.B * C )\n");
        this.expectCompilationError(MISSING_SCHEMA, "select tablename from v, sys.syscolumns\nwhere tablename = columnname\n--derbyplan ( A.B # C.D )\n");
        this.expectCompilationError(NOT_LEFT_DEEP, "select tablename\nfrom sys.systables t, sys.syscolumns c, sys.sysaliases a\nwhere tablename = columnname and columnname = alias\n--derbyplan ( A.B # ( C.D * E ) )\n");
        this.expectCompilationError("42X01", "select tablename\nfrom sys.systables t, sys.syscolumns c, sys.sysaliases a\nwhere tablename = columnname and columnname = alias\n--derbyplan blah blah blah ( ( A.B # C.D ) * E )\n");
        this.expectCompilationError("42X02", "select tablename\nfrom sys.systables t, sys.syscolumns c, sys.sysaliases a\nwhere tablename = columnname and columnname = alias\n--derbyplan ( ( A.B # C.D ) $ E )\n");
    }

    public void test_02_simpleSelects() throws Exception {
        Connection conn = this.getConnection();
        String select = "select columnname from sys.syscolumns, table( integerList() ) i\nwhere columnnumber = -i.a\n";
        NewOptimizerOverridesTest.assertPlanShape(conn, select, "( org.apache.derbyTesting.functionTests.tests.lang.RestrictedVTITest # SYSCOLUMNS )");
        NewOptimizerOverridesTest.assertPlanShape(conn, select + "\n--derbyplan ( sys.syscolumns_heap * app.integerList() )\n", "( SYSCOLUMNS * org.apache.derbyTesting.functionTests.tests.lang.RestrictedVTITest )");
        this.expectCompilationError(UNSUPPORTED_PLAN_SHAPE, select + "\n--derbyplan ( sys.syscolumns_heap # app.integerList() )");
        select = "select tablename from sys.systables t, sys.syscolumns c, sys.sysaliases a, sys.syssequences s\nwhere t.tablename = c.columnname and c.columnname = a.alias and a.alias = s.sequencename\n";
        NewOptimizerOverridesTest.assertPlanShape(conn, select + "--derbyplan ( ((SYS.SYSSEQUENCES_INDEX2 # SYS.SYSCOLUMNS_HEAP) # SYS.SYSALIASES_INDEX1) # SYS.SYSTABLES_INDEX1 )\n", "( ( ( SYSSEQUENCES_INDEX2 # SYSCOLUMNS ) # SYSALIASES_INDEX1 ) # SYSTABLES_INDEX1 )");
        this.expectCompilationError(UNSUPPORTED_PLAN_SHAPE, select + "\n--derbyplan ( ((SYS.SYSSEQUENCES_INDEX2 # SYS.SYSCOLUMNS_HEAP) # SYS.SYSCOLUMNS_HEAP) # SYS.SYSTABLES_INDEX1 )");
        NewOptimizerOverridesTest.assertPlanShape(conn, "select tablename from sys.systables t, sys.syscolumns c, sys.sysaliases a\nwhere tablename = columnname and tablename = alias\n--derbyplan ( ( sys.systables_index1 # sys.syscolumns_heap ) # sys.sysaliases_index1 )\nunion all\nselect columnname from sys.systables t, sys.syscolumns c, sys.syssequences s\nwhere tablename = columnname and tablename = sequencename\n--derbyplan ( ( sys.systables_index1 # sys.syssequences_index2 ) # sys.syscolumns_heap )\n", "( ( ( SYSTABLES_INDEX1 # SYSCOLUMNS ) # SYSALIASES_INDEX1 ) ) union ( ( ( SYSTABLES_INDEX1 # SYSSEQUENCES_INDEX2 ) # SYSCOLUMNS ) )");
        NewOptimizerOverridesTest.assertPlanShape(conn, "select tableid, c.referenceid\nfrom sys.systables, ( select referenceid from sys.syscolumns ) c\nwhere 1=2\n--derbyplan ( sys.systables_heap * sys.syscolumns_heap )\n", "( SYSTABLES * SYSCOLUMNS )");
        NewOptimizerOverridesTest.assertPlanShape(conn, "select tableid\nfrom sys.systables\nwhere tableid not in ( select referenceid from sys.syscolumns )\n--derbyplan ( sys.systables_heap # sys.syscolumns_index1 )\n", "( SYSTABLES # SYSCOLUMNS_INDEX1 )");
        this.expectCompilationError(UNSUPPORTED_PLAN_SHAPE, "select tableid\nfrom sys.systables\nwhere exists ( select referenceid from sys.syscolumns where 1= 2 )\n--derbyplan ( sys.syscolumns_index1 * sys.systables_heap )\n");
        NewOptimizerOverridesTest.assertPlanShape(conn, "select tableid\nfrom sys.systables\nwhere exists ( select referenceid from sys.syscolumns where 1= 2 )\n--derbyplan ( sys.systables_heap * sys.syscolumns_index1 )\n", "( SYSTABLES * SYSCOLUMNS_INDEX1 )");
        NewOptimizerOverridesTest.assertPlanShape(conn, "select tableid\nfrom sys.systables\nwhere tableid in ( select referenceid || 'foo' from sys.syscolumns )\n--derbyplan ( sys.systables_heap * sys.syscolumns_index1 )\n", "( SYSTABLES * SYSCOLUMNS_INDEX1 )");
        NewOptimizerOverridesTest.assertPlanShape(conn, "select tableid\nfrom sys.systables t\nwhere tableid =\n(\n    select referenceid from sys.syscolumns where referenceid = t.tableid and 1=2\n    --derbyplan sys.syscolumns_index1\n)\n--derbyplan sys.systables_heap\n", "SYSCOLUMNS_INDEX1\nSYSTABLES");
    }

    public void test_03_offsetFetch() throws Exception {
        Connection conn = this.getConnection();
        NewOptimizerOverridesTest.assertPlanShape(conn, "select tablename from sys.systables t, sys.syscolumns c, sys.sysaliases a, sys.syssequences s\nwhere t.tablename = c.columnname and c.columnname = a.alias and a.alias = s.sequencename\n--derbyplan ( ((SYS.SYSSEQUENCES_INDEX2 # SYS.SYSCOLUMNS_HEAP) # SYS.SYSALIASES_INDEX1) # SYS.SYSTABLES_INDEX1 )\nfetch first 1 rows only", "( ( ( SYSSEQUENCES_INDEX2 # SYSCOLUMNS ) # SYSALIASES_INDEX1 ) # SYSTABLES_INDEX1 )");
        NewOptimizerOverridesTest.assertPlanShape(conn, "select tableid\nfrom sys.systables t\nwhere tableid =\n(\n    select referenceid from sys.syscolumns where referenceid = t.tableid and 1=2\n    --derbyplan sys.syscolumns_index1\n    fetch first 1 rows only\n)\n--derbyplan sys.systables_heap\n", "SYSCOLUMNS_INDEX1\nSYSTABLES");
    }

    private boolean routineExists(Connection conn, String functionName) throws Exception {
        PreparedStatement ps = this.chattyPrepare(conn, "select count (*) from sys.sysaliases where alias = ?");
        ps.setString(1, functionName);
        java.sql.ResultSet rs = ps.executeQuery();
        rs.next();
        boolean retval = rs.getInt(1) > 0;
        rs.close();
        ps.close();
        return retval;
    }

    private boolean tableExists(Connection conn, String tableName) throws Exception {
        PreparedStatement ps = this.chattyPrepare(conn, "select count (*) from sys.systables where tablename = ?");
        ps.setString(1, tableName);
        java.sql.ResultSet rs = ps.executeQuery();
        rs.next();
        boolean retval = rs.getInt(1) > 0;
        rs.close();
        ps.close();
        return retval;
    }

    static void assertPlanShape(Connection conn, String query, String expectedPlanShape) throws Exception {
        java.sql.ResultSet rs = conn.prepareStatement(query).executeQuery();
        while (rs.next()) {
        }
        rs.close();
        String actualPlanShape = NewOptimizerOverridesTest.summarize(NewOptimizerOverridesTest.getLastQueryPlan(conn, rs));
        NewOptimizerOverridesTest.println("Expected plan shape = " + expectedPlanShape);
        NewOptimizerOverridesTest.println("Actual plan shape = " + actualPlanShape);
        NewOptimizerOverridesTest.assertEquals((String)expectedPlanShape, (String)actualPlanShape);
    }

    public static Document getLastQueryPlan(Connection conn, java.sql.ResultSet rs) throws Exception {
        LanguageConnectionContext lcc = ConstraintCharacteristicsTest.getLCC(conn);
        ResultSet derbyRS = lcc.getLastActivation().getResultSet();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = doc.createElement("planTrace");
        doc.appendChild(root);
        derbyRS.toXML(root, "top");
        return doc;
    }

    public static String summarize(Document doc) throws Exception {
        StringBuilder buffer = new StringBuilder();
        Element root = NewOptimizerOverridesTest.getFirstElement(doc.getDocumentElement(), "top");
        NewOptimizerOverridesTest.summarize(buffer, root);
        return buffer.toString();
    }

    private static void summarize(StringBuilder buffer, Element element) throws Exception {
        String type = element.getAttribute("type");
        if ("HashJoinResultSet".equals(type)) {
            NewOptimizerOverridesTest.summarizeJoin(buffer, element, "#");
        } else if ("NestedLoopJoinResultSet".equals(type)) {
            NewOptimizerOverridesTest.summarizeJoin(buffer, element, "*");
        } else if ("ProjectRestrictResultSet".equals(type)) {
            NewOptimizerOverridesTest.summarizeProjectRestrict(buffer, element);
        } else if ("RowCountResultSet".equals(type)) {
            NewOptimizerOverridesTest.summarizeProjectRestrict(buffer, NewOptimizerOverridesTest.getFirstElement(element, "source"));
        } else if ("UnionResultSet".equals(type)) {
            NewOptimizerOverridesTest.summarizeUnion(buffer, element);
        } else {
            String indexName = element.getAttribute("indexName");
            String tableName = element.getAttribute("tableName");
            String javaClassName = element.getAttribute("javaClassName");
            if (indexName.length() != 0) {
                buffer.append(indexName);
            } else if (tableName.length() != 0) {
                buffer.append(tableName);
            } else if (javaClassName.length() != 0) {
                buffer.append(javaClassName);
            } else {
                buffer.append(type);
            }
        }
    }

    private static void summarizeProjectRestrict(StringBuilder buffer, Element projectRestrict) throws Exception {
        Element subqueryArray = NewOptimizerOverridesTest.getFirstElement(projectRestrict, "array");
        if (subqueryArray != null) {
            NewOptimizerOverridesTest.summarizeSubqueries(buffer, subqueryArray);
        }
        NewOptimizerOverridesTest.summarize(buffer, NewOptimizerOverridesTest.getFirstElement(projectRestrict, "source"));
    }

    private static void summarizeSubqueries(StringBuilder buffer, Element subqueryArray) throws Exception {
        NodeList children = subqueryArray.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"cell".equals(child.getNodeName())) continue;
            Element source = NewOptimizerOverridesTest.getFirstElement((Element)child, "source");
            NewOptimizerOverridesTest.summarize(buffer, source);
            buffer.append("\n");
        }
    }

    private static void summarizeJoin(StringBuilder buffer, Element element, String joinSymbol) throws Exception {
        buffer.append("( ");
        NewOptimizerOverridesTest.summarize(buffer, NewOptimizerOverridesTest.getFirstElement(element, "leftResultSet"));
        buffer.append(" " + joinSymbol + " ");
        NewOptimizerOverridesTest.summarize(buffer, NewOptimizerOverridesTest.getFirstElement(element, "rightResultSet"));
        buffer.append(" )");
    }

    private static void summarizeUnion(StringBuilder buffer, Element union) throws Exception {
        NodeList list = union.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Element child = (Element)list.item(i);
            if (i > 0) {
                buffer.append(" union ");
            }
            buffer.append("( ");
            NewOptimizerOverridesTest.summarize(buffer, child);
            buffer.append(" )");
        }
    }

    private static Element getFirstElement(Element parent, String tag) throws Exception {
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (!tag.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        return null;
    }

    static String printDocument(Document doc) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(source, result);
        return sw.toString();
    }
}

