/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class InternationalConnectTest
extends BaseJDBCTestCase {
    private ArrayList<String> databasesForCleanup = new ArrayList();

    public InternationalConnectTest(String name) {
        super(name);
    }

    public void testBoundaries() throws SQLException, UnsupportedEncodingException {
        if (InternationalConnectTest.usingEmbedded()) {
            return;
        }
        String dbUrl1024bytes = "memory:/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa;create=true";
        String dbUrl1025bytes = "memory:/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/dir1234567890/aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa;create=true";
        String url = TestConfiguration.getCurrent().getJDBCUrl(dbUrl1024bytes);
        this.loadDriver(url);
        Connection conn = DriverManager.getConnection(url);
        conn.close();
        url = TestConfiguration.getCurrent().getJDBCUrl(dbUrl1025bytes);
        try {
            conn = DriverManager.getConnection(url);
            InternationalConnectTest.assertTrue((String)"Used more characters than possible in database name", (boolean)false);
        }
        catch (SQLException e) {
            InternationalConnectTest.assertSQLState("08001", e);
        }
    }

    private void loadDriver(String url) throws SQLException {
        try {
            DriverManager.getDriver(url);
        }
        catch (SQLException e) {
            InternationalConnectTest.assertSQLState("Unexpected SQLState from getDriver().", "08001", e);
            InternationalConnectTest.assertEquals((String)"Unexpected exception message from getDriver(), ", (String)"No suitable driver", (String)e.getMessage());
            String driverClass = this.getTestConfiguration().getJDBCClient().getJDBCDriverName();
            InternationalConnectTest.println("Loading JDBC driver " + driverClass);
            try {
                Class<?> clazz = Class.forName(driverClass);
                clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException cnfe) {
                throw new SQLException("Failed to load JDBC driver '" + driverClass + "', ClassNotFoundException: " + cnfe.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new SQLException("Failed to load JDBC driver '" + driverClass + "', IllegalAccessException: " + iae.getMessage());
            }
            catch (InstantiationException ie) {
                throw new SQLException("Failed to load JDBC driver '" + driverClass + "', InstantiationException: " + ie.getMessage());
            }
            catch (NoSuchMethodException ie) {
                throw new SQLException("Failed to load JDBC driver '" + driverClass + "', InstantiationException: " + ie.getMessage());
            }
            catch (InvocationTargetException ie) {
                throw new SQLException("Failed to load JDBC driver '" + driverClass + "', InstantiationException: " + ie.getMessage());
            }
        }
    }

    public void testDriverManagerConnect() throws SQLException {
        this.getConnection();
        Connection conn = null;
        String url = null;
        url = TestConfiguration.getCurrent().getJDBCUrl("\u4e10;create=true");
        conn = DriverManager.getConnection(url);
        conn.close();
        url = TestConfiguration.getCurrent().getJDBCUrl("\u4e10;user=\u4e10");
        conn = DriverManager.getConnection(url);
        conn.close();
        url = TestConfiguration.getCurrent().getJDBCUrl("\u4e10");
        conn = DriverManager.getConnection(url, "\u4e10", "pass");
        conn.close();
        url = TestConfiguration.getCurrent().getJDBCUrl("\u4e10;user=user;password=\u4e10");
        conn = DriverManager.getConnection(url);
        conn.close();
        url = TestConfiguration.getCurrent().getJDBCUrl("\u4e10");
        conn = DriverManager.getConnection(url, "\u4e10", "\u4e10");
        conn.close();
        this.databasesForCleanup.add("\u4e10");
    }

    public void testXADSConnect() throws SQLException {
        XADataSource ds = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(ds, "databaseName", "\u4e10");
        J2EEDataSource.setBeanProperty(ds, "createDatabase", "create");
        XAConnection xaconn = ds.getXAConnection();
        Connection conn = xaconn.getConnection();
        conn.close();
        xaconn.close();
        J2EEDataSource.setBeanProperty(ds, "user", "\u4e10");
        xaconn = ds.getXAConnection();
        conn = xaconn.getConnection();
        conn.close();
        xaconn.close();
        J2EEDataSource.setBeanProperty(ds, "password", "\u4e10");
        xaconn = ds.getXAConnection();
        conn = xaconn.getConnection();
        conn.close();
        xaconn.close();
        this.databasesForCleanup.add("\u4e10");
    }

    public void testCPDSConnect() throws SQLException {
        ConnectionPoolDataSource ds = J2EEDataSource.getConnectionPoolDataSource();
        J2EEDataSource.setBeanProperty(ds, "databaseName", "\u4e10");
        J2EEDataSource.setBeanProperty(ds, "createDatabase", "create");
        PooledConnection poolConn = ds.getPooledConnection();
        Connection conn = poolConn.getConnection();
        conn.close();
        poolConn.close();
        J2EEDataSource.setBeanProperty(ds, "user", "\u4e10");
        poolConn = ds.getPooledConnection();
        conn = poolConn.getConnection();
        conn.close();
        poolConn.close();
        J2EEDataSource.setBeanProperty(ds, "password", "\u4e10");
        poolConn = ds.getPooledConnection();
        conn = poolConn.getConnection();
        conn.close();
        poolConn.close();
        this.databasesForCleanup.add("\u4e10");
    }

    public void testFailureOnNonExistentDatabase() throws SQLException {
        String url = TestConfiguration.getCurrent().getJDBCUrl("abcdefghijklmnopq\u00e5");
        try {
            DriverManager.getConnection(url);
            InternationalConnectTest.fail((String)(url + " should not exist"));
        }
        catch (SQLException sqle) {
            String expected = InternationalConnectTest.usingEmbedded() ? "XJ004" : "08004";
            InternationalConnectTest.assertSQLState(expected, sqle);
        }
    }

    @Override
    public void tearDown() throws Exception {
        for (int i = 0; i < this.databasesForCleanup.size(); ++i) {
            String shutdownUrl = TestConfiguration.getCurrent().getJDBCUrl(this.databasesForCleanup.get(i) + ";shutdown=true");
            try {
                DriverManager.getConnection(shutdownUrl);
                InternationalConnectTest.fail((String)"Database didn't shut down");
            }
            catch (SQLException se) {
                InternationalConnectTest.assertSQLState("08006", se);
            }
            InternationalConnectTest.removeDirectory(InternationalConnectTest.getSystemProperty("derby.system.home") + File.separator + this.databasesForCleanup.get(i));
        }
        this.databasesForCleanup = null;
        super.tearDown();
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(InternationalConnectTest.class);
    }
}

