/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PhysicalPageOperation;
import org.apache.derby.shared.common.sanity.SanityManager;

public class CopyRowsOperation
extends PhysicalPageOperation {
    protected int num_rows;
    protected int destSlot;
    protected int[] recordIds;
    protected int[] reservedSpace;
    protected transient ByteArray preparedLog;

    CopyRowsOperation(RawTransaction t, BasePage destPage, BasePage srcPage, int destSlot, int num_rows, int srcSlot, int[] recordIds) throws StandardException {
        super(destPage);
        this.num_rows = num_rows;
        this.destSlot = destSlot;
        this.recordIds = recordIds;
        try {
            this.reservedSpace = new int[num_rows];
            for (int i = 0; i < num_rows; ++i) {
                this.reservedSpace[i] = srcPage.getReservedCount(i + srcSlot);
            }
            this.writeOptionalDataToBuffer(t, srcPage, srcSlot);
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDA4.S", ioe, new Object[0]);
        }
    }

    public CopyRowsOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        CompressedNumber.writeInt(out, this.num_rows);
        CompressedNumber.writeInt(out, this.destSlot);
        for (int i = 0; i < this.num_rows; ++i) {
            CompressedNumber.writeInt(out, this.recordIds[i]);
            CompressedNumber.writeInt(out, this.reservedSpace[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.num_rows = CompressedNumber.readInt(in);
        this.destSlot = CompressedNumber.readInt(in);
        this.recordIds = new int[this.num_rows];
        this.reservedSpace = new int[this.num_rows];
        for (int i = 0; i < this.num_rows; ++i) {
            this.recordIds[i] = CompressedNumber.readInt(in);
            this.reservedSpace[i] = CompressedNumber.readInt(in);
        }
    }

    @Override
    public int getTypeFormatId() {
        return 210;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        for (int i = 0; i < this.num_rows; ++i) {
            this.page.storeRecord(instant, this.destSlot + i, true, in);
            if (this.reservedSpace[i] <= 0) continue;
            this.page.reserveSpaceForSlot(instant, this.destSlot + i, this.reservedSpace[i]);
        }
    }

    @Override
    public void undoMe(Transaction xact, BasePage undoPage, LogInstant CLRInstant, LimitObjectInput in) throws StandardException, IOException {
        for (int i = this.num_rows - 1; i >= 0; --i) {
            int slot = undoPage.findRecordById(this.recordIds[i], i);
            undoPage.purgeRecord(CLRInstant, slot, this.recordIds[i]);
        }
        undoPage.setAuxObject(null);
    }

    @Override
    public void restoreMe(Transaction xact, BasePage undoPage, LogInstant CLRInstant, LimitObjectInput in) throws StandardException, IOException {
        this.undoMe(xact, undoPage, CLRInstant, in);
    }

    @Override
    public ByteArray getPreparedLog() {
        return this.preparedLog;
    }

    private void writeOptionalDataToBuffer(RawTransaction t, BasePage srcPage, int srcSlot) throws StandardException, IOException {
        SanityManager.ASSERT(this.page != null);
        SanityManager.ASSERT(srcPage != null);
        DynamicByteArrayOutputStream logBuffer = t.getLogBuffer();
        int optionalDataStart = logBuffer.getPosition();
        SanityManager.ASSERT(optionalDataStart == 0, "Buffer for writing the optional data should start at position 0");
        int[] spaceNeeded = new int[this.num_rows];
        int startPosition = logBuffer.getPosition();
        for (int i = 0; i < this.num_rows; ++i) {
            srcPage.logRecord(i + srcSlot, 0, this.recordIds[i], null, logBuffer, null);
            spaceNeeded[i] = logBuffer.getPosition() - startPosition;
            startPosition = logBuffer.getPosition();
            int n = i;
            spaceNeeded[n] = spaceNeeded[n] + this.reservedSpace[i];
        }
        if (!this.page.spaceForCopy(this.num_rows, spaceNeeded)) {
            throw StandardException.newException("XSDA3.S", new Object[0]);
        }
        int optionalDataLength = logBuffer.getPosition() - optionalDataStart;
        if (optionalDataLength != logBuffer.getUsed()) {
            SanityManager.THROWASSERT("wrong optional data length, optionalDataLength = " + optionalDataLength + ", logBuffer.getUsed() = " + logBuffer.getUsed());
        }
        logBuffer.setPosition(optionalDataStart);
        this.preparedLog = new ByteArray(logBuffer.getByteArray(), optionalDataStart, optionalDataLength);
    }

    @Override
    public String toString() {
        String str = super.toString() + "CopyRows : " + this.num_rows + " to slots starting at " + this.destSlot;
        for (int i = 0; i < this.num_rows; ++i) {
            str = str + " (recordId=" + this.recordIds[i] + ")";
        }
        return str;
    }
}

