/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.btree.index;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.LogicalUndoable;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.btree.ControlRow;
import org.apache.derby.impl.store.access.btree.OpenBTree;
import org.apache.derby.impl.store.access.btree.SearchParameters;
import org.apache.derby.impl.store.access.btree.index.B2I;
import org.apache.derby.shared.common.sanity.SanityManager;

public class B2IUndo
implements LogicalUndo,
Formatable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page findUndo(Transaction rawtran, LogicalUndoable pageOp, LimitObjectInput in) throws StandardException, IOException {
        ControlRow root = null;
        ControlRow control_row = null;
        Object[] logged_index_row_template = null;
        Object[] template = null;
        Page ret_page = null;
        ContainerHandle container = pageOp.getContainer();
        RecordHandle rechandle = pageOp.getRecordHandle();
        boolean ok_exit = false;
        int compare_result = 1;
        B2I btree = null;
        try {
            root = ControlRow.get(container, 1L);
            SanityManager.ASSERT(root.getPage().isLatched());
            btree = (B2I)root.getConglom(470);
            SanityManager.ASSERT(btree instanceof B2I);
            logged_index_row_template = btree.createTemplate(rawtran);
            template = btree.createTemplate(rawtran);
        }
        finally {
            if (root != null) {
                root.release();
            }
        }
        pageOp.restoreLoggedRow(logged_index_row_template, in);
        ok_exit = false;
        try {
            OpenBTree open_btree = new OpenBTree();
            open_btree.init(null, null, pageOp.getContainer(), rawtran, false, 4, 5, null, btree, null, null);
            control_row = ControlRow.get(open_btree, rechandle.getPageNumber());
            compare_result = 1;
            if (control_row.getPage().recordExists(rechandle, true)) {
                SanityManager.ASSERT(control_row.getPage().fetchNumFields(rechandle) == logged_index_row_template.length);
                RecordHandle ret_rechandle = control_row.getPage().fetchFromSlot(null, control_row.getPage().getSlotNumber(rechandle), template, null, true);
                compare_result = ControlRow.compareIndexRowToKey((DataValueDescriptor[])template, (DataValueDescriptor[])logged_index_row_template, logged_index_row_template.length, 1, open_btree.getColumnSortOrderInfo());
            }
            if (compare_result == 0) {
                ret_page = control_row.getPage();
            } else {
                SearchParameters sp = new SearchParameters((DataValueDescriptor[])logged_index_row_template, 1, (DataValueDescriptor[])template, open_btree, false);
                control_row.release();
                control_row = null;
                control_row = ControlRow.get(open_btree, 1L).search(sp);
                if (!sp.resultExact) {
                    SanityManager.THROWASSERT("B2IUndo - could not find key being searched for:;key = " + RowUtil.toString(logged_index_row_template) + ";sp = " + sp + "control_row = " + control_row + "control_row.debugPage() = " + control_row.debugPage(open_btree) + "control_row.getPage() = " + control_row.getPage());
                    throw StandardException.newException("XSCB5.S", new Object[0]);
                }
                RecordHandle rh = control_row.getPage().fetchFromSlot(null, sp.resultSlot, new DataValueDescriptor[0], null, true);
                pageOp.resetRecordHandle(rh);
                ret_page = control_row.getPage();
            }
            ok_exit = true;
        }
        finally {
            if (!ok_exit && control_row != null) {
                control_row.release();
            }
        }
        return ret_page;
    }

    @Override
    public int getTypeFormatId() {
        return 95;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }
}

