/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.OptimizerPlan;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AllResultColumn;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.DistinctNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.GroupByNode;
import org.apache.derby.impl.sql.compile.HasCorrelatedCRsVisitor;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.JoinNode;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.OrderByNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowCountNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.SubqueryNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VerifyAggregateExpressionsVisitor;
import org.apache.derby.impl.sql.compile.WindowDefinitionNode;
import org.apache.derby.impl.sql.compile.WindowFunctionNode;
import org.apache.derby.impl.sql.compile.WindowList;
import org.apache.derby.impl.sql.compile.WindowReferenceNode;
import org.apache.derby.impl.sql.compile.WindowResultSetNode;
import org.apache.derby.shared.common.sanity.SanityManager;

class SelectNode
extends ResultSetNode {
    FromList fromList;
    FromTable targetTable;
    private List<AggregateNode> selectAggregates;
    private List<AggregateNode> whereAggregates;
    private List<AggregateNode> havingAggregates;
    ValueNode whereClause;
    ValueNode originalWhereClause;
    GroupByList groupByList;
    WindowList windows;
    OptimizerPlan overridingPlan;
    List<WindowFunctionNode> windowFuncCalls;
    private boolean wasGroupBy;
    boolean orderByQuery;
    ResultSetNode.QueryExpressionClauses qec = new ResultSetNode.QueryExpressionClauses();
    PredicateList wherePredicates;
    SubqueryList selectSubquerys;
    SubqueryList whereSubquerys;
    SubqueryList havingSubquerys;
    private boolean bindTargetListOnly;
    private boolean isDistinct;
    private boolean orderByAndDistinctMerged;
    boolean originalWhereClauseHadSubqueries;
    private FromList preJoinFL;
    ValueNode havingClause;
    private int nestingLevel;

    SelectNode(ResultColumnList selectList, FromList fromList, ValueNode whereClause, GroupByList groupByList, ValueNode havingClause, WindowList windowDefinitionList, OptimizerPlan overridingPlan, ContextManager cm) throws StandardException {
        super(cm);
        this.setResultColumns(selectList);
        if (this.getResultColumns() != null) {
            this.getResultColumns().markInitialSize();
        }
        this.fromList = fromList;
        this.whereClause = whereClause;
        this.originalWhereClause = whereClause;
        this.groupByList = groupByList;
        this.havingClause = havingClause;
        this.windows = windowDefinitionList;
        this.overridingPlan = overridingPlan;
        this.bindTargetListOnly = false;
        this.originalWhereClauseHadSubqueries = false;
        if (this.whereClause != null) {
            CollectNodesVisitor<SubqueryNode> cnv = new CollectNodesVisitor<SubqueryNode>(SubqueryNode.class, SubqueryNode.class);
            this.whereClause.accept(cnv);
            if (!cnv.getList().isEmpty()) {
                this.originalWhereClauseHadSubqueries = true;
            }
        }
        if (this.getResultColumns() != null) {
            CollectNodesVisitor<WindowFunctionNode> cnvw = new CollectNodesVisitor<WindowFunctionNode>(WindowFunctionNode.class, SelectNode.class);
            this.getResultColumns().accept(cnvw);
            this.windowFuncCalls = cnvw.getList();
            for (int i = 0; i < this.windowFuncCalls.size(); ++i) {
                WindowFunctionNode wfn = this.windowFuncCalls.get(i);
                if (wfn.getWindow() instanceof WindowDefinitionNode) {
                    this.windows = this.addInlinedWindowDefinition(this.windows, wfn);
                    continue;
                }
                SanityManager.ASSERT(wfn.getWindow() instanceof WindowReferenceNode);
            }
        }
    }

    private WindowList addInlinedWindowDefinition(WindowList wl, WindowFunctionNode wfn) {
        WindowDefinitionNode equiv;
        WindowDefinitionNode wdn = (WindowDefinitionNode)wfn.getWindow();
        if (wl == null) {
            wl = new WindowList(this.getContextManager());
        }
        if ((equiv = wdn.findEquivalentWindow(wl)) != null) {
            wfn.setWindow(equiv);
        } else {
            wl.addWindow((WindowDefinitionNode)wfn.getWindow());
        }
        return wl;
    }

    @Override
    public String toString() {
        return "isDistinct: " + this.isDistinct + "\n" + super.toString();
    }

    String statementToString() {
        return "SELECT";
    }

    void makeDistinct() {
        this.isDistinct = true;
    }

    void clearDistinct() {
        this.isDistinct = false;
    }

    boolean hasDistinct() {
        return this.isDistinct;
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.selectSubquerys != null) {
            this.printLabel(depth, "selectSubquerys: ");
            this.selectSubquerys.treePrint(depth + 1);
        }
        this.printLabel(depth, "fromList: ");
        if (this.fromList != null) {
            this.fromList.treePrint(depth + 1);
        }
        if (this.whereClause != null) {
            this.printLabel(depth, "whereClause: ");
            this.whereClause.treePrint(depth + 1);
        }
        if (this.wherePredicates != null && this.wherePredicates.size() > 0) {
            this.printLabel(depth, "wherePredicates: ");
            this.wherePredicates.treePrint(depth + 1);
        }
        if (this.whereSubquerys != null) {
            this.printLabel(depth, "whereSubquerys: ");
            this.whereSubquerys.treePrint(depth + 1);
        }
        if (this.groupByList != null) {
            this.printLabel(depth, "groupByList:");
            this.groupByList.treePrint(depth + 1);
        }
        if (this.havingClause != null) {
            this.printLabel(depth, "havingClause:");
            this.havingClause.treePrint(depth + 1);
        }
        this.printQueryExpressionSuffixClauses(depth, this.qec);
        if (this.preJoinFL != null) {
            this.printLabel(depth, "preJoinFL: ");
            this.preJoinFL.treePrint(depth + 1);
        }
        if (this.windows != null) {
            this.printLabel(depth, "windows: ");
            this.windows.treePrint(depth + 1);
        }
    }

    @Override
    FromList getFromList() {
        return this.fromList;
    }

    ColumnReference findColumnReferenceInResult(String colName) throws StandardException {
        if (this.fromList.size() != 1) {
            return null;
        }
        FromTable ft = (FromTable)this.fromList.elementAt(0);
        if (!(ft instanceof ProjectRestrictNode && ((ProjectRestrictNode)ft).getChildResult() instanceof FromBaseTable || ft instanceof FromBaseTable)) {
            return null;
        }
        for (ResultColumn rc : this.getResultColumns()) {
            if (!(rc.getExpression() instanceof ColumnReference)) {
                return null;
            }
            ColumnReference crNode = (ColumnReference)rc.getExpression();
            if (!crNode.getColumnName().equals(colName)) continue;
            return (ColumnReference)crNode.getClone();
        }
        return null;
    }

    ValueNode getWhereClause() {
        return this.whereClause;
    }

    PredicateList getWherePredicates() {
        return this.wherePredicates;
    }

    SubqueryList getSelectSubquerys() {
        return this.selectSubquerys;
    }

    SubqueryList getWhereSubquerys() {
        return this.whereSubquerys;
    }

    @Override
    ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        int index;
        int fromListSize = this.fromList.size();
        this.wherePredicates = new PredicateList(this.getContextManager());
        this.preJoinFL = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        this.nestingLevel = fromListParam.size() == 0 ? 0 : ((FromTable)fromListParam.elementAt(0)).getLevel() + 1;
        this.fromList.setLevel(this.nestingLevel);
        for (index = 0; index < fromListSize; ++index) {
            fromListParam.insertElementAt(this.fromList.elementAt(index), 0);
        }
        this.fromList.bindTables(dataDictionary, fromListParam);
        for (index = 0; index < fromListSize; ++index) {
            fromListParam.removeElementAt(0);
        }
        if (this.overridingPlan != null) {
            this.overridingPlan.bind(dataDictionary, this.getLanguageConnectionContext(), this.getCompilerContext());
        }
        return this;
    }

    @Override
    void bindExpressions(FromList fromListParam) throws StandardException {
        int index;
        boolean wasSkippingTypePrivileges = this.getCompilerContext().skipTypePrivileges(true);
        int fromListParamSize = fromListParam.size();
        int fromListSize = this.fromList.size();
        SanityManager.ASSERT(this.fromList != null && this.getResultColumns() != null, "Both fromList and resultColumns are expected to be non-null");
        for (int i = 0; i < this.qec.size(); ++i) {
            OrderByList obl = this.qec.getOrderByList(i);
            if (obl == null) continue;
            obl.pullUpOrderByColumns(this);
        }
        if (!this.bindTargetListOnly) {
            this.fromList.bindExpressions(fromListParam);
        }
        this.selectSubquerys = new SubqueryList(this.getContextManager());
        this.selectAggregates = new ArrayList<AggregateNode>();
        for (index = 0; index < fromListSize; ++index) {
            fromListParam.insertElementAt(this.fromList.elementAt(index), index);
        }
        fromListParam.setWindows(this.windows);
        this.getResultColumns().bindExpressions(fromListParam, this.selectSubquerys, this.selectAggregates);
        if (this.bindTargetListOnly) {
            for (index = 0; index < fromListSize; ++index) {
                fromListParam.removeElementAt(0);
            }
            return;
        }
        this.whereAggregates = new ArrayList<AggregateNode>();
        this.whereSubquerys = new SubqueryList(this.getContextManager());
        CompilerContext cc = this.getCompilerContext();
        if (this.whereClause != null) {
            cc.beginScope("whereScope");
            cc.pushCurrentPrivType(0);
            int previousReliability = this.orReliability(16384);
            this.whereClause = this.whereClause.bindExpression(fromListParam, this.whereSubquerys, this.whereAggregates);
            cc.setReliability(previousReliability);
            if (this.whereAggregates.size() > 0) {
                throw StandardException.newException("42903", new Object[0]);
            }
            if (this.whereClause.isParameterNode()) {
                throw StandardException.newException("42X19.S.2", new Object[0]);
            }
            this.whereClause = this.whereClause.checkIsBoolean();
            this.getCompilerContext().popCurrentPrivType();
            cc.endScope("whereScope");
            SelectNode.checkNoWindowFunctions(this.whereClause, "WHERE");
        }
        if (this.havingClause != null) {
            int previousReliability = this.orReliability(16384);
            this.havingAggregates = new ArrayList<AggregateNode>();
            this.havingSubquerys = new SubqueryList(this.getContextManager());
            this.havingClause.bindExpression(fromListParam, this.havingSubquerys, this.havingAggregates);
            this.havingClause = this.havingClause.checkIsBoolean();
            SelectNode.checkNoWindowFunctions(this.havingClause, "HAVING");
            cc.setReliability(previousReliability);
        }
        for (int index2 = 0; index2 < fromListSize; ++index2) {
            fromListParam.removeElementAt(0);
        }
        SanityManager.ASSERT(fromListParam.size() == fromListParamSize, "fromListParam.size() = " + fromListParam.size() + ", expected to be restored to " + fromListParamSize);
        SanityManager.ASSERT(this.fromList.size() == fromListSize, "fromList.size() = " + this.fromList.size() + ", expected to be restored to " + fromListSize);
        if (this.groupByList != null) {
            ArrayList<AggregateNode> groupByAggregates = new ArrayList<AggregateNode>(0);
            this.groupByList.bindGroupByColumns(this, groupByAggregates);
            SanityManager.ASSERT(groupByAggregates.isEmpty(), "Unexpected aggregate list generated by GROUP BY clause");
            SelectNode.checkNoWindowFunctions(this.groupByList, "GROUP BY");
        }
        if (this.groupByList != null || this.selectAggregates.size() > 0) {
            VerifyAggregateExpressionsVisitor visitor = new VerifyAggregateExpressionsVisitor(this.groupByList);
            this.getResultColumns().accept(visitor);
        }
        int numDistinctAggs = SelectNode.numDistinctAggregates(this.selectAggregates);
        if (this.groupByList == null && numDistinctAggs > 1) {
            throw StandardException.newException("42Z02", new Object[0]);
        }
        for (int i = 0; i < this.qec.size(); ++i) {
            OrderByList obl = this.qec.getOrderByList(i);
            if (obl != null) {
                obl.bindOrderByColumns(this);
            }
            SelectNode.bindOffsetFetch(this.qec.getOffset(i), this.qec.getFetchFirst(i));
        }
        this.getCompilerContext().skipTypePrivileges(wasSkippingTypePrivileges);
    }

    @Override
    void bindExpressionsWithTables(FromList fromListParam) throws StandardException {
        this.bindExpressions(fromListParam);
    }

    @Override
    void bindTargetExpressions(FromList fromListParam) throws StandardException {
        CollectNodesVisitor<FromSubquery> cnv = new CollectNodesVisitor<FromSubquery>(FromSubquery.class, FromSubquery.class);
        this.fromList.accept(cnv);
        this.bindTargetListOnly = cnv.getList().isEmpty();
        this.bindExpressions(fromListParam);
        this.bindTargetListOnly = false;
    }

    @Override
    void bindResultColumns(FromList fromListParam) throws StandardException {
        this.fromList.bindResultColumns(fromListParam);
        super.bindResultColumns(fromListParam);
        if (this.getResultColumns().size() > 1012) {
            throw StandardException.newException("54004", new Object[0]);
        }
        if (this.getResultColumns().size() == 0) {
            throw StandardException.newException("42X81", new Object[0]);
        }
    }

    @Override
    void bindResultColumns(TableDescriptor targetTableDescriptor, FromVTI targetVTI, ResultColumnList targetColumnList, DMLStatementNode statement, FromList fromListParam) throws StandardException {
        this.fromList.bindResultColumns(fromListParam);
        super.bindResultColumns(targetTableDescriptor, targetVTI, targetColumnList, statement, fromListParam);
    }

    void pushExpressionsIntoSelect(Predicate predicate) throws StandardException {
        this.wherePredicates.pullExpressions(this.getReferencedTableMap().size(), predicate.getAndNode());
        this.fromList.pushPredicates(this.wherePredicates);
    }

    @Override
    void verifySelectStarSubquery(FromList outerFromList, int subqueryType) throws StandardException {
        for (ResultColumn rc : this.getResultColumns()) {
            if (!(rc instanceof AllResultColumn)) continue;
            if (subqueryType != 15) {
                throw StandardException.newException("42X38", new Object[0]);
            }
            String fullTableName = ((AllResultColumn)rc).getFullTableName();
            if (fullTableName == null || this.fromList.getFromTableByName(fullTableName, null, true) != null || outerFromList.getFromTableByName(fullTableName, null, true) != null || this.fromList.getFromTableByName(fullTableName, null, false) != null || outerFromList.getFromTableByName(fullTableName, null, false) != null) continue;
            throw StandardException.newException("42X10", fullTableName);
        }
    }

    @Override
    FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        return this.fromList.getFromTableByName(name, schemaName, exactMatch);
    }

    @Override
    void rejectParameters() throws StandardException {
        super.rejectParameters();
        this.fromList.rejectParameters();
    }

    @Override
    public void pushQueryExpressionSuffix() {
        this.qec.push();
    }

    @Override
    void pushOrderByList(OrderByList orderByList) {
        this.qec.setOrderByList(orderByList);
        this.orderByQuery = true;
    }

    @Override
    void pushOffsetFetchFirst(ValueNode offset, ValueNode fetchFirst, boolean hasJDBClimitClause) {
        this.qec.setOffset(offset);
        this.qec.setFetchFirst(fetchFirst);
        this.qec.setHasJDBCLimitClause(hasJDBClimitClause);
    }

    @Override
    ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fl) throws StandardException {
        ResultSetNode newTop = this;
        this.whereClause = this.normExpressions(this.whereClause);
        this.havingClause = this.normExpressions(this.havingClause);
        boolean anyChange = this.fromList.LOJ_reorderable(numTables);
        if (anyChange) {
            FromList afromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
            this.bindExpressions(afromList);
            this.fromList.bindResultColumns(afromList);
        }
        this.fromList.preprocess(numTables, this.groupByList, this.whereClause);
        SanityManager.ASSERT(this.selectSubquerys != null, "selectSubquerys is expected to be non-null");
        this.getResultColumns().preprocess(numTables, this.fromList, this.whereSubquerys, this.wherePredicates);
        if (this.whereClause != null) {
            if (this.whereSubquerys != null) {
                this.whereSubquerys.markWhereSubqueries();
            }
            this.whereClause = this.whereClause.preprocess(numTables, this.fromList, this.whereSubquerys, this.wherePredicates);
        }
        if (this.groupByList != null) {
            this.groupByList.preprocess(numTables, this.fromList, this.whereSubquerys, this.wherePredicates);
        }
        if (this.havingClause != null) {
            this.havingSubquerys.markHavingSubqueries();
            this.havingClause = this.havingClause.preprocess(numTables, this.fromList, this.havingSubquerys, this.wherePredicates);
        }
        if (this.whereClause != null) {
            this.wherePredicates.pullExpressions(numTables, this.whereClause);
            this.whereClause = null;
        }
        this.fromList.flattenFromTables(this.getResultColumns(), this.wherePredicates, this.whereSubquerys, this.groupByList, this.havingClause);
        if (this.wherePredicates != null && this.wherePredicates.size() > 0 && this.fromList.size() > 0) {
            if (this.fromList.size() > 1) {
                this.performTransitiveClosure(numTables);
            }
            for (int i = 0; i < this.qec.size(); ++i) {
                OrderByList obl = this.qec.getOrderByList(i);
                if (obl == null) continue;
                obl.removeConstantColumns(this.wherePredicates);
                if (obl.size() != 0) continue;
                this.qec.setOrderByList(i, null);
                this.getResultColumns().removeOrderByColumns();
            }
        }
        if (this.groupByList != null && this.havingClause == null && this.selectAggregates.isEmpty() && this.whereAggregates.isEmpty()) {
            this.isDistinct = true;
            this.groupByList = null;
            this.wasGroupBy = true;
        }
        if (this.isDistinct && this.groupByList == null) {
            int distinctTable = this.getResultColumns().allTopCRsFromSameTable();
            if (distinctTable != -1 && this.fromList.returnsAtMostSingleRow(this.getResultColumns(), this.whereClause, this.wherePredicates, this.getDataDictionary())) {
                this.isDistinct = false;
            }
            for (int i = 0; i < this.qec.size(); ++i) {
                OrderByList obl = this.qec.getOrderByList(i);
                if (!this.isDistinct || obl == null || !obl.allAscending()) continue;
                if (obl.isInOrderPrefix(this.getResultColumns())) {
                    this.qec.setOrderByList(i, null);
                } else {
                    newTop = this.genProjectRestrictForReordering();
                    obl.resetToSourceRCs();
                    this.setResultColumns(obl.reorderRCL(this.getResultColumns()));
                    newTop.getResultColumns().removeOrderByColumns();
                    this.qec.setOrderByList(i, null);
                }
                this.orderByAndDistinctMerged = true;
            }
        }
        this.fromList.pushPredicates(this.wherePredicates);
        this.setReferencedTableMap(new JBitSet(numTables));
        int flSize = this.fromList.size();
        for (int index = 0; index < flSize; ++index) {
            this.getReferencedTableMap().or(((FromTable)this.fromList.elementAt(index)).getReferencedTableMap());
        }
        if (newTop != this) {
            newTop.setReferencedTableMap((JBitSet)this.getReferencedTableMap().clone());
        }
        if (this.qec.getOrderByList(0) != null) {
            CollectNodesVisitor<WindowFunctionNode> cnvw = new CollectNodesVisitor<WindowFunctionNode>(WindowFunctionNode.class);
            this.qec.getOrderByList(0).accept(cnvw);
            for (WindowFunctionNode wfn : cnvw.getList()) {
                this.windowFuncCalls.add(wfn);
                if (wfn.getWindow() instanceof WindowDefinitionNode) {
                    this.windows = this.addInlinedWindowDefinition(this.windows, wfn);
                    continue;
                }
                SanityManager.ASSERT(false, "a window reference, should be bound already");
            }
        }
        return newTop;
    }

    private void performTransitiveClosure(int numTables) throws StandardException {
        this.wherePredicates.joinClauseTransitiveClosure(numTables, this.fromList, this.getCompilerContext());
        this.wherePredicates.searchClauseTransitiveClosure(numTables, this.fromList.hashJoinSpecified());
    }

    private ValueNode normExpressions(ValueNode boolClause) throws StandardException {
        if (boolClause != null) {
            if (!(boolClause = boolClause.eliminateNots(false)).verifyEliminateNots()) {
                boolClause.treePrint();
                SanityManager.THROWASSERT("boolClause in invalid form: " + boolClause);
            }
            if (!((boolClause = boolClause.putAndsOnTop()) instanceof AndNode) || !boolClause.verifyPutAndsOnTop()) {
                boolClause.treePrint();
                SanityManager.THROWASSERT("boolClause in invalid form: " + boolClause);
            }
            if (!((boolClause = boolClause.changeToCNF(true)) instanceof AndNode) || !boolClause.verifyChangeToCNF()) {
                boolClause.treePrint();
                SanityManager.THROWASSERT("boolClause in invalid form: " + boolClause);
            }
        }
        return boolClause;
    }

    @Override
    ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        this.wherePredicates.addPredicate(predicate);
        return this;
    }

    @Override
    boolean flattenableInFromSubquery(FromList fromList) {
        if (this.isDistinct) {
            return false;
        }
        if (this.fromList.size() > 1) {
            return false;
        }
        if (this.selectSubquerys != null && this.selectSubquerys.size() > 0) {
            return false;
        }
        if (this.groupByList != null || this.havingClause != null) {
            return false;
        }
        if (!this.getResultColumns().isCloneable()) {
            return false;
        }
        if (this.selectAggregates != null && this.selectAggregates.size() > 0) {
            return false;
        }
        for (int i = 0; i < this.qec.size(); ++i) {
            if (this.qec.getOrderByList(i) != null && this.qec.getOrderByList(i).size() > 0) {
                return false;
            }
            if (this.qec.getOffset(i) == null && this.qec.getFetchFirst(i) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    ResultSetNode genProjectRestrict(int origFromListSize) throws StandardException {
        int i;
        boolean[] eliminateSort = new boolean[this.qec.size()];
        FromTable prnRSN = new ProjectRestrictNode((ResultSetNode)this.fromList.elementAt(0), this.getResultColumns(), this.whereClause, this.wherePredicates, this.selectSubquerys, this.whereSubquerys, null, this.getContextManager());
        if (this.selectAggregates != null && this.selectAggregates.size() > 0 || this.groupByList != null) {
            List<AggregateNode> aggs = this.selectAggregates;
            if (this.havingAggregates != null && !this.havingAggregates.isEmpty()) {
                this.havingAggregates.addAll(this.selectAggregates);
                aggs = this.havingAggregates;
            }
            GroupByNode gbn = new GroupByNode(prnRSN, this.groupByList, aggs, this.havingClause, this.havingSubquerys, this.nestingLevel, this.getContextManager());
            gbn.considerPostOptimizeOptimizations(this.originalWhereClause != null);
            gbn.assignCostEstimate(this.getOptimizer().getOptimizedCost());
            this.groupByList = null;
            prnRSN = gbn.getParent();
            for (i = 0; i < eliminateSort.length; ++i) {
                eliminateSort[i] = eliminateSort[i] || gbn.getIsInSortedOrder();
            }
        }
        if (this.windows != null) {
            if (this.windows.size() > 1) {
                throw StandardException.newException("42ZC1", new Object[0]);
            }
            WindowDefinitionNode wn = (WindowDefinitionNode)this.windows.elementAt(0);
            WindowResultSetNode wrsn = new WindowResultSetNode(prnRSN, wn, this.windowFuncCalls, this.nestingLevel, this.getContextManager());
            prnRSN = wrsn.getParent();
            wrsn.assignCostEstimate(this.getOptimizer().getOptimizedCost());
        }
        if (this.isDistinct) {
            this.getResultColumns().verifyAllOrderable();
            boolean distinctScanPossible = false;
            if (origFromListSize == 1 && !this.orderByAndDistinctMerged) {
                boolean simpleColumns = true;
                HashSet<BaseColumnNode> distinctColumns = new HashSet<BaseColumnNode>();
                int size = this.getResultColumns().size();
                for (int i2 = 1; i2 <= size; ++i2) {
                    BaseColumnNode bc = this.getResultColumns().getResultColumn(i2).getBaseColumnNode();
                    if (bc == null) {
                        simpleColumns = false;
                        break;
                    }
                    distinctColumns.add(bc);
                }
                if (simpleColumns && prnRSN.isPossibleDistinctScan(distinctColumns)) {
                    prnRSN.markForDistinctScan();
                    distinctScanPossible = true;
                }
            }
            if (!distinctScanPossible) {
                boolean inSortedOrder = this.isOrderedResult(this.getResultColumns(), prnRSN, !this.orderByAndDistinctMerged);
                prnRSN = new DistinctNode(prnRSN, inSortedOrder, null, this.getContextManager());
                prnRSN.setCostEstimate(this.getCostEstimate().cloneMe());
                for (i = 0; i < eliminateSort.length; ++i) {
                    eliminateSort[i] = eliminateSort[i] || inSortedOrder;
                }
            }
        }
        for (int i3 = 0; i3 < this.qec.size(); ++i3) {
            OrderByList obl = this.qec.getOrderByList(i3);
            if (obl != null) {
                int orderBySelect;
                if (obl.getSortNeeded()) {
                    prnRSN = new OrderByNode(prnRSN, obl, null, this.getContextManager());
                    prnRSN.setCostEstimate(this.getCostEstimate().cloneMe());
                }
                if ((orderBySelect = this.getResultColumns().getOrderBySelect()) > 0) {
                    ResultColumnList topList = prnRSN.getResultColumns();
                    ResultColumnList newSelectList = topList.copyListAndObjects();
                    prnRSN.setResultColumns(newSelectList);
                    topList.removeOrderByColumns();
                    topList.genVirtualColumnNodes(prnRSN, newSelectList);
                    prnRSN = new ProjectRestrictNode(prnRSN, topList, null, null, null, null, null, this.getContextManager());
                }
            }
            ValueNode offset = this.qec.getOffset(i3);
            ValueNode fetchFirst = this.qec.getFetchFirst(i3);
            if (offset == null && fetchFirst == null) continue;
            ResultColumnList topList = prnRSN.getResultColumns();
            ResultColumnList newSelectList = topList.copyListAndObjects();
            prnRSN.setResultColumns(newSelectList);
            topList.genVirtualColumnNodes(prnRSN, newSelectList);
            prnRSN = new RowCountNode(prnRSN, topList, offset, fetchFirst, this.qec.getHasJDBCLimitClause()[i3], this.getContextManager());
        }
        if (this.wasGroupBy && this.getResultColumns().numGeneratedColumnsForGroupBy() > 0 && this.windows == null) {
            ResultColumnList topList = prnRSN.getResultColumns();
            ResultColumnList newSelectList = topList.copyListAndObjects();
            prnRSN.setResultColumns(newSelectList);
            topList.removeGeneratedGroupingColumns();
            topList.genVirtualColumnNodes(prnRSN, newSelectList);
            prnRSN = new ProjectRestrictNode(prnRSN, topList, null, null, null, null, null, this.getContextManager());
        }
        for (int i4 = 0; i4 < this.qec.size(); ++i4) {
            OrderByList obl = this.qec.getOrderByList(i4);
            if ((obl == null || !obl.getSortNeeded()) && this.orderByQuery) {
                eliminateSort[i4] = true;
            }
            if (eliminateSort[i4]) {
                prnRSN.adjustForSortElimination(obl);
            }
            prnRSN.setCostEstimate(this.getCostEstimate().cloneMe());
        }
        return prnRSN;
    }

    private boolean isOrderedResult(ResultColumnList resultColumns, ResultSetNode newTopRSN, boolean permuteOrdering) throws StandardException {
        int numCRs = 0;
        for (ResultColumn rc : resultColumns) {
            if (rc.getExpression() instanceof ColumnReference) {
                ++numCRs;
                continue;
            }
            if (rc.getExpression() instanceof ConstantNode) continue;
            return false;
        }
        if (numCRs == 0) {
            return true;
        }
        ColumnReference[] crs = new ColumnReference[numCRs];
        int crsIndex = 0;
        for (ResultColumn rc : resultColumns) {
            if (!(rc.getExpression() instanceof ColumnReference)) continue;
            crs[crsIndex++] = (ColumnReference)rc.getExpression();
        }
        return newTopRSN.isOrderedOn(crs, permuteOrdering, null);
    }

    @Override
    ResultSetNode ensurePredicateList(int numTables) throws StandardException {
        return this;
    }

    @Override
    ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double outerRows) throws StandardException {
        int i;
        SanityManager.ASSERT(this.selectSubquerys != null, "selectSubquerys is expected to be non-null");
        for (i = 0; i < this.qec.size(); ++i) {
            OrderByList obl = this.qec.getOrderByList(i);
            if (obl == null || obl.size() <= 1) continue;
            obl.removeDupColumns();
        }
        if (this.wherePredicates != null) {
            for (i = this.wherePredicates.size() - 1; i >= 0; --i) {
                if (!((Predicate)this.wherePredicates.elementAt(i)).isScopedForPush()) continue;
                this.wherePredicates.removeOptPredicate(i);
            }
        }
        if (predicateList != null) {
            if (this.wherePredicates == null) {
                this.wherePredicates = new PredicateList(this.getContextManager());
            }
            int sz = predicateList.size();
            for (int i2 = sz - 1; i2 >= 0; --i2) {
                Predicate pred = (Predicate)predicateList.getOptPredicate(i2);
                if (!pred.isScopedToSourceResultSet()) continue;
                this.wherePredicates.addOptPredicate(pred);
                predicateList.removeOptPredicate(pred);
            }
        }
        Optimizer opt = this.getOptimizer(this.fromList, this.wherePredicates, dataDictionary, this.qec.getOrderByList(0), this.overridingPlan);
        opt.setOuterRows(outerRows);
        while (opt.getNextPermutation()) {
            while (opt.getNextDecoratedPermutation()) {
                opt.costPermutation();
            }
        }
        if (this.wherePredicates != null) {
            for (i = this.wherePredicates.size() - 1; i >= 0; --i) {
                Predicate pred = (Predicate)this.wherePredicates.getOptPredicate(i);
                if (!pred.isScopedForPush()) continue;
                predicateList.addOptPredicate(pred);
                this.wherePredicates.removeOptPredicate(pred);
            }
        }
        this.setCostEstimate(opt.getOptimizedCost());
        if (this.selectAggregates != null && this.selectAggregates.size() > 0) {
            this.getCostEstimate().setEstimatedRowCount((long)outerRows);
            this.getCostEstimate().setSingleScanRowCount(1.0);
        }
        this.selectSubquerys.optimize(dataDictionary, this.getCostEstimate().rowCount());
        if (this.whereSubquerys != null && this.whereSubquerys.size() > 0) {
            this.whereSubquerys.optimize(dataDictionary, this.getCostEstimate().rowCount());
        }
        if (this.havingSubquerys != null && this.havingSubquerys.size() > 0) {
            this.havingSubquerys.optimize(dataDictionary, this.getCostEstimate().rowCount());
        }
        if (this.optimizerTracingIsOn()) {
            this.getOptimizerTracer().traceEndQueryBlock();
        }
        return this;
    }

    private Optimizer getOptimizer(OptimizableList optList, OptimizablePredicateList predList, DataDictionary dataDictionary, RequiredRowOrdering requiredRowOrdering, OptimizerPlan overridingPlan) throws StandardException {
        if (this.getOptimizer() == null) {
            OptimizerFactory optimizerFactory = this.getLanguageConnectionContext().getOptimizerFactory();
            this.setOptimizer(optimizerFactory.getOptimizer(optList, predList, dataDictionary, requiredRowOrdering, this.getCompilerContext().getNumTables(), overridingPlan, this.getLanguageConnectionContext()));
        }
        this.getOptimizer().prepForNextRound();
        return this.getOptimizer();
    }

    @Override
    ResultSetNode modifyAccessPaths(PredicateList predList) throws StandardException {
        SanityManager.ASSERT(this.getOptimizer() != null, "SelectNode's optimizer not expected to be null when modifying access paths.");
        this.getOptimizerImpl().addScopedPredicatesToList(predList, this.getContextManager());
        return this.modifyAccessPaths();
    }

    @Override
    ResultSetNode modifyAccessPaths() throws StandardException {
        int origFromListSize = this.fromList.size();
        this.getOptimizer().modifyAccessPaths();
        this.setCostEstimate(this.getOptimizer().getFinalCost());
        if (this.wherePredicates != null) {
            for (int i = this.wherePredicates.size() - 1; i >= 0; --i) {
                Predicate pred = (Predicate)this.wherePredicates.getOptPredicate(i);
                if (!pred.isScopedForPush()) continue;
                SanityManager.THROWASSERT("Found scoped predicate " + pred.binaryRelOpColRefsToString() + " in WHERE list when no scoped predicates were expected.");
            }
        }
        this.selectSubquerys.modifyAccessPaths();
        if (this.whereSubquerys != null && this.whereSubquerys.size() > 0) {
            this.whereSubquerys.modifyAccessPaths();
        }
        if (this.havingSubquerys != null && this.havingSubquerys.size() > 0) {
            this.havingSubquerys.modifyAccessPaths();
        }
        this.preJoinFL.removeAllElements();
        this.preJoinFL.nondestructiveAppend(this.fromList);
        while (this.fromList.size() > 1) {
            ResultSetNode leftResultSet = (ResultSetNode)this.fromList.elementAt(0);
            ResultColumnList leftRCList = leftResultSet.getResultColumns();
            leftResultSet.setResultColumns(leftRCList.copyListAndObjects());
            leftRCList.genVirtualColumnNodes(leftResultSet, leftResultSet.getResultColumns());
            ResultSetNode rightResultSet = (ResultSetNode)this.fromList.elementAt(1);
            ResultColumnList rightRCList = rightResultSet.getResultColumns();
            rightResultSet.setResultColumns(rightRCList.copyListAndObjects());
            rightRCList.genVirtualColumnNodes(rightResultSet, rightResultSet.getResultColumns());
            rightRCList.adjustVirtualColumnIds(leftRCList.size());
            leftRCList.nondestructiveAppend(rightRCList);
            this.fromList.setElementAt(new JoinNode(leftResultSet, rightResultSet, null, null, leftRCList, null, this.fromList.properties, this.getContextManager()), 0);
            this.fromList.removeElementAt(1);
        }
        return this.genProjectRestrict(origFromListSize);
    }

    @Override
    CostEstimate getFinalCostEstimate() throws StandardException {
        return this.getOptimizer().getFinalCost();
    }

    @Override
    boolean isUpdatableCursor(DataDictionary dd) throws StandardException {
        if (this.isDistinct) {
            SanityManager.DEBUG("DumpUpdateCheck", "cursor select has distinct");
            return false;
        }
        if (this.selectAggregates == null || this.selectAggregates.size() > 0) {
            return false;
        }
        if (this.groupByList != null || this.havingClause != null) {
            return false;
        }
        SanityManager.ASSERT(this.fromList != null, "select must have from tables");
        if (this.fromList.size() != 1) {
            SanityManager.DEBUG("DumpUpdateCheck", "cursor select has more than one from table");
            return false;
        }
        this.targetTable = (FromTable)this.fromList.elementAt(0);
        if (this.targetTable instanceof FromVTI) {
            return ((FromVTI)this.targetTable).isUpdatableCursor();
        }
        if (!(this.targetTable instanceof FromBaseTable)) {
            SanityManager.DEBUG("DumpUpdateCheck", "cursor select has non base table as target table");
            return false;
        }
        if (!this.targetTable.columnsAreUpdatable()) {
            SanityManager.DEBUG("DumpUpdateCheck", "cursor select has no updatable result columns");
            return false;
        }
        TableDescriptor targetTableDescriptor = this.getTableDescriptor(((FromBaseTable)this.targetTable).getBaseTableName(), this.getSchemaDescriptor(((FromBaseTable)this.targetTable).getTableNameField().getSchemaName()));
        if (targetTableDescriptor.getTableType() == 1) {
            SanityManager.DEBUG("DumpUpdateCheck", "cursor select is on system table");
            return false;
        }
        if (targetTableDescriptor.getTableType() == 2) {
            SanityManager.DEBUG("DumpUpdateCheck", "cursor select is on view");
            return false;
        }
        if (this.getSelectSubquerys() != null && this.getSelectSubquerys().size() != 0) {
            SanityManager.DEBUG("DumpUpdateCheck", "cursor select has subquery in SELECT list");
            return false;
        }
        if (this.getWhereSubquerys() != null && this.getWhereSubquerys().size() != 0) {
            SanityManager.DEBUG("DumpUpdateCheck", "cursor select has subquery in WHERE clause");
            return false;
        }
        return true;
    }

    @Override
    FromTable getCursorTargetTable() {
        SanityManager.ASSERT(this.targetTable != null, "must call isUpdatableCursor() first, and must be updatable");
        return this.targetTable;
    }

    @Override
    boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        return this.fromList.referencesTarget(name, baseTable) || this.selectSubquerys != null && this.selectSubquerys.referencesTarget(name, baseTable) || this.whereSubquerys != null && this.whereSubquerys.referencesTarget(name, baseTable);
    }

    @Override
    boolean subqueryReferencesTarget(String name, boolean baseTable) throws StandardException {
        return this.selectSubquerys != null && this.selectSubquerys.referencesTarget(name, baseTable) || this.whereSubquerys != null && this.whereSubquerys.referencesTarget(name, baseTable);
    }

    @Override
    void bindUntypedNullsToResultColumns(ResultColumnList bindingRCL) throws StandardException {
        this.fromList.bindUntypedNullsToResultColumns(bindingRCL);
    }

    @Override
    void decrementLevel(int decrement) {
        this.fromList.decrementLevel(decrement);
        this.selectSubquerys.decrementLevel(decrement);
        this.whereSubquerys.decrementLevel(decrement);
        this.wherePredicates.decrementLevel(this.fromList, decrement);
    }

    boolean uniqueSubquery(boolean additionalEQ) throws StandardException {
        ColumnReference additionalCR = null;
        ResultColumn rc = (ResultColumn)this.getResultColumns().elementAt(0);
        if (additionalEQ && rc.getExpression() instanceof ColumnReference && (additionalCR = (ColumnReference)rc.getExpression()).getCorrelated()) {
            additionalCR = null;
        }
        return this.fromList.returnsAtMostSingleRow(additionalCR == null ? null : this.getResultColumns(), this.whereClause, this.wherePredicates, this.getDataDictionary());
    }

    @Override
    int updateTargetLockMode() {
        return this.fromList.updateTargetLockMode();
    }

    @Override
    boolean returnsAtMostOneRow() {
        return this.groupByList == null && this.selectAggregates != null && !this.selectAggregates.isEmpty();
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.fromList.referencesSessionSchema() || this.selectSubquerys != null && this.selectSubquerys.referencesSessionSchema() || this.whereSubquerys != null && this.whereSubquerys.referencesSessionSchema();
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.fromList != null) {
            this.fromList = (FromList)this.fromList.accept(v);
        }
        if (this.whereClause != null) {
            this.whereClause = (ValueNode)this.whereClause.accept(v);
        }
        if (this.wherePredicates != null) {
            this.wherePredicates = (PredicateList)this.wherePredicates.accept(v);
        }
        if (this.havingClause != null) {
            this.havingClause = (ValueNode)this.havingClause.accept(v);
        }
        if (!(v instanceof HasCorrelatedCRsVisitor)) {
            if (this.selectSubquerys != null) {
                this.selectSubquerys = (SubqueryList)this.selectSubquerys.accept(v);
            }
            if (this.whereSubquerys != null) {
                this.whereSubquerys = (SubqueryList)this.whereSubquerys.accept(v);
            }
            if (this.groupByList != null) {
                this.groupByList = (GroupByList)this.groupByList.accept(v);
            }
            for (int i = 0; i < this.qec.size(); ++i) {
                ValueNode fetchFirst;
                ValueNode offset;
                OrderByList obl = this.qec.getOrderByList(i);
                if (obl != null) {
                    this.qec.setOrderByList(i, (OrderByList)obl.accept(v));
                }
                if ((offset = this.qec.getOffset(i)) != null) {
                    this.qec.setOffset(i, (ValueNode)offset.accept(v));
                }
                if ((fetchFirst = this.qec.getFetchFirst(i)) == null) continue;
                this.qec.setFetchFirst(i, (ValueNode)fetchFirst.accept(v));
            }
            if (this.preJoinFL != null) {
                this.preJoinFL = (FromList)this.preJoinFL.accept(v);
            }
            if (this.windows != null) {
                this.windows = (WindowList)this.windows.accept(v);
            }
        }
    }

    boolean hasAggregatesInSelectList() {
        return !this.selectAggregates.isEmpty();
    }

    boolean hasWindows() {
        return this.windows != null;
    }

    static void checkNoWindowFunctions(QueryTreeNode clause, String clauseName) throws StandardException {
        HasNodeVisitor visitor = new HasNodeVisitor(WindowFunctionNode.class, SubqueryNode.class);
        clause.accept(visitor);
        if (visitor.hasNode()) {
            throw StandardException.newException("42ZC2", clauseName);
        }
    }

    @Override
    void replaceOrForbidDefaults(TableDescriptor ttd, ResultColumnList tcl, boolean allowDefaults) throws StandardException {
    }

    boolean hasOffsetFetchFirst() {
        return this.qec.hasOffsetFetchFirst();
    }
}

