/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.apache.derby.impl.io.BaseStorageFactory;
import org.apache.derby.impl.io.JarDBFile;
import org.apache.derby.io.StorageFile;

public class JarStorageFactory
extends BaseStorageFactory {
    ZipFile zipData;

    @Override
    StorageFile newPersistentFile(String path) {
        return new JarDBFile(this, path);
    }

    @Override
    StorageFile newPersistentFile(String directoryName, String fileName) {
        if (directoryName == null || directoryName.length() == 0) {
            return this.newPersistentFile(fileName);
        }
        return new JarDBFile(this, directoryName, fileName);
    }

    @Override
    StorageFile newPersistentFile(StorageFile directoryName, String fileName) {
        if (directoryName == null) {
            return this.newPersistentFile(fileName);
        }
        return new JarDBFile((JarDBFile)directoryName, fileName);
    }

    @Override
    void doInit() throws IOException {
        int offset;
        if (this.dataDirectory == null) {
            return;
        }
        for (offset = 0; offset < this.dataDirectory.length() && Character.isSpaceChar(this.dataDirectory.charAt(offset)); ++offset) {
        }
        int leftParen = -1;
        int rightParen = -1;
        if (offset < this.dataDirectory.length() && (leftParen = this.dataDirectory.indexOf(40, offset)) >= 0) {
            rightParen = this.dataDirectory.lastIndexOf(41);
        }
        File jarFile = null;
        if (rightParen > 0) {
            jarFile = this.getJarFile(this.dataDirectory.substring(leftParen + 1, rightParen));
            for (offset = rightParen + 1; offset < this.dataDirectory.length() && Character.isSpaceChar(this.dataDirectory.charAt(offset)); ++offset) {
            }
            this.dataDirectory = this.dataDirectory.substring(offset, this.dataDirectory.length());
        } else {
            jarFile = this.getJarFile(this.dataDirectory);
            this.dataDirectory = "";
        }
        this.zipData = new ZipFile(jarFile);
        this.canonicalName = "(" + jarFile.getCanonicalPath() + ")" + this.dataDirectory;
        this.separatedDataDirectory = this.dataDirectory + '/';
        this.createTempDir();
    }

    @Override
    public void shutdown() {
        if (this.zipData != null) {
            try {
                this.zipData.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.zipData = null;
        }
    }

    private File getJarFile(String name) {
        File jarFile = new File(name);
        if (this.home != null && !jarFile.isAbsolute()) {
            jarFile = new File(this.home, name);
        }
        return jarFile;
    }
}

