/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.vti.VTITemplate;

public class ContainedRoles
extends VTITemplate {
    RoleClosureIterator rci;
    String nextRole;
    boolean initialized;
    String role;
    boolean inverse;
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("ROLEID", 12, false, 128)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public ContainedRoles(String roleid, int inverse) throws SQLException {
        try {
            if (roleid != null) {
                this.role = IdUtil.parseSQLIdentifier(roleid);
            }
            this.inverse = inverse != 0;
        }
        catch (StandardException e) {
            throw PublicAPI.wrapStandardException(e);
        }
    }

    public ContainedRoles(String roleid) throws SQLException {
        this(roleid, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        try {
            if (!this.initialized) {
                this.initialized = true;
                LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
                DataDictionary dd = lcc.getDataDictionary();
                RoleGrantDescriptor rdDef = dd.getRoleDefinitionDescriptor(this.role);
                if (rdDef != null) {
                    lcc.beginNestedTransaction(true);
                    try {
                        int mode = dd.startReading(lcc);
                        try {
                            this.rci = dd.createRoleClosureIterator(lcc.getLastActivation().getTransactionController(), this.role, !this.inverse);
                        }
                        finally {
                            dd.doneReading(mode, lcc);
                        }
                    }
                    finally {
                        lcc.commitNestedTransaction();
                    }
                }
            }
            return this.rci != null && (this.nextRole = this.rci.next()) != null;
        }
        catch (StandardException e) {
            throw PublicAPI.wrapStandardException(e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return metadata;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.nextRole;
    }
}

