/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.unparsers.runtime1;

import java.io.Serializable;
import org.apache.daffodil.io.DirectOrBufferedDataOutputStream;
import org.apache.daffodil.io.processors.charset.BitsCharset;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.MaybeInt$;
import org.apache.daffodil.lib.util.MaybeJULong;
import org.apache.daffodil.runtime1.processors.CharsetEv;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.Evaluatable;
import org.apache.daffodil.runtime1.processors.TextTruncationType;
import org.apache.daffodil.runtime1.processors.UnparseTargetLengthInBitsEv;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import org.apache.daffodil.unparsers.runtime1.StringSpecifiedLengthUnparserTruncateBase;
import passera.unsigned.ULong$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class StringMaybeTruncateBitsUnparser
extends StringSpecifiedLengthUnparserTruncateBase {
    private final UnparseTargetLengthInBitsEv targetLengthInBitsEv;
    private final CharsetEv charsetEv;

    public StringMaybeTruncateBitsUnparser(UnparseTargetLengthInBitsEv targetLengthInBitsEv, TextTruncationType.Type stringTruncationType, ElementRuntimeData erd, CharsetEv charsetEv) {
        this.targetLengthInBitsEv = targetLengthInBitsEv;
        this.charsetEv = charsetEv;
        super(stringTruncationType, erd);
    }

    private ElementRuntimeData erd$accessor() {
        return super.erd();
    }

    @Override
    public Vector<Evaluatable<Object>> runtimeDependencies() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Evaluatable[]{this.targetLengthInBitsEv, this.charsetEv}));
    }

    private Tuple2<Object, Object> getLengthInBits(String str, UState state) {
        BitsCharset cs = (BitsCharset)this.charsetEv.evaluate(state);
        long mfw = cs.maybeFixedWidth();
        long sl = str.length();
        Tuple2 res = MaybeInt$.MODULE$.isDefined$extension(mfw) ? Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(sl * (long)MaybeInt$.MODULE$.get$extension(mfw))), (Object)BoxesRunTime.boxToLong((long)sl)) : (Tuple2)state.withByteArrayOutputStream().apply((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                DirectOrBufferedDataOutputStream dos = (DirectOrBufferedDataOutputStream)tuple2._2();
                long nChars = dos.putString(str, state);
                long nBits = ULong$.MODULE$.toLong$extension(dos.relBitPos0b());
                return new Tuple2.mcJJ.sp(nBits, nChars);
            }
            throw new MatchError((Object)tuple2);
        });
        return res;
    }

    @Override
    public void unparse(UState state) {
        String string;
        DirectOrBufferedDataOutputStream dos = state.getDataOutputStream();
        String valueString = this.contentString(state);
        MaybeJULong maybeTargetLengthInBits = (MaybeJULong)this.targetLengthInBitsEv.evaluate(state);
        if (!maybeTargetLengthInBits.isDefined()) {
            throw Assert$.MODULE$.abort("Invariant broken: maybeTargetLengthInBits.isDefined");
        }
        long targetLengthInBits = maybeTargetLengthInBits.get();
        Tuple2<Object, Object> tuple2 = this.getLengthInBits(valueString, state);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long nBits = tuple2._1$mcJ$sp();
        long nChars = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(nBits, nChars);
        long nBits2 = sp2._1$mcJ$sp();
        long nChars2 = sp2._2$mcJ$sp();
        long targetLengthDiff = nBits2 - targetLengthInBits;
        if (targetLengthDiff <= 0L) {
            string = valueString;
        } else {
            long nBitsToTrim = targetLengthDiff;
            BitsCharset dcs = this.erd$accessor().encInfo().getDFDLCharset(state);
            int minBitsPerChar = this.erd$accessor().encodingInfo().encodingMinimumCodePointWidthInBits(dcs);
            long nCharsToTrim = nBitsToTrim / (long)minBitsPerChar;
            if (nCharsToTrim > nChars2) {
                throw Assert$.MODULE$.abort("Invariant broken: nCharsToTrim.<=(nChars)");
            }
            String truncatedValue = this.truncateByJustification(state, valueString, nChars2 - (long)((int)nCharsToTrim));
            if (truncatedValue.length() > valueString.length()) {
                throw Assert$.MODULE$.abort("Invariant broken: truncatedValue.length().<=(valueString.length())");
            }
            string = truncatedValue;
        }
        String valueToWrite = string;
        long nCharsWritten = dos.putString(valueToWrite, state);
        if (nCharsWritten != (long)valueToWrite.length()) {
            throw Assert$.MODULE$.abort("Invariant broken: nCharsWritten.==(valueToWrite.length())");
        }
    }
}

