/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.transfer.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.WebServiceContext;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.ReferenceParametersType;
import org.apache.cxf.ws.transfer.Delete;
import org.apache.cxf.ws.transfer.DeleteResponse;
import org.apache.cxf.ws.transfer.Get;
import org.apache.cxf.ws.transfer.GetResponse;
import org.apache.cxf.ws.transfer.Put;
import org.apache.cxf.ws.transfer.PutResponse;
import org.apache.cxf.ws.transfer.Representation;
import org.apache.cxf.ws.transfer.dialect.Dialect;
import org.apache.cxf.ws.transfer.dialect.fragment.FragmentDialect;
import org.apache.cxf.ws.transfer.manager.ResourceManager;
import org.apache.cxf.ws.transfer.resource.Resource;
import org.apache.cxf.ws.transfer.shared.faults.UnknownDialect;
import org.apache.cxf.ws.transfer.validationtransformation.ResourceTypeIdentifier;
import org.apache.cxf.ws.transfer.validationtransformation.ValidAndTransformHelper;

public class ResourceLocal
implements Resource {
    @javax.annotation.Resource
    protected WebServiceContext context;
    protected ResourceManager manager;
    protected List<ResourceTypeIdentifier> resourceTypeIdentifiers;
    protected Map<String, Dialect> dialects = new HashMap<String, Dialect>();

    public ResourceLocal() {
        this.dialects.put("http://www.w3.org/2011/03/ws-fra", new FragmentDialect());
    }

    public ResourceManager getManager() {
        return this.manager;
    }

    public void setManager(ResourceManager manager) {
        this.manager = manager;
    }

    public List<ResourceTypeIdentifier> getResourceTypeIdentifiers() {
        if (this.resourceTypeIdentifiers == null) {
            this.resourceTypeIdentifiers = new ArrayList<ResourceTypeIdentifier>();
        }
        return this.resourceTypeIdentifiers;
    }

    public void setResourceTypeIdentifiers(List<ResourceTypeIdentifier> resourceTypeIdentifiers) {
        this.resourceTypeIdentifiers = resourceTypeIdentifiers;
    }

    public void registerDialect(String iri, Dialect dialect) {
        if (this.dialects.containsKey(iri)) {
            throw new IllegalArgumentException(String.format("IRI \"%s\" is already registered", iri));
        }
        this.dialects.put(iri, dialect);
    }

    public void unregisterDialect(String iri) {
        if (!this.dialects.containsKey(iri)) {
            throw new IllegalArgumentException(String.format("IRI \"%s\" is not registered", iri));
        }
        this.dialects.remove(iri);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public GetResponse get(Get body) {
        AddressingProperties addrProps = (AddressingProperties)((WrappedMessageContext)this.context.getMessageContext()).getWrappedMessage().getContextualProperty("javax.xml.ws.addressing.context.inbound");
        ReferenceParametersType refParams = addrProps.getToEndpointReference().getReferenceParameters();
        GetResponse response = new GetResponse();
        Representation representation = this.manager.get(refParams);
        if (body.getDialect() != null && !body.getDialect().isEmpty()) {
            if (!this.dialects.containsKey(body.getDialect())) throw new UnknownDialect();
            Dialect dialect = this.dialects.get(body.getDialect());
            response.getAny().add(dialect.processGet(body, representation));
            return response;
        } else {
            response.setRepresentation(representation);
        }
        return response;
    }

    @Override
    public DeleteResponse delete(Delete body) {
        AddressingProperties addrProps = (AddressingProperties)((WrappedMessageContext)this.context.getMessageContext()).getWrappedMessage().getContextualProperty("javax.xml.ws.addressing.context.inbound");
        ReferenceParametersType refParams = addrProps.getToEndpointReference().getReferenceParameters();
        boolean delete = true;
        if (body.getDialect() != null && !body.getDialect().isEmpty()) {
            if (this.dialects.containsKey(body.getDialect())) {
                Dialect dialect = this.dialects.get(body.getDialect());
                delete = dialect.processDelete(body, this.manager.get(refParams));
            } else {
                throw new UnknownDialect();
            }
        }
        if (delete) {
            this.manager.delete(refParams);
        }
        return new DeleteResponse();
    }

    @Override
    public PutResponse put(Put body) {
        AddressingProperties addrProps = (AddressingProperties)((WrappedMessageContext)this.context.getMessageContext()).getWrappedMessage().getContextualProperty("javax.xml.ws.addressing.context.inbound");
        ReferenceParametersType refParams = addrProps.getToEndpointReference().getReferenceParameters();
        Representation storedRepresentation = this.manager.get(refParams);
        Representation putRepresentation = body.getRepresentation();
        if (body.getDialect() != null && !body.getDialect().isEmpty()) {
            if (this.dialects.containsKey(body.getDialect())) {
                Dialect dialect = this.dialects.get(body.getDialect());
                putRepresentation = dialect.processPut(body, storedRepresentation);
            } else {
                throw new UnknownDialect();
            }
        }
        ValidAndTransformHelper.validationAndTransformation(this.resourceTypeIdentifiers, putRepresentation, storedRepresentation);
        this.manager.put(refParams, putRepresentation);
        PutResponse response = new PutResponse();
        response.setRepresentation(putRepresentation);
        return response;
    }
}

