/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;

public final class WildCard {
    public static final char VOWEL = 'V';
    public static final char CONSONANT = 'C';
    public static final char SAME_AS_PREV = 'S';
    public static final char DIGIT = 'D';
    public static final char LETTER = 'L';
    public static final char BEGIN = '^';
    public static final char END = '$';
    public static final char FS = '|';
    private static final HashSet<String> VOWEL_WILD_CARD_SET = new HashSet<String>(Arrays.asList("A", "E", "I", "O", "U"));
    private static final HashSet<String> CONSONANT_WILD_CARD_SET = new HashSet<String>(Arrays.asList("B", "C", "F", "G", "H", "J", "K", "M", "N", "P", "Q", "R", "T", "V", "W", "X", "Y", "Z"));
    private static final HashSet<String> WILD_CARD_SET = new HashSet<String>(Arrays.asList(new Character('V').toString(), new Character('C').toString(), new Character('S').toString(), new Character('D').toString(), new Character('^').toString(), new Character('$').toString()));
    private static final HashSet<String> VOWEL_SET = new HashSet<String>(Arrays.asList("a", "e", "i", "o", "u", "\u00e0", "\u00e1", "\u00e2", "\u00e3", "\u00e4", "\u00e5", "\u00e8", "\u00e9", "\u00ea", "\u00eb", "\u00ec", "\u00ed", "\u00ee", "\u00ef", "\u00f0", "\u00f2", "\u00f3", "\u00f4", "\u00f5", "\u00f6", "\u00f8", "\u00f9", "\u00fa", "\u00fb", "\u00fc"));
    private static final HashSet<String> CONSONANT_SET = new HashSet<String>(Arrays.asList("b", "c", "d", "f", "g", "h", "j", "k", "l", "m", "n", "p", "q", "r", "s", "t", "v", "w", "x", "y", "z", "\u00e7", "\u00f1", "\u00fd", "\u00fe"));
    private static final HashSet<String> LETTER_SET = new HashSet<String>(Arrays.asList("b", "c", "d", "f", "g", "h", "j", "k", "l", "m", "n", "p", "q", "r", "s", "t", "v", "w", "x", "y", "z", "\u00e7", "\u00f1", "\u00fd", "\u00fe", "a", "e", "i", "o", "u", "\u00e0", "\u00e1", "\u00e2", "\u00e3", "\u00e4", "\u00e5", "\u00e8", "\u00e9", "\u00ea", "\u00eb", "\u00ec", "\u00ed", "\u00ee", "\u00ef", "\u00f0", "\u00f2", "\u00f3", "\u00f4", "\u00f5", "\u00f6", "\u00f8", "\u00f9", "\u00fa", "\u00fb", "\u00fc"));

    private WildCard() {
    }

    public static String GetSuffix(String inSuffix, String outSuffix, String inStr) {
        int size = inStr.length();
        int inSize = inSuffix.length();
        String endStr = inStr.substring(size - inSize);
        StringBuffer suffixStr = new StringBuffer();
        for (int i = 0; i < outSuffix.length(); ++i) {
            char curChar = outSuffix.charAt(i);
            if (WildCard.IsLegalWildCard(curChar) && curChar != '$') {
                if (i >= inSuffix.length() - 1) {
                    suffixStr.append(endStr.charAt(endStr.length() - 2));
                    continue;
                }
                suffixStr.append(endStr.charAt(i));
                continue;
            }
            suffixStr.append(curChar);
        }
        return suffixStr.toString();
    }

    public static boolean IsMatchKey(char key, int index, char[] inCharArray) {
        boolean matchFlag = false;
        if (WildCard.IsWildCard(key) && !WildCard.IsLegalWildCard(key)) {
            return false;
        }
        char curChar = inCharArray[index];
        String curStr = String.valueOf(curChar);
        if (key == inCharArray[index]) {
            matchFlag = true;
        } else if (key == 'V' && VOWEL_SET.contains(curStr)) {
            matchFlag = true;
        } else if (key == 'C' && CONSONANT_SET.contains(curStr)) {
            matchFlag = true;
        } else if (key == 'S' && index < Array.getLength(inCharArray) - 1 && curChar == inCharArray[index + 1]) {
            matchFlag = true;
        } else if (key == 'D' && Character.isDigit(curChar)) {
            matchFlag = true;
        } else if (key == 'L' && Character.isLetter(curChar) && Character.isLowerCase(curChar)) {
            matchFlag = true;
        } else if (key == '$' && index == Array.getLength(inCharArray) - 1) {
            matchFlag = true;
        } else if (key == '^' && index == -1) {
            matchFlag = true;
        }
        return matchFlag;
    }

    public static char WildCardTransform(char inChar) {
        String inStr = String.valueOf((char)inChar);
        int outChar = inChar;
        if (VOWEL_WILD_CARD_SET.contains(inStr)) {
            outChar = 86;
        } else if (CONSONANT_WILD_CARD_SET.contains(inStr)) {
            outChar = 67;
        }
        return (char)outChar;
    }

    public static String WildCardTransform(String inStr) {
        StringBuffer curStr = new StringBuffer(inStr);
        char lastChar = ' ';
        for (int i = curStr.length() - 1; i >= 0; --i) {
            char curChar = curStr.charAt(i);
            if (WildCard.IsWildCard(curChar)) {
                if (curChar == lastChar) {
                    curStr.setCharAt(i, 'S');
                } else {
                    curStr.setCharAt(i, WildCard.WildCardTransform(curChar));
                }
            }
            lastChar = inStr.charAt(i);
        }
        return curStr.toString();
    }

    public static boolean IsWildCard(char inChar) {
        boolean isWildCard = Character.isLetter(inChar) && !Character.isLowerCase(inChar);
        return isWildCard;
    }

    public static void main(String[] args) {
        String str = "CEXXer$|adj|comparative|CEX$|adj|positive";
        System.out.println("in:  '" + str + "'");
        System.out.println("out: '" + WildCard.WildCardTransform(str) + "'");
        System.out.println("-----------------------");
        str = "|CUAB|BDDer|ARRRRT|arrrrt";
        System.out.println("in:  '" + str + "'");
        System.out.println("out: '" + WildCard.WildCardTransform(str) + "'");
        System.out.println("-----------------------");
        System.out.println("IsLegalWildCard('A'): " + WildCard.IsLegalWildCard('A'));
        System.out.println("IsLegalWildCard('S'): " + WildCard.IsLegalWildCard('S'));
    }

    private static boolean IsLegalWildCard(char inChar) {
        String inStr = String.valueOf(inChar);
        return WILD_CARD_SET.contains(inStr);
    }
}

