/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.Strip;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToSyntacticUninvert
extends Transformation
implements Cloneable {
    private static final String INFO = "Syntactic Uninvert";

    public static Vector<LexItem> Mutate(LexItem in, Vector<String> nonInfoWords, Vector<String> conjunctionWords, boolean detailsFlag, boolean mutateFlag) {
        String inStr = in.GetSourceTerm();
        String stripedStr = Strip.StripStrings(inStr, nonInfoWords, false);
        String term = ToSyntacticUninvert.Uninvert(stripedStr, conjunctionWords);
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = INFO;
        }
        if (mutateFlag) {
            mutate = Transformation.NO_MUTATE_INFO;
        }
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToSyntacticUninvert.UpdateLexItem(in, term, 44, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }

    public static Vector<String> GetNonInfoWordsFromFile(Configuration conf) {
        String fName = conf.GetConfiguration("LVG_DIR") + conf.GetConfiguration("LVG_NONINFO_WORD_FILE");
        String line = null;
        Vector<String> nonInfoWords = new Vector<String>();
        try {
            BufferedReader in = new BufferedReader(new FileReader(fName));
            while ((line = in.readLine()) != null) {
                if (line.length() <= 0 || line.charAt(0) == '#') continue;
                nonInfoWords.addElement(line);
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.toString());
            System.err.println("** Error: problem of opening/reading non-Info words file: '" + fName + "'.");
        }
        return nonInfoWords;
    }

    public static Vector<String> GetConjunctionWordsFromFile(Configuration conf) {
        String fName = conf.GetConfiguration("LVG_DIR") + conf.GetConfiguration("LVG_CONJ_WORD_FILE");
        Vector<String> conjunctionWords = new Vector<String>();
        String line = null;
        try {
            BufferedReader in = new BufferedReader(new FileReader(fName));
            while ((line = in.readLine()) != null) {
                if (line.length() <= 0 || line.charAt(0) == '#') continue;
                conjunctionWords.addElement(line);
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.toString());
            System.err.println("** Error: problem of opening/reading conjunction words file: '" + fName + "'.");
        }
        return conjunctionWords;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToSyntacticUninvert.GetTestStr(args, "Angioplasty, Transluminal, Percutaneous Coronary");
        Vector<String> nonInfoWords = ToSyntacticUninvert.GetNonInfoWordsFromFile(conf);
        Vector<String> conjunctionWords = ToSyntacticUninvert.GetConjunctionWordsFromFile(conf);
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToSyntacticUninvert.Mutate(in, nonInfoWords, conjunctionWords, true, true);
        ToSyntacticUninvert.PrintResults(in, outs);
    }

    private static String Uninvert(String inStr, Vector<String> conjunctionWords) {
        Vector<String> tokenList = new Vector<String>();
        String delim = ",";
        StringTokenizer buf = new StringTokenizer(inStr, delim);
        boolean conjunctionFlag = false;
        while (buf.hasMoreTokens()) {
            String tempStr = buf.nextToken();
            tokenList.addElement(tempStr);
            String firstWord = ToSyntacticUninvert.GetFirstWord(tempStr);
            if (!conjunctionWords.contains(firstWord)) continue;
            conjunctionFlag = true;
        }
        String lastStr = new String();
        Vector<String> list = new Vector<String>();
        for (int i = 0; i < tokenList.size(); ++i) {
            String tempStr = (String)tokenList.elementAt(i);
            if (tempStr.startsWith(" ")) {
                if (conjunctionFlag) {
                    lastStr = lastStr + ", " + tempStr.trim();
                    continue;
                }
                list.addElement(lastStr);
                lastStr = new String(tempStr.trim());
                continue;
            }
            lastStr = lastStr.length() == 0 ? tempStr.trim() : lastStr + "," + tempStr.trim();
        }
        list.addElement(lastStr);
        StringBuffer buffer = new StringBuffer();
        for (int i = list.size() - 1; i >= 0; --i) {
            String tempStr = (String)list.elementAt(i);
            buffer.append(tempStr);
            buffer.append(" ");
        }
        String outStr = buffer.toString();
        return outStr.trim();
    }

    private static String GetFirstWord(String inStr) {
        String delim = " \t";
        StringTokenizer buf = new StringTokenizer(inStr, delim);
        return buf.nextToken();
    }
}

