/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.CmdLineSyntax;

import gov.nih.nlm.nls.lvg.CmdLineSyntax.Option;
import java.util.StringTokenizer;
import java.util.Vector;

public class OptionItem {
    private String optionItem_ = null;
    private String optionFlag_ = null;
    private String optionArgu_ = null;

    public OptionItem(String optionItem) {
        this.optionItem_ = optionItem;
        this.optionFlag_ = OptionItem.GetOptionFlag(optionItem);
        this.optionArgu_ = OptionItem.GetOptionArgument(optionItem);
    }

    public OptionItem(String optionItem, String optionFlag, String optionArgu) {
        this.optionItem_ = optionItem;
        this.optionFlag_ = optionFlag;
        this.optionArgu_ = optionArgu;
    }

    public static String GetOptionFlag(String optionItem) {
        return OptionItem.GetPartialOption(optionItem, true);
    }

    public static String GetOptionArgument(String optionItem) {
        return OptionItem.GetPartialOption(optionItem, false);
    }

    public static String GetSeparator(String itemStr, int distance) {
        String levelSeparator = null;
        for (int i = 0; i < 5; ++i) {
            int index = itemStr.indexOf(Option.SEPARATOR[i]);
            if (index != -1) continue;
            int sepIndex = i - 1 + distance;
            if (sepIndex < 0 || sepIndex >= 5) {
                levelSeparator = "-Error-";
                break;
            }
            levelSeparator = "" + Option.SEPARATOR[sepIndex];
            break;
        }
        return levelSeparator;
    }

    public static Vector<String> GetArgumentList(String str) {
        Vector<String> arguList = new Vector<String>(2);
        String delimiter = "+";
        StringTokenizer buf = new StringTokenizer(str, delimiter);
        while (buf.hasMoreTokens()) {
            arguList.addElement(buf.nextToken());
        }
        return arguList;
    }

    public String GetOptionItem() {
        return this.optionItem_;
    }

    public String GetOptionFlag() {
        return this.optionFlag_;
    }

    public String GetOptionArgument() {
        return this.optionArgu_;
    }

    private static String GetPartialOption(String optionItem, boolean isFlag) {
        String partialStr = null;
        int index = -1;
        int lastIndex = -1;
        for (int i = 0; i < 5; ++i) {
            char separator = Option.SEPARATOR[i];
            index = optionItem.indexOf(separator);
            if (index == -1) {
                if (isFlag) {
                    partialStr = optionItem.substring(0, lastIndex);
                    if (partialStr.length() != 0) break;
                    partialStr = "Root";
                    break;
                }
                partialStr = optionItem.substring(lastIndex + 1);
                break;
            }
            lastIndex = index;
        }
        return partialStr;
    }
}

