/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.pipeline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ctakes.core.cc.FileTreeXmiWriter;
import org.apache.ctakes.core.cr.FileTreeReader;
import org.apache.ctakes.core.pipeline.CuiCollector;
import org.apache.ctakes.core.pipeline.EntityCollector;
import org.apache.ctakes.core.util.PropertyAeFactory;
import org.apache.log4j.Logger;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_component.AnalysisComponent;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public final class PipelineBuilder {
    private static final Logger LOGGER = Logger.getLogger((String)"PipelineBuilder");
    private CollectionReaderDescription _readerDesc;
    private final List<String> _aeNameList = new ArrayList<String>();
    private final List<AnalysisEngineDescription> _descList = new ArrayList<AnalysisEngineDescription>();
    private final List<String> _aeEndNameList = new ArrayList<String>();
    private final List<AnalysisEngineDescription> _descEndList = new ArrayList<AnalysisEngineDescription>();
    private AnalysisEngineDescription _analysisEngineDesc;
    private boolean _pipelineChanged;

    public void clear() {
        this._aeNameList.clear();
        this._descList.clear();
        this._aeEndNameList.clear();
        this._descEndList.clear();
    }

    public PipelineBuilder set(Object ... parameters) {
        PropertyAeFactory.getInstance().addParameters(parameters);
        this._pipelineChanged = true;
        return this;
    }

    public PipelineBuilder reader(CollectionReaderDescription description) {
        this._readerDesc = description;
        this._pipelineChanged = true;
        return this;
    }

    public PipelineBuilder reader(Class<? extends CollectionReader> readerClass, Object ... parameters) throws UIMAException {
        this.reader(CollectionReaderFactory.createReaderDescription(readerClass, (Object[])parameters));
        this._pipelineChanged = true;
        return this;
    }

    public PipelineBuilder readFiles() throws UIMAException {
        this._readerDesc = CollectionReaderFactory.createReaderDescription(FileTreeReader.class, (Object[])new Object[0]);
        this._pipelineChanged = true;
        return this;
    }

    public PipelineBuilder readFiles(String inputDirectory) throws UIMAException {
        this._readerDesc = CollectionReaderFactory.createReaderDescription(FileTreeReader.class, (Object[])new Object[]{"InputDirectory", inputDirectory});
        this._pipelineChanged = true;
        return this;
    }

    public CollectionReaderDescription getReader() {
        return this._readerDesc;
    }

    public PipelineBuilder add(Class<? extends AnalysisComponent> component, Object ... parameters) throws ResourceInitializationException {
        this._aeNameList.add(component.getName());
        this._descList.add(PropertyAeFactory.getInstance().createDescription(component, parameters));
        this._pipelineChanged = true;
        return this;
    }

    public PipelineBuilder addLogged(Class<? extends AnalysisComponent> component, Object ... parameters) throws ResourceInitializationException {
        this._aeNameList.add(component.getName());
        this._descList.add(PropertyAeFactory.getInstance().createLoggedDescription(component, parameters));
        this._pipelineChanged = true;
        return this;
    }

    public PipelineBuilder addDescription(AnalysisEngineDescription description) {
        this._aeNameList.add(description.getAnnotatorImplementationName());
        this._descList.add(description);
        this._pipelineChanged = true;
        return this;
    }

    public PipelineBuilder addLast(Class<? extends AnalysisComponent> component, Object ... parameters) throws ResourceInitializationException {
        this._aeEndNameList.add(component.getName());
        this._descEndList.add(PropertyAeFactory.getInstance().createDescription(component, parameters));
        this._pipelineChanged = true;
        return this;
    }

    public List<String> getAeNames() {
        ArrayList<String> allNames = new ArrayList<String>(this._aeNameList);
        allNames.addAll(this._aeEndNameList);
        return Collections.unmodifiableList(allNames);
    }

    public PipelineBuilder collectCuis() throws ResourceInitializationException {
        return this.add(CuiCollector.CuiCollectorEngine.class, new Object[0]);
    }

    public PipelineBuilder collectEntities() throws ResourceInitializationException {
        return this.add(EntityCollector.EntityCollectorEngine.class, new Object[0]);
    }

    public PipelineBuilder writeXMIs() throws ResourceInitializationException {
        return this.addLast(FileTreeXmiWriter.class, new Object[0]);
    }

    public PipelineBuilder writeXMIs(String outputDirectory) throws ResourceInitializationException {
        return this.addLast(FileTreeXmiWriter.class, "OutputDirectory", outputDirectory);
    }

    public PipelineBuilder build() throws IOException, UIMAException {
        if (this._analysisEngineDesc == null || this._pipelineChanged) {
            AggregateBuilder builder = new AggregateBuilder();
            this._descList.forEach(x$0 -> builder.add(x$0, new String[0]));
            this._descEndList.forEach(x$0 -> builder.add(x$0, new String[0]));
            this._analysisEngineDesc = builder.createAggregateDescription();
        }
        this._pipelineChanged = false;
        return this;
    }

    public PipelineBuilder run() throws IOException, UIMAException {
        if (this._readerDesc == null) {
            LOGGER.error((Object)"No Collection Reader specified.");
            return this;
        }
        this.build();
        SimplePipeline.runPipeline((CollectionReaderDescription)this._readerDesc, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{this._analysisEngineDesc});
        return this;
    }

    public PipelineBuilder run(String text) throws IOException, UIMAException {
        if (this._readerDesc != null) {
            LOGGER.error((Object)"Collection Reader specified, ignoring.");
            return this;
        }
        JCas jcas = JCasFactory.createJCas();
        jcas.setDocumentText(text);
        this.build();
        SimplePipeline.runPipeline((JCas)jcas, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{this._analysisEngineDesc});
        return this;
    }

    public AnalysisEngineDescription getAnalysisEngineDesc() throws IOException, UIMAException {
        this.build();
        return this._analysisEngineDesc;
    }
}

