/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.io.OutputStream;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.internal.util.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XMISerializer {
    private SAXTransformerFactory transformerFactory;
    private TransformerHandler mHandler;
    private Transformer mTransformer;
    private OutputStream mOutputStream;
    private Writer mWriter;

    public XMISerializer() {
        try {
            this.transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", this.getClass().getClassLoader());
            this.mHandler = this.transformerFactory.newTransformerHandler();
            this.mTransformer = this.mHandler.getTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new UIMARuntimeException((Throwable)e);
        }
    }

    public XMISerializer(OutputStream aOutputStream) {
        this();
        this.setOutputStream(aOutputStream);
    }

    public void setOutputStream(OutputStream aOutputStream) {
        this.mWriter = null;
        this.mOutputStream = aOutputStream;
        this.mHandler.setResult(this.createSaxResultObject());
    }

    public void setWriter(Writer aWriter) {
        this.mOutputStream = null;
        this.mWriter = aWriter;
        this.mHandler.setResult(this.createSaxResultObject());
    }

    private Result createSaxResultObject() {
        if (this.mOutputStream != null) {
            return new StreamResult(this.mOutputStream);
        }
        if (this.mWriter != null) {
            return new StreamResult(this.mWriter);
        }
        return null;
    }

    public ContentHandler getContentHandler() {
        String xmlVer = this.mTransformer.getOutputProperty("version");
        boolean xml10 = xmlVer == null || "1.0".equals(xmlVer);
        return new CharacterValidatingContentHandler(!xml10, this.mHandler);
    }

    static class CharacterValidatingContentHandler
    implements ContentHandler {
        ContentHandler mHandler;
        boolean mXml11;

        CharacterValidatingContentHandler(boolean xml11, ContentHandler serializerHandler) {
            this.mHandler = serializerHandler;
            this.mXml11 = xml11;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            for (int i = 0; i < atts.getLength(); ++i) {
                String val = atts.getValue(i);
                this.checkForInvalidXmlChars(val, this.mXml11);
            }
            this.mHandler.startElement(uri, localName, qName, atts);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.checkForInvalidXmlChars(ch, start, length, this.mXml11);
            this.mHandler.characters(ch, start, length);
        }

        @Override
        public void endDocument() throws SAXException {
            this.mHandler.endDocument();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.mHandler.endElement(uri, localName, qName);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.mHandler.endPrefixMapping(prefix);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.mHandler.ignorableWhitespace(ch, start, length);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.mHandler.processingInstruction(target, data);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.mHandler.setDocumentLocator(locator);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            this.mHandler.skippedEntity(name);
        }

        @Override
        public void startDocument() throws SAXException {
            this.mHandler.startDocument();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.mHandler.startPrefixMapping(prefix, uri);
        }

        private final void checkForInvalidXmlChars(String s, boolean xml11) throws SAXParseException {
            int index = XMLUtils.checkForNonXmlCharacters((String)s, (boolean)xml11);
            if (index >= 0) {
                throw new SAXParseException("Trying to serialize non-XML " + (xml11 ? "1.1" : "1.0") + " character: " + s.charAt(index) + ", 0x" + Integer.toHexString(s.charAt(index)), null);
            }
        }

        private final void checkForInvalidXmlChars(char[] ch, int start, int length, boolean xml11) throws SAXParseException {
            int index = XMLUtils.checkForNonXmlCharacters((char[])ch, (int)start, (int)length, (boolean)xml11);
            if (index >= 0) {
                throw new SAXParseException("Trying to serialize non-XML " + (xml11 ? "1.1" : "1.0") + " character: " + ch[index] + ", 0x" + Integer.toHexString(ch[index]), null);
            }
        }
    }
}

