/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.cc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.ctakes.assertion.eval.AssertionEvaluation;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.ctakes.typesystem.type.relation.Relation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XCASSerializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.fit.component.JCasConsumer_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.SAXException;

@PipeBitInfo(name="Judged Attribute XMI Writer", description="Writes XMI File based upon judged attributes.", role=PipeBitInfo.Role.WRITER, dependencies={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class JudgeAttributeInstances
extends JCasConsumer_ImplBase {
    public static final String PARAM_OUTPUT_DIRECTORY_NAME = "outputDirectoryName";
    @ConfigurationParameter(name="outputDirectoryName", mandatory=true, description="takes a path to directory into which output files will be written.")
    private String outputDirectoryName;
    public static final String PARAM_XML_SCHEME_NAME = "xmlSchemeName";
    @ConfigurationParameter(name="xmlSchemeName", mandatory=true, defaultValue={"XMI"}, description="specifies the UIMA XML serialization scheme that should be used. Valid values for this parameter are 'XMI' (default) and 'XCAS'.")
    private String xmlSchemeName;
    private static int DEFAULT_CONTEXT_LEN = 80;
    private int currentContextLen = DEFAULT_CONTEXT_LEN;
    public static final String XMI = "XMI";
    public static final String XCAS = "XCAS";
    protected static AssertionEvaluation.Options options = new AssertionEvaluation.Options();
    private static final HashMap<Selector, String> msg = new HashMap();
    private ArrayList<IdentifiedAnnotation> deletableMentions = new ArrayList();
    private File outputDirectory;
    private boolean useXMI = true;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.outputDirectory = new File(this.outputDirectoryName);
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        if (this.xmlSchemeName.equals(XMI)) {
            this.useXMI = true;
        } else if (this.xmlSchemeName.equals(XCAS)) {
            this.useXMI = false;
        } else {
            throw new ResourceInitializationException(String.format("parameter '%1$s' must be either '%2$s' or '%3$s'.", PARAM_XML_SCHEME_NAME, XMI, XCAS), null);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        String sourceFileName = DocumentIDAnnotationUtil.getDocumentID((JCas)jCas);
        System.out.println("==================\nFile: " + sourceFileName);
        this.deletableMentions = new ArrayList();
        this.judgeAttributes(jCas);
        this.removeRelations(jCas);
        this.removeExtraneousMentions(jCas);
        try {
            if (this.useXMI) {
                this.writeXmi(jCas.getCas(), sourceFileName);
            } else {
                this.writeXCas(jCas.getCas(), sourceFileName);
            }
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (SAXException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXCas(CAS aCas, String fileName) throws IOException, SAXException {
        File outFile = new File(this.outputDirectory, fileName + ".xcas");
        try (FileOutputStream out = null;){
            out = new FileOutputStream(outFile);
            XCASSerializer ser = new XCASSerializer(aCas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer((OutputStream)out, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeXmi(CAS aCas, String id) throws IOException, SAXException {
        File outFile = new File(this.outputDirectory, id);
        try (FileOutputStream out = null;){
            out = new FileOutputStream(outFile);
            XmiCasSerializer ser = new XmiCasSerializer(aCas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer((OutputStream)out, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
    }

    private void judgeAttributes(JCas jCas) {
        ArrayList mentions = new ArrayList();
        mentions.addAll(JCasUtil.select((JCas)jCas, IdentifiedAnnotation.class));
        for (IdentifiedAnnotation mention : mentions) {
            boolean keep;
            if (!EntityMention.class.isAssignableFrom(mention.getClass()) && !EventMention.class.isAssignableFrom(mention.getClass())) continue;
            HashSet<Selector> hypothAttr = new HashSet<Selector>();
            boolean conditional = mention.getConditional();
            boolean generic = mention.getGeneric();
            int historyOf = mention.getHistoryOf();
            int polarity = mention.getPolarity();
            String subject = mention.getSubject();
            int uncertainty = mention.getUncertainty();
            if (conditional && !JudgeAttributeInstances.options.ignoreConditional && (keep = this.interact(jCas, mention, Selector.CONDITIONAL))) {
                hypothAttr.add(Selector.CONDITIONAL);
            }
            if (generic && !JudgeAttributeInstances.options.ignoreGeneric && (keep = this.interact(jCas, mention, Selector.GENERIC))) {
                hypothAttr.add(Selector.GENERIC);
            }
            if (historyOf != 1 || !JudgeAttributeInstances.options.ignoreHistory) {
                // empty if block
            }
            if (polarity != -1 || !JudgeAttributeInstances.options.ignorePolarity) {
                // empty if block
            }
            if (!"patient".equals(subject) && subject != null && !JudgeAttributeInstances.options.ignoreSubject && (keep = this.interact(jCas, mention, Selector.SUBJECT))) {
                hypothAttr.add(Selector.SUBJECT);
            }
            if (uncertainty == 1 && !JudgeAttributeInstances.options.ignoreUncertainty && (keep = this.interact(jCas, mention, Selector.UNCERTAINTY))) {
                hypothAttr.add(Selector.UNCERTAINTY);
            }
            if (!hypothAttr.isEmpty()) continue;
            this.deletableMentions.add(mention);
        }
    }

    private void printContext(String text, IdentifiedAnnotation mention, int radius) {
        int mentionBegin = mention.getBegin();
        int mentionEnd = mention.getEnd();
        StringBuilder sb = new StringBuilder();
        int snipBegin = mentionBegin - radius < 0 ? 0 : mentionBegin - radius;
        int snipEnd = mentionEnd + radius > text.length() - 1 ? text.length() - 1 : mentionEnd + radius;
        String[] tmp = mention.getClass().getName().split("\\.");
        String semGroup = tmp[tmp.length - 1];
        sb.append(text.substring(snipBegin, mentionBegin));
        sb.append("[[[" + mention.getCoveredText() + "]]]");
        sb.append(text.substring(mentionEnd, snipEnd));
        System.out.println("| " + sb.toString().replaceAll("\\n", "\n| "));
        System.out.println(": " + semGroup + " : beg=" + mention.getBegin() + " : end=" + mention.getEnd() + " : c=" + mention.getConditional() + " : g=" + mention.getGeneric() + " : h=" + mention.getHistoryOf() + " : p=" + mention.getPolarity() + " : s=" + mention.getSubject() + " : u=" + mention.getUncertainty());
    }

    private void printContext(String text, IdentifiedAnnotation mention) {
        this.printContext(text, mention, DEFAULT_CONTEXT_LEN);
    }

    public static String prompt(String attr) {
        System.out.print(attr + "? ");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String response = "";
        try {
            response = br.readLine();
            System.out.println();
        }
        catch (IOException ioe) {
            System.out.println("IO error trying to read your response!");
            System.exit(1);
        }
        return response;
    }

    private boolean interact(JCas jCas, IdentifiedAnnotation mention, Selector attr) {
        this.printContext(jCas.getDocumentText(), mention);
        String response = JudgeAttributeInstances.prompt("> " + msg.get((Object)attr) + "=" + this.getAttrValueString(mention, attr));
        while (true) {
            if ("".equals(response) || response == null) {
                response = JudgeAttributeInstances.prompt("umm... is this " + msg.get((Object)attr) + "=" + this.getAttrValueString(mention, attr));
                continue;
            }
            if (response.toLowerCase().startsWith("y")) break;
            if (response.toLowerCase().startsWith("n")) {
                this.adjustAttr(attr, response, mention);
                break;
            }
            if (response.toLowerCase().startsWith("s")) {
                this.deletableMentions.add(mention);
                this.currentContextLen = DEFAULT_CONTEXT_LEN;
                return false;
            }
            if (response.toLowerCase().startsWith("m")) {
                this.currentContextLen += DEFAULT_CONTEXT_LEN;
                this.printContext(jCas.getDocumentText(), mention, this.currentContextLen);
                response = JudgeAttributeInstances.prompt(msg.get((Object)attr) + "=" + this.getAttrValueString(mention, attr));
                continue;
            }
            response = JudgeAttributeInstances.prompt("not sure what you meant. y=yes, n=no, m=more_context, s=skip.\\n" + msg.get((Object)attr) + "=" + this.getAttrValueString(mention, attr));
        }
        this.currentContextLen = DEFAULT_CONTEXT_LEN;
        return true;
    }

    private void adjustAttr(Selector attr, String response, IdentifiedAnnotation mention) {
        switch (attr) {
            case CONDITIONAL: {
                mention.setConditional(false);
                break;
            }
            case GENERIC: {
                mention.setGeneric(false);
                break;
            }
            case HISTORYOF: {
                mention.setHistoryOf(0);
                break;
            }
            case POLARITY: {
                mention.setPolarity(1);
                break;
            }
            case SUBJECT: {
                response = JudgeAttributeInstances.prompt("what is the subject? p=patient (default), f=family_member, df=donor_family_member, do=donor_other, o=other... or s=skip");
                if (response.startsWith("p")) {
                    mention.setSubject("patient");
                    break;
                }
                if (response.startsWith("f")) {
                    mention.setSubject("family_member");
                    break;
                }
                if (response.startsWith("df")) {
                    mention.setSubject("donor_family_member");
                    break;
                }
                if (response.equals("do")) {
                    mention.setSubject("donor_other");
                    break;
                }
                if (response.startsWith("o")) {
                    mention.setSubject("other");
                    break;
                }
                System.out.println("hmm... i'm skipping it.");
                this.deletableMentions.add(mention);
                break;
            }
            case UNCERTAINTY: {
                mention.setUncertainty(0);
                break;
            }
        }
    }

    private String getAttrValueString(IdentifiedAnnotation mention, Selector s) {
        switch (s) {
            case CONDITIONAL: {
                return String.valueOf(mention.getConditional());
            }
            case GENERIC: {
                return String.valueOf(mention.getGeneric());
            }
            case HISTORYOF: {
                return String.valueOf(mention.getHistoryOf());
            }
            case POLARITY: {
                return String.valueOf(mention.getPolarity());
            }
            case SUBJECT: {
                return String.valueOf(mention.getSubject());
            }
            case UNCERTAINTY: {
                return String.valueOf(mention.getUncertainty());
            }
        }
        return "?";
    }

    private void removeExtraneousMentions(JCas jcas) {
        for (IdentifiedAnnotation mention : this.deletableMentions) {
            if (mention == null) continue;
            mention.removeFromIndexes();
        }
    }

    private void removeRelations(JCas jCas) {
        HashSet del = new HashSet();
        del.addAll(JCasUtil.select((JCas)jCas, RelationArgument.class));
        del.addAll(JCasUtil.select((JCas)jCas, Relation.class));
        for (TOP t : del) {
            t.removeFromIndexes(jCas);
        }
    }

    private void createNewMention(JCas jCas, IdentifiedAnnotation mention, HashSet<Selector> hypothAttr) throws Throwable, IllegalAccessException {
        Constructor<?> ctor = mention.getClass().getDeclaredConstructor(JCas.class);
        IdentifiedAnnotation m = (IdentifiedAnnotation)ctor.newInstance(jCas);
        m.setBegin(mention.getBegin());
        m.setEnd(mention.getEnd());
        for (Selector s : msg.keySet()) {
            if (hypothAttr.contains((Object)s)) continue;
            switch (s) {
                case CONDITIONAL: {
                    m.setConditional(mention.getConditional());
                    break;
                }
                case GENERIC: {
                    m.setGeneric(mention.getGeneric());
                    break;
                }
                case HISTORYOF: {
                    m.setHistoryOf(mention.getHistoryOf());
                    break;
                }
                case POLARITY: {
                    m.setPolarity(mention.getPolarity());
                    break;
                }
                case SUBJECT: {
                    m.setSubject(mention.getSubject());
                    break;
                }
                case UNCERTAINTY: {
                    m.setUncertainty(mention.getUncertainty());
                }
            }
        }
        m.addToIndexes(jCas);
    }

    static {
        msg.put(Selector.CONDITIONAL, "conditional");
        msg.put(Selector.GENERIC, "generic");
        msg.put(Selector.HISTORYOF, "historyOf");
        msg.put(Selector.POLARITY, "polarity");
        msg.put(Selector.SUBJECT, "subject");
        msg.put(Selector.UNCERTAINTY, "uncertainty");
    }

    protected static enum Selector {
        CONDITIONAL,
        GENERIC,
        HISTORYOF,
        POLARITY,
        SUBJECT,
        UNCERTAINTY;

    }
}

