/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.sigmoid;

import java.io.Serializable;

public class Sigmoid
implements Serializable {
    private static final long serialVersionUID = 3780856549630884460L;
    private double A;
    private double B;

    public Sigmoid(double A, double B) {
        this.A = A;
        this.B = B;
    }

    public double evaluate(double v) {
        return 1.0 / (1.0 + Math.exp(this.A * v + this.B));
    }

    public double getA() {
        return this.A;
    }

    public double getB() {
        return this.B;
    }

    public String toString() {
        if (this.B < 0.0) {
            return String.format("1 / (1 + exp(%.3f*x - %.3f))", this.A, -this.B);
        }
        return String.format("1 / (1 + exp(%.3f*x + %.3f))", this.A, this.B);
    }
}

