/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.dependency.srl;

import com.googlecode.clearnlp.dependency.srl.SRLLib;
import com.googlecode.clearnlp.util.pair.StringIntPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class SRLEval {
    private final String HLINE = "------------------------------------------------------------";
    private final int IDX_CORRECT = 0;
    private final int IDX_AUTO = 1;
    private final int IDX_GOLD = 2;
    public static final String UAS = "UAS";
    public static final String LAS = "LAS";
    public static final String ARGN = "ARGN";
    public static final String ARGM = "ARGM";
    private HashMap<String, int[]> m_counts;

    public SRLEval() {
        this.init();
    }

    public void init() {
        this.m_counts = new HashMap();
        this.m_counts.put(UAS, new int[3]);
        this.m_counts.put(LAS, new int[3]);
        this.m_counts.put(ARGN, new int[3]);
        this.m_counts.put(ARGM, new int[3]);
    }

    public void evaluate(StringIntPair[][] gold, StringIntPair[][] auto) {
        int size = gold.length;
        for (int i = 1; i < size; ++i) {
            StringIntPair[] gHeads = gold[i];
            StringIntPair[] aHeads = auto[i];
            this.evaluate(gHeads, aHeads);
        }
    }

    public void evaluate(StringIntPair[] gold, StringIntPair[] auto) {
        int[] arg;
        boolean isArgn;
        int[] uas = this.m_counts.get(UAS);
        int[] las = this.m_counts.get(LAS);
        int[] argn = this.m_counts.get(ARGN);
        int[] argm = this.m_counts.get(ARGM);
        for (StringIntPair gHead : gold) {
            isArgn = SRLLib.isNumberedArgument(gHead.s);
            if (isArgn) {
                argn[2] = argn[2] + 1;
            } else {
                argm[2] = argm[2] + 1;
            }
            arg = this.getArray(gHead.s);
            arg[2] = arg[2] + 1;
            for (StringIntPair aHead : auto) {
                if (gHead.i != aHead.i) continue;
                uas[0] = uas[0] + 1;
                if (!gHead.s.equals(aHead.s)) continue;
                las[0] = las[0] + 1;
                arg[0] = arg[0] + 1;
                if (isArgn) {
                    argn[0] = argn[0] + 1;
                    continue;
                }
                argm[0] = argm[0] + 1;
            }
        }
        for (StringIntPair aHead : auto) {
            isArgn = SRLLib.isNumberedArgument(aHead.s);
            if (isArgn) {
                argn[1] = argn[1] + 1;
            } else {
                argm[1] = argm[1] + 1;
            }
            arg = this.getArray(aHead.s);
            arg[1] = arg[1] + 1;
        }
        uas[1] = uas[1] + auto.length;
        uas[2] = uas[2] + gold.length;
        las[1] = las[1] + auto.length;
        las[2] = las[2] + gold.length;
    }

    private int[] getArray(String label) {
        if (label.startsWith("C-")) {
            label = label.substring(2);
        }
        if (this.m_counts.containsKey(label)) {
            return this.m_counts.get(label);
        }
        int[] counts = new int[3];
        this.m_counts.put(label, counts);
        return counts;
    }

    public void print() {
        this.printOverall();
        ArrayList<String> labels = new ArrayList<String>(this.m_counts.keySet());
        Collections.sort(labels);
        int total = this.getTotalCount();
        for (String label : labels) {
            if (label.equals(UAS) || label.equals(LAS) || label.equals(ARGN) || label.equals(ARGM)) continue;
            this.printLabel(label, total);
        }
        System.out.println("------------------------------------------------------------");
    }

    public void printOverall() {
        int total = this.getTotalCount();
        System.out.println("------------------------------------------------------------");
        System.out.printf("%10s%10s%10s%10s%10s%10s\n", "Label", "Count", "Dist.", "P", "R", "F1");
        System.out.println("------------------------------------------------------------");
        this.printLabel(UAS, total);
        this.printLabel(LAS, total);
        System.out.println("------------------------------------------------------------");
        this.printLabel(ARGN, total);
        this.printLabel(ARGM, total);
        System.out.println("------------------------------------------------------------");
    }

    private void printLabel(String label, int total) {
        int[] counts = this.m_counts.get(label);
        int auto = counts[1];
        int gold = counts[2];
        double dist = 100.0 * (double)gold / (double)total;
        double precision = auto == 0 ? 0.0 : 100.0 * (double)counts[0] / (double)auto;
        double recall = gold == 0 ? 0.0 : 100.0 * (double)counts[0] / (double)gold;
        double f1 = SRLEval.getF1(precision, recall);
        System.out.printf("%10s%10d%10.2f%10.2f%10.2f%10.2f\n", label, gold, dist, precision, recall, f1);
    }

    private int getTotalCount() {
        return this.m_counts.get(UAS)[2];
    }

    public double getF1(String label) {
        int[] counts = this.m_counts.get(label);
        int auto = counts[1];
        int gold = counts[2];
        double precision = auto == 0 ? 0.0 : 100.0 * (double)counts[0] / (double)auto;
        double recall = gold == 0 ? 0.0 : 100.0 * (double)counts[0] / (double)gold;
        return SRLEval.getF1(precision, recall);
    }

    public static double getF1(double precision, double recall) {
        return precision + recall == 0.0 ? 0.0 : 2.0 * (precision * recall) / (precision + recall);
    }
}

