/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.demo;

import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.EngineProcess;
import com.googlecode.clearnlp.propbank.verbnet.PVMap;
import com.googlecode.clearnlp.reader.SRLReader;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.PrintStream;

public class DemoVerbNet {
    public DemoVerbNet(String mapFile, String inputFile, String outputFile) throws Exception {
        PVMap map = new PVMap(new BufferedInputStream(new FileInputStream(mapFile)));
        BufferedReader fin = UTInput.createBufferedFileReader(inputFile);
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        this.addVerbNet(map, fin, fout);
    }

    public void addVerbNet(PVMap map, BufferedReader fin, PrintStream fout) {
        DEPTree tree;
        SRLReader reader = new SRLReader(0, 1, 2, 3, 4, 5, 6, 7);
        reader.open(fin);
        while ((tree = reader.next()) != null) {
            EngineProcess.addVerbNet(map, tree);
            fout.println(tree.toStringSRL() + "\n");
        }
        reader.close();
        fout.close();
    }

    public static void main(String[] args) {
        String mapFile = args[0];
        String inputFile = args[1];
        String outputFile = args[2];
        try {
            new DemoVerbNet(mapFile, inputFile, outputFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

