/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.classification.model;

import com.carrotsearch.hppc.ObjectIntOpenHashMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.googlecode.clearnlp.classification.prediction.IntPrediction;
import com.googlecode.clearnlp.classification.prediction.StringPrediction;
import com.googlecode.clearnlp.classification.vector.SparseFeatureVector;
import com.googlecode.clearnlp.util.UTArray;
import com.googlecode.clearnlp.util.pair.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class AbstractModel {
    public static String LABEL_TRUE = "T";
    public static String LABEL_FALSE = "F";
    protected int n_labels;
    protected int n_features;
    protected double[] d_weights;
    protected String[] a_labels;
    protected ObjectIntOpenHashMap<String> m_labels;
    protected byte i_solver;

    public AbstractModel() {
        this.n_labels = 0;
        this.m_labels = new ObjectIntOpenHashMap();
        this.n_features = 1;
    }

    public AbstractModel(BufferedReader reader) {
        this.load(reader);
    }

    public abstract void load(BufferedReader var1);

    public abstract void save(PrintStream var1);

    public void setSolver(byte solver) {
        this.i_solver = solver;
    }

    public void setWeights(double[] weights) {
        this.d_weights = weights;
    }

    public double[] getWeights() {
        return this.d_weights;
    }

    public void initLabelArray() {
        this.a_labels = new String[this.n_labels];
        for (ObjectCursor cur : this.m_labels.keys()) {
            String label;
            this.a_labels[this.getLabelIndex((String)label)] = label = (String)cur.value;
        }
    }

    public void addLabel(String label) {
        if (!this.m_labels.containsKey((Object)label)) {
            this.m_labels.put((Object)label, ++this.n_labels);
        }
    }

    public int getLabelIndex(String label) {
        return this.m_labels.get((Object)label) - 1;
    }

    public boolean isBinaryLabel() {
        return this.n_labels == 2;
    }

    public int getLabelSize() {
        return this.n_labels;
    }

    public int getFeatureSize() {
        return this.n_features;
    }

    public String getLabel(int index) {
        return this.a_labels[index];
    }

    public String[] getLabels() {
        return this.a_labels;
    }

    public void initWeightVector() {
        this.d_weights = this.isBinaryLabel() ? new double[this.n_features] : new double[this.n_features * this.n_labels];
    }

    public void initWeightVector(int nLabels) {
        this.d_weights = new double[this.n_features * nLabels];
    }

    public void copyWeightVector(double[] vector) {
        System.arraycopy(vector, 0, this.d_weights, 0, this.n_features);
    }

    public void copyWeightVector(int label, double[] weights) {
        for (int i = 0; i < this.n_features; ++i) {
            this.d_weights[this.getWeightIndex((int)label, (int)i)] = weights[i];
        }
    }

    public double[] getWeightVector(int label) {
        double[] weights = new double[this.n_features];
        for (int i = 0; i < this.n_features; ++i) {
            weights[i] = this.d_weights[this.getWeightIndex(label, i)];
        }
        return weights;
    }

    public void updateWeightVector(int y, int[] xs, double[] costs) {
        int size = xs.length;
        for (int i = 0; i < size; ++i) {
            int n = this.getWeightIndex(y, xs[i]);
            this.d_weights[n] = this.d_weights[n] + costs[i];
        }
    }

    public double[] getScores(SparseFeatureVector x) {
        return this.isBinaryLabel() ? this.getScoresBinary(x) : this.getScoresMulti(x);
    }

    public double[] getScoresBinary(SparseFeatureVector x) {
        double score = this.d_weights[0];
        int size = x.size();
        for (int i = 0; i < size; ++i) {
            int index = x.getIndex(i);
            if (!this.isRange(index)) continue;
            if (x.hasWeight()) {
                score += this.d_weights[index] * x.getWeight(i);
                continue;
            }
            score += this.d_weights[index];
        }
        double[] scores = new double[]{score, -score};
        return scores;
    }

    public double[] getScoresMulti(SparseFeatureVector x) {
        double[] scores = Arrays.copyOf(this.d_weights, this.n_labels);
        int size = x.size();
        double weight = 1.0;
        for (int i = 0; i < size; ++i) {
            int index = x.getIndex(i);
            if (x.hasWeight()) {
                weight = x.getWeight(i);
            }
            if (!this.isRange(index)) continue;
            for (int label = 0; label < this.n_labels; ++label) {
                int weightIndex = this.getWeightIndex(label, index);
                if (x.hasWeight()) {
                    int n = label;
                    scores[n] = scores[n] + this.d_weights[weightIndex] * weight;
                    continue;
                }
                int n = label;
                scores[n] = scores[n] + this.d_weights[weightIndex];
            }
        }
        return scores;
    }

    public boolean isRange(int featureIndex) {
        return 0 < featureIndex && featureIndex < this.n_features;
    }

    protected int getWeightIndex(int label, int index) {
        return index * this.n_labels + label;
    }

    protected void loadLabels(BufferedReader fin) throws IOException {
        this.n_labels = Integer.parseInt(fin.readLine());
        this.a_labels = fin.readLine().split(" ");
        this.m_labels = new ObjectIntOpenHashMap();
        for (int i = 0; i < this.n_labels; ++i) {
            this.m_labels.put((Object)this.a_labels[i], i + 1);
        }
    }

    protected void saveLabels(PrintStream fout) {
        fout.println(this.n_labels);
        fout.println(UTArray.join(this.a_labels, " "));
    }

    protected void loadWeightVector(BufferedReader fin) throws Exception {
        int[] buffer = new int[128];
        int size = Integer.parseInt(fin.readLine());
        this.d_weights = new double[size];
        for (int i = 0; i < size; ++i) {
            int ch;
            int b = 0;
            while ((ch = fin.read()) != 32) {
                buffer[b++] = ch;
            }
            this.d_weights[i] = Double.parseDouble(new String(buffer, 0, b));
            if (i % this.n_features != 0) continue;
            System.out.print(".");
        }
        fin.readLine();
    }

    protected void saveWeightVector(PrintStream fout) {
        int size = this.d_weights.length;
        StringBuilder build = null;
        fout.println(size);
        for (int i = 0; i < size; ++i) {
            if (i % this.n_features == 0) {
                System.out.print(".");
                if (build != null) {
                    fout.print(build.toString());
                }
                build = new StringBuilder();
            }
            build.append(this.d_weights[i]);
            build.append(' ');
        }
        fout.println(build.toString());
    }

    public byte[] toByteArray(double value) {
        byte[] bytes = new byte[8];
        ByteBuffer.wrap(bytes).putDouble(value);
        return bytes;
    }

    public double toDouble(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getDouble();
    }

    public void normalizeScores(List<StringPrediction> ps) {
        if (this.isBinaryLabel()) {
            double d;
            StringPrediction p = ps.get(0);
            p.score = d = 1.0 / (1.0 + Math.exp(-p.score));
            ps.get((int)1).score = 1.0 - d;
        } else {
            double sum = 0.0;
            for (StringPrediction p : ps) {
                double d;
                p.score = d = 1.0 / (1.0 + Math.exp(-p.score));
                sum += d;
            }
            for (StringPrediction p : ps) {
                p.score /= sum;
            }
        }
    }

    public StringPrediction predictBest(SparseFeatureVector x) {
        List<StringPrediction> list = this.getPredictions(x);
        StringPrediction max = list.get(0);
        int size = list.size();
        for (int i = 1; i < size; ++i) {
            StringPrediction p = list.get(i);
            if (!(max.score < p.score)) continue;
            max = p;
        }
        return max;
    }

    public Pair<StringPrediction, StringPrediction> predictTwo(SparseFeatureVector x) {
        return this.predictTwo(this.getPredictions(x));
    }

    public Pair<StringPrediction, StringPrediction> predictTwo(List<StringPrediction> list) {
        StringPrediction fst = list.get(0);
        StringPrediction snd = list.get(1);
        int size = list.size();
        if (fst.score < snd.score) {
            fst = snd;
            snd = list.get(0);
        }
        for (int i = 2; i < size; ++i) {
            StringPrediction p = list.get(i);
            if (fst.score < p.score) {
                snd = fst;
                fst = p;
                continue;
            }
            if (!(snd.score < p.score)) continue;
            snd = p;
        }
        return new Pair<StringPrediction, StringPrediction>(fst, snd);
    }

    public List<StringPrediction> predictAll(SparseFeatureVector x) {
        List<StringPrediction> list = this.getPredictions(x);
        Collections.sort(list);
        return list;
    }

    public List<StringPrediction> getPredictions(SparseFeatureVector x) {
        ArrayList<StringPrediction> list = new ArrayList<StringPrediction>(this.n_labels);
        double[] scores = this.getScores(x);
        for (int i = 0; i < this.n_labels; ++i) {
            list.add(new StringPrediction(this.a_labels[i], scores[i]));
        }
        return list;
    }

    public List<IntPrediction> getIntPredictions(SparseFeatureVector x) {
        ArrayList<IntPrediction> list = new ArrayList<IntPrediction>(this.n_labels);
        double[] scores = this.getScores(x);
        for (int i = 0; i < this.n_labels; ++i) {
            list.add(new IntPrediction(i, scores[i]));
        }
        return list;
    }

    public static String getBooleanLabel(boolean b) {
        return b ? LABEL_TRUE : LABEL_FALSE;
    }

    public static boolean toBoolean(String label) {
        return label.equals(LABEL_TRUE);
    }
}

