/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav4;

import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.GenericURLFileName;
import org.apache.commons.vfs2.util.URIUtils;

public class Webdav4FileName
extends GenericURLFileName {
    private static final int BUFFER_SIZE = 250;
    private final boolean appendTrailingSlash;

    public Webdav4FileName(String scheme, String hostName, int port, int defaultPort, String userName, String password, String path, FileType type, String queryString) {
        this(scheme, hostName, port, defaultPort, userName, password, path, type, queryString, false);
    }

    public Webdav4FileName(String scheme, String hostName, int port, int defaultPort, String userName, String password, String path, FileType type, String queryString, boolean appendTrailingSlash) {
        super(scheme, hostName, port, defaultPort, userName, password, path, type, queryString);
        this.appendTrailingSlash = appendTrailingSlash;
    }

    public String getPathQueryEncoded(String charset) throws FileSystemException {
        String pathDecoded = this.getPathDecoded();
        if (this.appendTrailingSlash && this.getType() == FileType.FOLDER && this.getPath().length() > 1) {
            pathDecoded = pathDecoded + "/";
        }
        if (this.getQueryString() == null || this.getQueryString().isEmpty()) {
            if (charset != null) {
                return URIUtils.encodePath((String)pathDecoded, (String)charset);
            }
            return URIUtils.encodePath((String)pathDecoded);
        }
        StringBuilder sb = new StringBuilder(250);
        if (charset != null) {
            sb.append(URIUtils.encodePath((String)pathDecoded, (String)charset));
        } else {
            sb.append(URIUtils.encodePath((String)pathDecoded));
        }
        sb.append("?");
        sb.append(this.getQueryString());
        return sb.toString();
    }
}

