/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileObjectUtilsTest {
    private void assertProperties(Properties p) {
        Assertions.assertNotNull((Object)p);
        Assertions.assertEquals((Object)"1", (Object)p.getProperty("one"));
        Assertions.assertEquals((Object)"2", (Object)p.getProperty("two"));
    }

    @Test
    public void testExistsNotNull() throws FileSystemException {
        Assertions.assertTrue((boolean)FileObjectUtils.exists((FileObject)VFS.getManager().toFileObject(SystemUtils.getJavaIoTmpDir())));
    }

    @Test
    public void testgetContentAsStringCharset() throws IOException {
        Assertions.assertEquals((Object)"This is a test file.", (Object)FileObjectUtils.getContentAsString((FileObject)VFS.getManager().toFileObject(new File("src/test/resources/test-data/read-tests/file1.txt")), (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void testgetContentAsStringCharsetNull() throws IOException {
        Assertions.assertEquals((Object)"This is a test file.", (Object)FileObjectUtils.getContentAsString((FileObject)VFS.getManager().toFileObject(new File("src/test/resources/test-data/read-tests/file1.txt")), (Charset)null));
    }

    @Test
    public void testgetContentAsStringString() throws IOException {
        Assertions.assertEquals((Object)"This is a test file.", (Object)FileObjectUtils.getContentAsString((FileObject)VFS.getManager().toFileObject(new File("src/test/resources/test-data/read-tests/file1.txt")), (String)StandardCharsets.UTF_8.name()));
    }

    @Test
    public void testgetContentAsStringStringNull() throws IOException {
        Assertions.assertEquals((Object)"This is a test file.", (Object)FileObjectUtils.getContentAsString((FileObject)VFS.getManager().toFileObject(new File("src/test/resources/test-data/read-tests/file1.txt")), (String)null));
    }

    @Test
    public void testNotExistsNotNull() throws FileSystemException {
        Assertions.assertFalse((boolean)FileObjectUtils.exists((FileObject)VFS.getManager().toFileObject(new File("This file can't possibly exist, right?"))));
    }

    @Test
    public void testNotExistsNull() throws FileSystemException {
        Assertions.assertFalse((boolean)FileObjectUtils.exists(null));
    }

    @Test
    public void testReadProperties() throws FileSystemException, IOException {
        this.assertProperties(FileObjectUtils.readProperties((FileObject)VFS.getManager().toFileObject(new File("src/test/resources/test.properties"))));
    }

    @Test
    public void testReadPropertiesInto() throws IOException {
        Properties p = new Properties();
        p.setProperty("extraKey", "extraValue");
        this.assertProperties(FileObjectUtils.readProperties((FileObject)VFS.getManager().toFileObject(new File("src/test/resources/test.properties")), (Properties)p));
        Assertions.assertEquals((Object)"extraValue", (Object)p.getProperty("extraKey"));
    }
}

