/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.commons.vfs2.provider.http5.Http5FileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.TrustEveryoneUserInfo;
import org.apache.commons.vfs2.util.DelegatingFileSystemOptionsBuilder;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DelegatingFileSystemOptionsBuilderTest {
    private static final String[] schemes = new String[]{"http", "ftp", "file", "zip", "tar", "tgz", "bz2", "gz", "jar", "tmp", "ram"};
    private StandardFileSystemManager fsm;

    @BeforeEach
    public void setUp() throws Exception {
        this.fsm = new StandardFileSystemManager();
        this.fsm.init();
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.fsm != null) {
            this.fsm.close();
        }
    }

    @Test
    public void testConfiguration() throws Exception {
        for (String scheme : schemes) {
            Assertions.assertTrue((boolean)this.fsm.hasProvider(scheme), () -> "Missing " + scheme + " provider");
        }
    }

    @Test
    public void testDelegatingBad() throws Throwable {
        FileSystemOptions opts = new FileSystemOptions();
        DelegatingFileSystemOptionsBuilder delegate = new DelegatingFileSystemOptionsBuilder((FileSystemManager)this.fsm);
        try {
            delegate.setConfigString(opts, "http", "proxyPort", "wrong_port");
            Assertions.fail();
        }
        catch (FileSystemException e) {
            Assertions.assertSame(e.getCause().getClass(), InvocationTargetException.class);
            Assertions.assertSame(((InvocationTargetException)e.getCause()).getTargetException().getClass(), NumberFormatException.class);
        }
        try {
            delegate.setConfigClass(opts, "sftp", "userinfo", String.class);
            Assertions.fail();
        }
        catch (FileSystemException e) {
            Assertions.assertEquals((Object)e.getCode(), (Object)"vfs.provider/config-value-invalid.error");
        }
    }

    @Test
    public void testDelegatingGood() throws Throwable {
        String[] identityPaths = new String[]{"/file1", "/file2"};
        FileSystemOptions opts = new FileSystemOptions();
        DelegatingFileSystemOptionsBuilder delegate = new DelegatingFileSystemOptionsBuilder((FileSystemManager)this.fsm);
        delegate.setConfigString(opts, "http", "proxyHost", "proxy");
        delegate.setConfigString(opts, "http", "proxyPort", "8080");
        delegate.setConfigClass(opts, "sftp", "userinfo", TrustEveryoneUserInfo.class);
        delegate.setConfigStrings(opts, "sftp", "identities", identityPaths);
        Assertions.assertEquals((Object)Http5FileSystemConfigBuilder.getInstance().getProxyHost(opts), (Object)"proxy", (String)"http.proxyHost");
        Assertions.assertEquals((int)Http5FileSystemConfigBuilder.getInstance().getProxyPort(opts), (int)8080, (String)"http.proxyPort");
        Assertions.assertSame((Object)SftpFileSystemConfigBuilder.getInstance().getUserInfo(opts).getClass(), TrustEveryoneUserInfo.class, (String)"sftp.userInfo");
        File[] identities = SftpFileSystemConfigBuilder.getInstance().getIdentities(opts);
        Assertions.assertNotNull((Object)identities, (String)"sftp.identities");
        Assertions.assertEquals((int)identities.length, (int)identityPaths.length, (String)"sftp.identities size");
        for (int iterIdentities = 0; iterIdentities < identities.length; ++iterIdentities) {
            Assertions.assertEquals((Object)identities[iterIdentities].getAbsolutePath(), (Object)new File(identityPaths[iterIdentities]).getAbsolutePath(), (String)("sftp.identities #" + iterIdentities));
        }
    }
}

