/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.IOException;
import java.time.Instant;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.LastModifiedTests;
import org.apache.commons.vfs2.provider.ftp.FtpClient;
import org.apache.commons.vfs2.provider.ftp.FtpFileObject;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystem;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.mockito.Mockito;

public class FtpMdtmOnRefreshLastModifiedTests
extends LastModifiedTests {
    private void returnsCorrectMdtmValue(FtpFileObject fileObject) throws IOException {
        String relPath = fileObject.getRelPath();
        FtpClient ftpClient = this.spyClient(fileObject);
        long expected = ThreadLocalRandom.current().nextLong(Instant.now().toEpochMilli());
        Mockito.when((Object)ftpClient.mdtmInstant(relPath)).thenReturn((Object)Instant.ofEpochMilli(expected));
        long lastModTIme = fileObject.getContent().getLastModifiedTime();
        if (expected != lastModTIme) {
            Assertions.fail((String)String.format("%s returned epoch %s not expected: %s.", FtpFileObject.class.getSimpleName(), lastModTIme, expected));
        }
    }

    private FtpClient spyClient(FtpFileObject fileObject) throws FileSystemException {
        FtpFileSystem fileSystem = (FtpFileSystem)fileObject.getFileSystem();
        FtpClient ftpClientSpy = (FtpClient)Mockito.spy((Object)fileSystem.getClient());
        fileSystem.putClient(ftpClientSpy);
        return ftpClientSpy;
    }

    @Test
    public void testGetLastModifiedFileExactMatchRefresh() throws IOException {
        String fileName = "file1.txt";
        FileObject readFolder = this.getReadFolder();
        FtpFileObject fileObject = (FtpFileObject)readFolder.resolveFile("file1.txt");
        this.returnsCorrectMdtmValue(fileObject);
        fileObject.refresh();
        this.returnsCorrectMdtmValue(fileObject);
    }
}

