/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.EndianUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class EndianUtilsTest {
    EndianUtilsTest() {
    }

    @Test
    void testCtor() {
        new EndianUtils();
    }

    @Test
    void testEOFException() {
        ByteArrayInputStream input = new ByteArrayInputStream(new byte[0]);
        Assertions.assertThrows(EOFException.class, () -> EndianUtils.readSwappedDouble((InputStream)input));
    }

    @Test
    void testInvalidOffset() {
        byte[] bytes = new byte[]{};
        Assertions.assertThrows(IllegalArgumentException.class, () -> EndianUtils.readSwappedInteger((byte[])bytes, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EndianUtils.readSwappedLong((byte[])bytes, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EndianUtils.readSwappedShort((byte[])bytes, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EndianUtils.readSwappedUnsignedInteger((byte[])bytes, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EndianUtils.readSwappedUnsignedShort((byte[])bytes, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EndianUtils.writeSwappedInteger((byte[])bytes, (int)0, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EndianUtils.writeSwappedLong((byte[])bytes, (int)0, (long)0L));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EndianUtils.writeSwappedShort((byte[])bytes, (int)0, (short)0));
    }

    @Test
    void testReadSwappedDouble() throws IOException {
        byte[] bytes = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        double d1 = Double.longBitsToDouble(72623859790382856L);
        double d2 = EndianUtils.readSwappedDouble((byte[])bytes, (int)0);
        Assertions.assertEquals((double)d1, (double)d2, (double)0.0);
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assertions.assertEquals((double)d1, (double)EndianUtils.readSwappedDouble((InputStream)input), (double)0.0);
    }

    @Test
    void testReadSwappedFloat() throws IOException {
        byte[] bytes = new byte[]{4, 3, 2, 1};
        float f1 = Float.intBitsToFloat(16909060);
        float f2 = EndianUtils.readSwappedFloat((byte[])bytes, (int)0);
        Assertions.assertEquals((double)f1, (double)f2, (double)0.0);
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assertions.assertEquals((double)f1, (double)EndianUtils.readSwappedFloat((InputStream)input), (double)0.0);
    }

    @Test
    void testReadSwappedInteger() throws IOException {
        byte[] bytes = new byte[]{4, 3, 2, 1};
        Assertions.assertEquals((int)16909060, (int)EndianUtils.readSwappedInteger((byte[])bytes, (int)0));
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assertions.assertEquals((int)16909060, (int)EndianUtils.readSwappedInteger((InputStream)input));
    }

    @Test
    void testReadSwappedLong() throws IOException {
        byte[] bytes = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        Assertions.assertEquals((long)72623859790382856L, (long)EndianUtils.readSwappedLong((byte[])bytes, (int)0));
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assertions.assertEquals((long)72623859790382856L, (long)EndianUtils.readSwappedLong((InputStream)input));
    }

    @Test
    void testReadSwappedShort() throws IOException {
        byte[] bytes = new byte[]{2, 1};
        Assertions.assertEquals((int)258, (int)EndianUtils.readSwappedShort((byte[])bytes, (int)0));
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assertions.assertEquals((int)258, (int)EndianUtils.readSwappedShort((InputStream)input));
    }

    @Test
    void testReadSwappedUnsignedInteger() throws IOException {
        byte[] bytes = new byte[]{4, 3, 2, 1};
        Assertions.assertEquals((long)16909060L, (long)EndianUtils.readSwappedUnsignedInteger((byte[])bytes, (int)0));
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assertions.assertEquals((long)16909060L, (long)EndianUtils.readSwappedUnsignedInteger((InputStream)input));
    }

    @Test
    void testReadSwappedUnsignedShort() throws IOException {
        byte[] bytes = new byte[]{2, 1};
        Assertions.assertEquals((int)258, (int)EndianUtils.readSwappedUnsignedShort((byte[])bytes, (int)0));
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assertions.assertEquals((int)258, (int)EndianUtils.readSwappedUnsignedShort((InputStream)input));
    }

    @Test
    void testSwapDouble() {
        Assertions.assertEquals((double)0.0, (double)EndianUtils.swapDouble((double)0.0), (double)0.0);
        double d1 = Double.longBitsToDouble(72623859790382856L);
        double d2 = Double.longBitsToDouble(578437695752307201L);
        Assertions.assertEquals((double)d2, (double)EndianUtils.swapDouble((double)d1), (double)0.0);
    }

    @Test
    void testSwapFloat() {
        Assertions.assertEquals((double)0.0, (double)EndianUtils.swapFloat((float)0.0f), (double)0.0);
        float f1 = Float.intBitsToFloat(16909060);
        float f2 = Float.intBitsToFloat(67305985);
        Assertions.assertEquals((double)f2, (double)EndianUtils.swapFloat((float)f1), (double)0.0);
    }

    @Test
    void testSwapInteger() {
        Assertions.assertEquals((int)0, (int)EndianUtils.swapInteger((int)0));
        Assertions.assertEquals((int)67305985, (int)EndianUtils.swapInteger((int)16909060));
        Assertions.assertEquals((int)0x1000000, (int)EndianUtils.swapInteger((int)1));
        Assertions.assertEquals((int)1, (int)EndianUtils.swapInteger((int)0x1000000));
        Assertions.assertEquals((int)0x11111111, (int)EndianUtils.swapInteger((int)0x11111111));
        Assertions.assertEquals((int)-1412567280, (int)EndianUtils.swapInteger((int)284151211));
        Assertions.assertEquals((int)171, (int)EndianUtils.swapInteger((int)-1426063360));
    }

    @Test
    void testSwapLong() {
        Assertions.assertEquals((long)0L, (long)EndianUtils.swapLong((long)0L));
        Assertions.assertEquals((long)578437695752307201L, (long)EndianUtils.swapLong((long)72623859790382856L));
        Assertions.assertEquals((long)-1L, (long)EndianUtils.swapLong((long)-1L));
        Assertions.assertEquals((long)171L, (long)EndianUtils.swapLong((long)-6124895493223874560L));
    }

    @Test
    void testSwapShort() {
        Assertions.assertEquals((short)0, (short)EndianUtils.swapShort((short)0));
        Assertions.assertEquals((short)513, (short)EndianUtils.swapShort((short)258));
        Assertions.assertEquals((short)-1, (short)EndianUtils.swapShort((short)-1));
        Assertions.assertEquals((short)258, (short)EndianUtils.swapShort((short)513));
    }

    @Test
    void testSymmetry() {
        Assertions.assertEquals((short)258, (short)EndianUtils.swapShort((short)EndianUtils.swapShort((short)258)));
        Assertions.assertEquals((int)16909060, (int)EndianUtils.swapInteger((int)EndianUtils.swapInteger((int)16909060)));
        Assertions.assertEquals((long)72623859790382856L, (long)EndianUtils.swapLong((long)EndianUtils.swapLong((long)72623859790382856L)));
        float f1 = Float.intBitsToFloat(16909060);
        Assertions.assertEquals((double)f1, (double)EndianUtils.swapFloat((float)EndianUtils.swapFloat((float)f1)), (double)0.0);
        double d1 = Double.longBitsToDouble(72623859790382856L);
        Assertions.assertEquals((double)d1, (double)EndianUtils.swapDouble((double)EndianUtils.swapDouble((double)d1)), (double)0.0);
    }

    @Test
    void testSymmetryOfLong() {
        double[] tests;
        for (double test : tests = new double[]{34.345, -345.5645, 545.12, 10.043, 7.123456789123}) {
            byte[] buffer = new byte[8];
            long ln1 = Double.doubleToLongBits(test);
            EndianUtils.writeSwappedLong((byte[])buffer, (int)0, (long)ln1);
            long ln2 = EndianUtils.readSwappedLong((byte[])buffer, (int)0);
            Assertions.assertEquals((long)ln1, (long)ln2);
            buffer = new byte[8];
            EndianUtils.writeSwappedDouble((byte[])buffer, (int)0, (double)test);
            double val = EndianUtils.readSwappedDouble((byte[])buffer, (int)0);
            Assertions.assertEquals((double)test, (double)val, (double)0.0);
        }
    }

    @Test
    void testUnsignedOverrun() throws Exception {
        byte[] target = new byte[]{0, 0, 0, -128};
        long expected = 0x80000000L;
        long actual = EndianUtils.readSwappedUnsignedInteger((byte[])target, (int)0);
        Assertions.assertEquals((long)0x80000000L, (long)actual, (String)"readSwappedUnsignedInteger(byte[], int) was incorrect");
        ByteArrayInputStream in = new ByteArrayInputStream(target);
        actual = EndianUtils.readSwappedUnsignedInteger((InputStream)in);
        Assertions.assertEquals((long)0x80000000L, (long)actual, (String)"readSwappedUnsignedInteger(InputStream) was incorrect");
    }

    @Test
    void testWriteSwappedDouble() throws IOException {
        byte[] bytes = new byte[8];
        double d1 = Double.longBitsToDouble(72623859790382856L);
        EndianUtils.writeSwappedDouble((byte[])bytes, (int)0, (double)d1);
        Assertions.assertEquals((int)8, (int)bytes[0]);
        Assertions.assertEquals((int)7, (int)bytes[1]);
        Assertions.assertEquals((int)6, (int)bytes[2]);
        Assertions.assertEquals((int)5, (int)bytes[3]);
        Assertions.assertEquals((int)4, (int)bytes[4]);
        Assertions.assertEquals((int)3, (int)bytes[5]);
        Assertions.assertEquals((int)2, (int)bytes[6]);
        Assertions.assertEquals((int)1, (int)bytes[7]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8);
        EndianUtils.writeSwappedDouble((OutputStream)baos, (double)d1);
        bytes = baos.toByteArray();
        Assertions.assertEquals((int)8, (int)bytes[0]);
        Assertions.assertEquals((int)7, (int)bytes[1]);
        Assertions.assertEquals((int)6, (int)bytes[2]);
        Assertions.assertEquals((int)5, (int)bytes[3]);
        Assertions.assertEquals((int)4, (int)bytes[4]);
        Assertions.assertEquals((int)3, (int)bytes[5]);
        Assertions.assertEquals((int)2, (int)bytes[6]);
        Assertions.assertEquals((int)1, (int)bytes[7]);
    }

    @Test
    void testWriteSwappedFloat() throws IOException {
        byte[] bytes = new byte[4];
        float f1 = Float.intBitsToFloat(16909060);
        EndianUtils.writeSwappedFloat((byte[])bytes, (int)0, (float)f1);
        Assertions.assertEquals((int)4, (int)bytes[0]);
        Assertions.assertEquals((int)3, (int)bytes[1]);
        Assertions.assertEquals((int)2, (int)bytes[2]);
        Assertions.assertEquals((int)1, (int)bytes[3]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        EndianUtils.writeSwappedFloat((OutputStream)baos, (float)f1);
        bytes = baos.toByteArray();
        Assertions.assertEquals((int)4, (int)bytes[0]);
        Assertions.assertEquals((int)3, (int)bytes[1]);
        Assertions.assertEquals((int)2, (int)bytes[2]);
        Assertions.assertEquals((int)1, (int)bytes[3]);
    }

    @Test
    void testWriteSwappedInteger() throws IOException {
        byte[] bytes = new byte[4];
        EndianUtils.writeSwappedInteger((byte[])bytes, (int)0, (int)16909060);
        Assertions.assertEquals((int)4, (int)bytes[0]);
        Assertions.assertEquals((int)3, (int)bytes[1]);
        Assertions.assertEquals((int)2, (int)bytes[2]);
        Assertions.assertEquals((int)1, (int)bytes[3]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        EndianUtils.writeSwappedInteger((OutputStream)baos, (int)16909060);
        bytes = baos.toByteArray();
        Assertions.assertEquals((int)4, (int)bytes[0]);
        Assertions.assertEquals((int)3, (int)bytes[1]);
        Assertions.assertEquals((int)2, (int)bytes[2]);
        Assertions.assertEquals((int)1, (int)bytes[3]);
    }

    @Test
    void testWriteSwappedLong() throws IOException {
        byte[] bytes = new byte[8];
        EndianUtils.writeSwappedLong((byte[])bytes, (int)0, (long)72623859790382856L);
        Assertions.assertEquals((int)8, (int)bytes[0]);
        Assertions.assertEquals((int)7, (int)bytes[1]);
        Assertions.assertEquals((int)6, (int)bytes[2]);
        Assertions.assertEquals((int)5, (int)bytes[3]);
        Assertions.assertEquals((int)4, (int)bytes[4]);
        Assertions.assertEquals((int)3, (int)bytes[5]);
        Assertions.assertEquals((int)2, (int)bytes[6]);
        Assertions.assertEquals((int)1, (int)bytes[7]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8);
        EndianUtils.writeSwappedLong((OutputStream)baos, (long)72623859790382856L);
        bytes = baos.toByteArray();
        Assertions.assertEquals((int)8, (int)bytes[0]);
        Assertions.assertEquals((int)7, (int)bytes[1]);
        Assertions.assertEquals((int)6, (int)bytes[2]);
        Assertions.assertEquals((int)5, (int)bytes[3]);
        Assertions.assertEquals((int)4, (int)bytes[4]);
        Assertions.assertEquals((int)3, (int)bytes[5]);
        Assertions.assertEquals((int)2, (int)bytes[6]);
        Assertions.assertEquals((int)1, (int)bytes[7]);
    }

    @Test
    void testWriteSwappedShort() throws IOException {
        byte[] bytes = new byte[2];
        EndianUtils.writeSwappedShort((byte[])bytes, (int)0, (short)258);
        Assertions.assertEquals((int)2, (int)bytes[0]);
        Assertions.assertEquals((int)1, (int)bytes[1]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2);
        EndianUtils.writeSwappedShort((OutputStream)baos, (short)258);
        bytes = baos.toByteArray();
        Assertions.assertEquals((int)2, (int)bytes[0]);
        Assertions.assertEquals((int)1, (int)bytes[1]);
    }
}

