/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.decoder;

import org.apache.commons.imaging.formats.jpeg.decoder.Dct;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DctTest {
    private static double[] REFERENCE_forwardDCT(float[] vector) {
        double[] ret = new double[8];
        for (int u = 0; u < 8; ++u) {
            double sum = 0.0;
            float cu = u == 0 ? (float)(1.0 / Math.sqrt(2.0)) : 1.0f;
            for (int x = 0; x < 8; ++x) {
                sum += (double)vector[x] * Math.cos((double)((2 * x + 1) * u) * Math.PI / 16.0);
            }
            ret[u] = (double)(0.5f * cu) * sum;
        }
        return ret;
    }

    private static double[][] REFERENCE_forwardDCT(float[][] matrix) {
        double[][] ret = new double[8][8];
        for (int u = 0; u < 8; ++u) {
            for (int v = 0; v < 8; ++v) {
                double sum = 0.0;
                float cu = u == 0 ? (float)(1.0 / Math.sqrt(2.0)) : 1.0f;
                float cv = v == 0 ? (float)(1.0 / Math.sqrt(2.0)) : 1.0f;
                for (int x = 0; x < 8; ++x) {
                    for (int y = 0; y < 8; ++y) {
                        sum += (double)matrix[y][x] * Math.cos((double)((2 * x + 1) * u) * Math.PI / 16.0) * Math.cos((double)((2 * y + 1) * v) * Math.PI / 16.0);
                    }
                }
                ret[v][u] = (double)(0.25f * cu * cv) * sum;
            }
        }
        return ret;
    }

    private static double[] REFERENCE_inverseDCT(double[] vector) {
        double[] ret = new double[8];
        for (int x = 0; x < 8; ++x) {
            double sum = 0.0;
            for (int u = 0; u < 8; ++u) {
                float cu = u == 0 ? (float)(1.0 / Math.sqrt(2.0)) : 1.0f;
                sum += (double)cu * vector[u] * Math.cos((double)((2 * x + 1) * u) * Math.PI / 16.0);
            }
            ret[x] = 0.5 * sum;
        }
        return ret;
    }

    private static double[][] REFERENCE_inverseDCT(double[][] matrix) {
        double[][] ret = new double[8][8];
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 8; ++x) {
                double sum = 0.0;
                for (int u = 0; u < 8; ++u) {
                    for (int v = 0; v < 8; ++v) {
                        float cu = u == 0 ? (float)(1.0 / Math.sqrt(2.0)) : 1.0f;
                        float cv = v == 0 ? (float)(1.0 / Math.sqrt(2.0)) : 1.0f;
                        sum += (double)(cu * cv) * matrix[v][u] * Math.cos((double)((2 * x + 1) * u) * Math.PI / 16.0) * Math.cos((double)((2 * y + 1) * v) * Math.PI / 16.0);
                    }
                }
                ret[y][x] = 0.25 * sum;
            }
        }
        return ret;
    }

    @Test
    public void testMatrices() {
        int x;
        int y;
        float[] originalData = new float[64];
        float[][] originalData8x8 = new float[8][8];
        for (int y2 = 0; y2 < 8; ++y2) {
            for (int x2 = 0; x2 < 8; ++x2) {
                float value;
                originalData8x8[y2][x2] = value = (float)(8 * y2 + x2);
                originalData[8 * y2 + x2] = value;
            }
        }
        double[][] transformed8x8 = DctTest.REFERENCE_forwardDCT(originalData8x8);
        double[][] reversed8x8 = DctTest.REFERENCE_inverseDCT(transformed8x8);
        for (int y3 = 0; y3 < 8; ++y3) {
            for (int x3 = 0; x3 < 8; ++x3) {
                Assertions.assertEquals((double)originalData8x8[y3][x3], (double)reversed8x8[y3][x3], (double)0.001);
            }
        }
        float[] data = (float[])originalData.clone();
        Dct.forwardDct8x8((float[])data);
        Dct.scaleQuantizationMatrix((float[])data);
        for (y = 0; y < 8; ++y) {
            for (x = 0; x < 8; ++x) {
                Assertions.assertEquals((double)transformed8x8[y][x], (double)data[8 * y + x], (double)0.001);
            }
        }
        Dct.scaleDequantizationMatrix((float[])data);
        Dct.inverseDct8x8((float[])data);
        for (y = 0; y < 8; ++y) {
            for (x = 0; x < 8; ++x) {
                Assertions.assertEquals((double)originalData8x8[y][x], (double)data[8 * y + x], (double)0.001);
            }
        }
    }

    @Test
    public void testVectors() {
        int i;
        float[] originalData = new float[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            originalData[i2] = i2;
        }
        double[] transformed = DctTest.REFERENCE_forwardDCT(originalData);
        double[] reversed = DctTest.REFERENCE_inverseDCT(transformed);
        for (int i3 = 0; i3 < 8; ++i3) {
            Assertions.assertEquals((double)originalData[i3], (double)reversed[i3], (double)0.001);
        }
        float[] data = (float[])originalData.clone();
        Dct.forwardDct8((float[])data);
        Dct.scaleQuantizationVector((float[])data);
        for (i = 0; i < 8; ++i) {
            Assertions.assertEquals((double)data[i], (double)transformed[i], (double)0.001);
        }
        Dct.scaleDequantizationVector((float[])data);
        Dct.inverseDct8((float[])data);
        for (i = 0; i < 8; ++i) {
            Assertions.assertEquals((double)data[i], (double)originalData[i], (double)0.001);
        }
    }
}

