/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ImageInfoTest {
    @Test
    public void testColorType() {
        Assertions.assertEquals((Object)"RGB", (Object)ImageInfo.ColorType.RGB.toString());
        Assertions.assertEquals((Object)ImageInfo.ColorType.RGB, (Object)ImageInfo.ColorType.valueOf((String)"RGB"));
    }

    @Test
    public void testCompressionAlgorithm() {
        Assertions.assertEquals((Object)"LZW", (Object)ImageInfo.CompressionAlgorithm.LZW.toString());
        Assertions.assertEquals((Object)ImageInfo.CompressionAlgorithm.LZW, (Object)ImageInfo.CompressionAlgorithm.valueOf((String)"LZW"));
    }

    @Test
    public void testImageInfo() {
        String formatDetails = "image-info-format-details";
        int bitsPerPixel = 2;
        List<String> comments = Arrays.asList("a", "b", "c");
        ImageFormats format = ImageFormats.BMP;
        String formatName = format.getName();
        int height = 2;
        String mimeType = "image-info-mimetype";
        int numberOfImages = 2;
        int physicalHeightDpi = 2;
        float physicalHeightInch = 2.0f;
        int physicalWidthDpi = 2;
        float physicalWidthInch = 2.0f;
        int width = 2;
        boolean progressive = true;
        boolean transparent = true;
        boolean usesPalette = true;
        ImageInfo.ColorType colorType = ImageInfo.ColorType.GRAYSCALE;
        ImageInfo.CompressionAlgorithm compressionAlgorithm = ImageInfo.CompressionAlgorithm.JPEG;
        ImageInfo imageInfo = new ImageInfo("image-info-format-details", 2, comments, (ImageFormat)format, formatName, 2, "image-info-mimetype", 2, 2, 2.0f, 2, 2.0f, 2, true, true, true, colorType, compressionAlgorithm);
        Assertions.assertEquals((Object)"image-info-format-details", (Object)imageInfo.getFormatDetails());
        Assertions.assertEquals((int)2, (int)imageInfo.getBitsPerPixel());
        Assertions.assertEquals((Object)comments.toString(), (Object)imageInfo.getComments().toString());
        Assertions.assertEquals((Object)format, (Object)imageInfo.getFormat());
        Assertions.assertEquals((Object)formatName, (Object)imageInfo.getFormatName());
        Assertions.assertEquals((int)2, (int)imageInfo.getHeight());
        Assertions.assertEquals((Object)"image-info-mimetype", (Object)imageInfo.getMimeType());
        Assertions.assertEquals((int)2, (int)imageInfo.getNumberOfImages());
        Assertions.assertEquals((int)2, (int)imageInfo.getPhysicalHeightDpi());
        Assertions.assertEquals((float)2.0f, (float)imageInfo.getPhysicalHeightInch());
        Assertions.assertEquals((int)2, (int)imageInfo.getPhysicalWidthDpi());
        Assertions.assertEquals((float)2.0f, (float)imageInfo.getPhysicalWidthInch());
        Assertions.assertEquals((int)2, (int)imageInfo.getWidth());
        Assertions.assertEquals((Object)true, (Object)imageInfo.isProgressive());
        Assertions.assertEquals((Object)true, (Object)imageInfo.isTransparent());
        Assertions.assertEquals((Object)true, (Object)imageInfo.usesPalette());
        Assertions.assertEquals((Object)colorType, (Object)imageInfo.getColorType());
        Assertions.assertEquals((Object)compressionAlgorithm, (Object)imageInfo.getCompressionAlgorithm());
    }

    @Test
    public void testToStringEmptyComments() {
        ImageInfo imageInfo = new ImageInfo(null, 0, new ArrayList(), (ImageFormat)ImageFormats.DCX, null, 0, null, 0, 0, 0.0f, 0, 0.0f, 0, false, false, false, ImageInfo.ColorType.BW, null);
        String expected = "Format Details: null\nBits Per Pixel: 0\nComments: 0\nFormat: DCX\nFormat Name: null\nCompression Algorithm: null\nHeight: 0\nMimeType: null\nNumber Of Images: 0\nPhysical Height Dpi: 0\nPhysical Height Inch: 0.0\nPhysical Width Dpi: 0\nPhysical Width Inch: 0.0\nWidth: 0\nIs Progressive: false\nIs Transparent: false\nColor Type: Black and White\nUses Palette: false\n";
        String testString = imageInfo.toString().replaceAll("\\r", "");
        Assertions.assertEquals((Object)"Format Details: null\nBits Per Pixel: 0\nComments: 0\nFormat: DCX\nFormat Name: null\nCompression Algorithm: null\nHeight: 0\nMimeType: null\nNumber Of Images: 0\nPhysical Height Dpi: 0\nPhysical Height Inch: 0.0\nPhysical Width Dpi: 0\nPhysical Width Inch: 0.0\nWidth: 0\nIs Progressive: false\nIs Transparent: false\nColor Type: Black and White\nUses Palette: false\n", (Object)testString);
    }

    @Test
    public void testToStringErrorWhenColorPaletteIsNull() {
        ImageInfo imageInfo = new ImageInfo(null, 0, new ArrayList(), (ImageFormat)ImageFormats.DCX, null, 0, null, 0, 0, 0.0f, 0, 0.0f, 0, false, false, false, null, null);
        Assertions.assertEquals((Object)"Image Data: Error", (Object)imageInfo.toString());
    }

    @Test
    public void testToStringErrorWhenCommentsIsNull() {
        ImageInfo imageInfo = new ImageInfo(null, 0, null, null, null, 0, null, 0, 0, 0.0f, 0, 0.0f, 0, false, false, false, null, null);
        Assertions.assertEquals((Object)"Image Data: Error", (Object)imageInfo.toString());
    }

    @Test
    public void testToStringErrorWhenFormatIsNull() {
        ImageInfo imageInfo = new ImageInfo(null, 0, new ArrayList(), null, null, 0, null, 0, 0, 0.0f, 0, 0.0f, 0, false, false, false, ImageInfo.ColorType.BW, null);
        Assertions.assertEquals((Object)"Image Data: Error", (Object)imageInfo.toString());
    }

    @Test
    public void testToStringWithComments() {
        ImageInfo imageInfo = new ImageInfo(null, 0, Arrays.asList("a", "b"), (ImageFormat)ImageFormats.DCX, null, 0, null, 0, 0, 0.0f, 0, 0.0f, 0, false, false, false, ImageInfo.ColorType.BW, null);
        String expected = "Format Details: null\nBits Per Pixel: 0\nComments: 2\n\t0: 'a'\n\t1: 'b'\nFormat: DCX\nFormat Name: null\nCompression Algorithm: null\nHeight: 0\nMimeType: null\nNumber Of Images: 0\nPhysical Height Dpi: 0\nPhysical Height Inch: 0.0\nPhysical Width Dpi: 0\nPhysical Width Inch: 0.0\nWidth: 0\nIs Progressive: false\nIs Transparent: false\nColor Type: Black and White\nUses Palette: false\n";
        String testString = imageInfo.toString().replaceAll("\\r", "");
        Assertions.assertEquals((Object)"Format Details: null\nBits Per Pixel: 0\nComments: 2\n\t0: 'a'\n\t1: 'b'\nFormat: DCX\nFormat Name: null\nCompression Algorithm: null\nHeight: 0\nMimeType: null\nNumber Of Images: 0\nPhysical Height Dpi: 0\nPhysical Height Inch: 0.0\nPhysical Width Dpi: 0\nPhysical Width Inch: 0.0\nWidth: 0\nIs Progressive: false\nIs Transparent: false\nColor Type: Black and White\nUses Palette: false\n", (Object)testString);
    }
}

