/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.core.partitioning;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.geometry.core.Point;
import org.apache.commons.geometry.core.RegionLocation;
import org.apache.commons.geometry.core.Transform;
import org.apache.commons.geometry.core.partitioning.Hyperplane;
import org.apache.commons.geometry.core.partitioning.HyperplaneBoundedRegion;
import org.apache.commons.geometry.core.partitioning.HyperplaneConvexSubset;
import org.apache.commons.geometry.core.partitioning.HyperplaneLocation;
import org.apache.commons.geometry.core.partitioning.HyperplaneSubset;
import org.apache.commons.geometry.core.partitioning.Split;
import org.apache.commons.geometry.core.partitioning.SplitLocation;

public abstract class AbstractConvexHyperplaneBoundedRegion<P extends Point<P>, S extends HyperplaneConvexSubset<P>>
implements HyperplaneBoundedRegion<P> {
    private final List<S> boundaries;

    protected AbstractConvexHyperplaneBoundedRegion(List<S> boundaries) {
        this.boundaries = Collections.unmodifiableList(boundaries);
    }

    public List<S> getBoundaries() {
        return this.boundaries;
    }

    @Override
    public boolean isFull() {
        return this.boundaries.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public double getBoundarySize() {
        double sum = 0.0;
        for (HyperplaneConvexSubset boundary : this.boundaries) {
            sum += boundary.getSize();
        }
        return sum;
    }

    @Override
    public RegionLocation classify(P pt) {
        boolean isOn = false;
        for (HyperplaneConvexSubset boundary : this.boundaries) {
            HyperplaneLocation loc = boundary.getHyperplane().classify(pt);
            if (loc == HyperplaneLocation.PLUS) {
                return RegionLocation.OUTSIDE;
            }
            if (loc != HyperplaneLocation.ON) continue;
            isOn = true;
        }
        return isOn ? RegionLocation.BOUNDARY : RegionLocation.INSIDE;
    }

    @Override
    public P project(P pt) {
        P closestPt = null;
        double closestDist = Double.POSITIVE_INFINITY;
        for (HyperplaneConvexSubset boundary : this.boundaries) {
            P projected = boundary.closest(pt);
            double dist = pt.distance(projected);
            if (projected == null || closestPt != null && !(dist < closestDist)) continue;
            closestPt = projected;
            closestDist = dist;
        }
        return closestPt;
    }

    public HyperplaneConvexSubset<P> trim(HyperplaneConvexSubset<P> sub) {
        HyperplaneConvexSubset boundary;
        HyperplaneConvexSubset remaining = sub;
        Iterator<S> iterator = this.boundaries.iterator();
        while (iterator.hasNext() && (remaining = remaining.split((boundary = (HyperplaneConvexSubset)iterator.next()).getHyperplane()).getMinus()) != null) {
        }
        return remaining;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[boundaries= ").append(this.boundaries).append(']');
        return sb.toString();
    }

    protected <R extends AbstractConvexHyperplaneBoundedRegion<P, S>> R transformInternal(Transform<P> transform, R thisInstance, Class<S> boundaryType, Function<? super List<S>, R> factory) {
        if (this.isFull()) {
            return thisInstance;
        }
        List<S> origBoundaries = this.getBoundaries();
        int size = origBoundaries.size();
        ArrayList<S> tBoundaries = new ArrayList<S>(size);
        HyperplaneConvexSubset boundary = (HyperplaneConvexSubset)origBoundaries.get(0);
        HyperplaneSubset tBoundary = boundary.transform((Transform)transform);
        boolean reverseDirection = this.swapsInsideOutside(transform);
        if (reverseDirection) {
            tBoundary = tBoundary.reverse();
        }
        tBoundaries.add(boundaryType.cast(tBoundary));
        for (int i = 1; i < origBoundaries.size(); ++i) {
            tBoundary = ((HyperplaneConvexSubset)origBoundaries.get(i)).transform((Transform)transform);
            if (reverseDirection) {
                tBoundary = tBoundary.reverse();
            }
            tBoundaries.add(boundaryType.cast(tBoundary));
        }
        return (R)((AbstractConvexHyperplaneBoundedRegion)factory.apply(tBoundaries));
    }

    protected boolean swapsInsideOutside(Transform<P> transform) {
        return !transform.preservesOrientation();
    }

    protected <R extends AbstractConvexHyperplaneBoundedRegion<P, S>> Split<R> splitInternal(Hyperplane<P> splitter, R thisInstance, Class<S> boundaryType, Function<List<S>, R> factory) {
        return this.isFull() ? this.splitInternalFull(splitter, boundaryType, factory) : this.splitInternalNonFull(splitter, thisInstance, boundaryType, factory);
    }

    private <R extends AbstractConvexHyperplaneBoundedRegion<P, S>> Split<R> splitInternalFull(Hyperplane<P> splitter, Class<S> boundaryType, Function<? super List<S>, R> factory) {
        AbstractConvexHyperplaneBoundedRegion minus = (AbstractConvexHyperplaneBoundedRegion)factory.apply(Collections.singletonList(boundaryType.cast(splitter.span())));
        AbstractConvexHyperplaneBoundedRegion plus = (AbstractConvexHyperplaneBoundedRegion)factory.apply(Collections.singletonList(boundaryType.cast(splitter.reverse().span())));
        return new Split<AbstractConvexHyperplaneBoundedRegion>(minus, plus);
    }

    private <R extends AbstractConvexHyperplaneBoundedRegion<P, S>> Split<R> splitInternalNonFull(Hyperplane<P> splitter, R thisInstance, Class<S> boundaryType, Function<? super List<S>, R> factory) {
        HyperplaneConvexSubset<P> trimmedSplitter = this.trim(splitter.span());
        if (trimmedSplitter == null) {
            SplitLocation regionLoc = this.determineRegionPlusMinusLocation(splitter);
            return regionLoc == SplitLocation.MINUS ? new Split<Object>(thisInstance, null) : new Split<Object>(null, thisInstance);
        }
        ArrayList<S> minusBoundaries = new ArrayList<S>();
        ArrayList<S> plusBoundaries = new ArrayList<S>();
        this.splitBoundaries(splitter, boundaryType, minusBoundaries, plusBoundaries);
        if (!trimmedSplitter.isFull()) {
            if (minusBoundaries.isEmpty()) {
                if (plusBoundaries.isEmpty()) {
                    return new Split<Object>(null, null);
                }
                return new Split<Object>(null, thisInstance);
            }
            if (plusBoundaries.isEmpty()) {
                return new Split<Object>(thisInstance, null);
            }
        }
        minusBoundaries.add(boundaryType.cast(trimmedSplitter));
        plusBoundaries.add(boundaryType.cast(trimmedSplitter.reverse()));
        minusBoundaries.trimToSize();
        plusBoundaries.trimToSize();
        return new Split<R>(factory.apply(minusBoundaries), factory.apply(plusBoundaries));
    }

    private SplitLocation determineRegionPlusMinusLocation(Hyperplane<P> splitter) {
        double minusSize = 0.0;
        double plusSize = 0.0;
        for (HyperplaneConvexSubset boundary : this.boundaries) {
            Split<HyperplaneConvexSubset<P>> split = boundary.split(splitter);
            SplitLocation loc = split.getLocation();
            if (loc == SplitLocation.MINUS || loc == SplitLocation.PLUS) {
                return loc;
            }
            if (loc == SplitLocation.NEITHER) {
                return splitter.similarOrientation(boundary.getHyperplane()) ? SplitLocation.MINUS : SplitLocation.PLUS;
            }
            minusSize += split.getMinus().getSize();
            plusSize += split.getPlus().getSize();
        }
        return minusSize > plusSize ? SplitLocation.MINUS : SplitLocation.PLUS;
    }

    private void splitBoundaries(Hyperplane<P> splitter, Class<S> boundaryType, List<S> minusBoundaries, List<S> plusBoundaries) {
        for (HyperplaneConvexSubset boundary : this.boundaries) {
            Split<HyperplaneConvexSubset<P>> split = boundary.split(splitter);
            HyperplaneConvexSubset<P> minusBoundary = split.getMinus();
            HyperplaneConvexSubset<P> plusBoundary = split.getPlus();
            if (minusBoundary != null) {
                minusBoundaries.add(boundaryType.cast(minusBoundary));
            }
            if (plusBoundary == null) continue;
            plusBoundaries.add(boundaryType.cast(plusBoundary));
        }
    }

    protected static class ConvexRegionBoundaryBuilder<P extends Point<P>, S extends HyperplaneConvexSubset<P>> {
        private final Class<S> subsetType;

        public ConvexRegionBoundaryBuilder(Class<S> subsetType) {
            this.subsetType = subsetType;
        }

        public List<S> build(Iterable<? extends Hyperplane<P>> bounds) {
            ArrayList<S> boundaries = new ArrayList<S>();
            int boundIdx = -1;
            for (Hyperplane<P> currentBound : bounds) {
                HyperplaneConvexSubset<P> boundary = this.splitBound(currentBound, bounds, ++boundIdx);
                if (boundary == null) continue;
                boundaries.add(this.subsetType.cast(boundary));
            }
            if (boundIdx > 0 && boundaries.isEmpty()) {
                throw this.nonConvexException(bounds);
            }
            return boundaries;
        }

        private HyperplaneConvexSubset<P> splitBound(Hyperplane<P> currentBound, Iterable<? extends Hyperplane<P>> bounds, int currentBoundIdx) {
            HyperplaneConvexSubset<P> boundary = currentBound.span();
            Iterator<Hyperplane<P>> boundsIt = bounds.iterator();
            int splitterIdx = -1;
            while (boundsIt.hasNext() && boundary != null) {
                Hyperplane<P> splitter = boundsIt.next();
                ++splitterIdx;
                if (currentBound == splitter) {
                    if (currentBoundIdx <= splitterIdx) continue;
                    return null;
                }
                Split<HyperplaneConvexSubset<P>> split = boundary.split(splitter);
                if (split.getLocation() != SplitLocation.NEITHER) {
                    boundary = split.getMinus();
                    continue;
                }
                if (!currentBound.similarOrientation(splitter)) {
                    throw this.nonConvexException(bounds);
                }
                if (currentBoundIdx <= splitterIdx) continue;
                return null;
            }
            return boundary;
        }

        private IllegalArgumentException nonConvexException(Iterable<? extends Hyperplane<P>> bounds) {
            return new IllegalArgumentException("Bounding hyperplanes do not produce a convex region: " + bounds);
        }
    }
}

