/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.io.euclidean.threed.stl;

import java.io.Closeable;
import java.io.Reader;
import java.util.Arrays;
import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.io.core.internal.GeometryIOUtils;
import org.apache.commons.geometry.io.core.internal.SimpleTextParser;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinition;
import org.apache.commons.geometry.io.euclidean.threed.FacetDefinitionReader;
import org.apache.commons.geometry.io.euclidean.threed.SimpleFacetDefinition;

public class TextStlFacetDefinitionReader
implements FacetDefinitionReader {
    private Reader reader;
    private SimpleTextParser parser;
    private boolean foundSolidStart;
    private boolean foundSolidEnd;
    private String solidName;

    public TextStlFacetDefinitionReader(Reader reader) {
        this.reader = reader;
        this.parser = new SimpleTextParser(reader);
    }

    public String getSolidName() {
        this.ensureSolidStarted();
        return this.solidName;
    }

    @Override
    public FacetDefinition readFacet() {
        if (!this.foundSolidEnd && this.parser.hasMoreCharacters()) {
            this.ensureSolidStarted();
            this.nextWord();
            int choice = this.parser.chooseIgnoreCase(new String[]{"facet", "endsolid"});
            if (choice == 0) {
                return this.readFacetInternal();
            }
            this.foundSolidEnd = true;
        }
        return null;
    }

    @Override
    public void close() {
        GeometryIOUtils.closeUnchecked((Closeable)this.reader);
    }

    private FacetDefinition readFacetInternal() {
        this.matchKeyword("normal");
        Vector3D normal = this.readVector();
        this.matchKeyword("outer");
        this.matchKeyword("loop");
        this.matchKeyword("vertex");
        Vector3D p1 = this.readVector();
        this.matchKeyword("vertex");
        Vector3D p2 = this.readVector();
        this.matchKeyword("vertex");
        Vector3D p3 = this.readVector();
        this.matchKeyword("endloop");
        this.matchKeyword("endfacet");
        return new SimpleFacetDefinition(Arrays.asList(p1, p2, p3), normal);
    }

    private void ensureSolidStarted() {
        if (!this.foundSolidStart) {
            this.beginSolid();
            this.foundSolidStart = true;
        }
    }

    private void beginSolid() {
        this.matchKeyword("solid");
        this.solidName = TextStlFacetDefinitionReader.trimmedOrNull(this.parser.nextLine().getCurrentToken());
    }

    private void nextWord() {
        this.parser.discardWhitespace().nextAlphanumeric();
    }

    private void matchKeyword(String keyword) {
        this.nextWord();
        this.parser.matchIgnoreCase(keyword);
    }

    private Vector3D readVector() {
        double x = this.readDouble();
        double y = this.readDouble();
        double z = this.readDouble();
        return Vector3D.of((double)x, (double)y, (double)z);
    }

    private double readDouble() {
        return this.parser.discardWhitespace().next(SimpleTextParser::isDecimalPart).getCurrentTokenAsDouble();
    }

    private static String trimmedOrNull(String str) {
        String trimmed;
        if (str != null && !(trimmed = str.trim()).isEmpty()) {
            return trimmed;
        }
        return null;
    }
}

